/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An envelope delay rule is a rule which determines how the envelope should be delayed either for sending or routing. It can expressed as either a delay in some number of days, hours, minutes and seconds or an exact resumeDate in the future.")
public class EnvelopeDelayRuleApiModel {
    @JsonProperty(value="delay")
    private String delay = null;
    @JsonProperty(value="resumeDate")
    private String resumeDate = null;

    public EnvelopeDelayRuleApiModel delay(String delay) {
        this.delay = delay;
        return this;
    }

    @Schema(description="A string timespan duration represented as d.hh:mm:ss where the d component is days, hh is hours measured on a 24-hour clock, mm is minutes and ss is seconds, indicating the expected delay for this envelope rule. The maximum delay is 30 days.")
    public String getDelay() {
        return this.delay;
    }

    public void setDelay(String delay) {
        this.delay = delay;
    }

    public EnvelopeDelayRuleApiModel resumeDate(String resumeDate) {
        this.resumeDate = resumeDate;
        return this;
    }

    @Schema(description="A string formatted as an ISO 8601 DATETIME with TimeZone specified, indicating the expected resumeDate for this envelope rule. The specified datetime must occur in the future relative to the current UTC time hen the request is made. The maximum resumeDate must not exceed 30 days in the future.")
    public String getResumeDate() {
        return this.resumeDate;
    }

    public void setResumeDate(String resumeDate) {
        this.resumeDate = resumeDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvelopeDelayRuleApiModel envelopeDelayRuleApiModel = (EnvelopeDelayRuleApiModel)o;
        return Objects.equals(this.delay, envelopeDelayRuleApiModel.delay) && Objects.equals(this.resumeDate, envelopeDelayRuleApiModel.resumeDate);
    }

    public int hashCode() {
        return Objects.hash(this.delay, this.resumeDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvelopeDelayRuleApiModel {\n");
        sb.append("    delay: ").append(this.toIndentedString(this.delay)).append("\n");
        sb.append("    resumeDate: ").append(this.toIndentedString(this.resumeDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

