/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.CurrencyFeatureSetPrice;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This object provides details about a feature set, or add-on product that is associated with an account. It is reserved for DocuSign internal use only.")
public class FeatureSet {
    @JsonProperty(value="currencyFeatureSetPrices")
    private List<CurrencyFeatureSetPrice> currencyFeatureSetPrices = null;
    @JsonProperty(value="envelopeFee")
    private String envelopeFee = null;
    @JsonProperty(value="featureSetId")
    private String featureSetId = null;
    @JsonProperty(value="fixedFee")
    private String fixedFee = null;
    @JsonProperty(value="is21CFRPart11")
    private String is21CFRPart11 = null;
    @JsonProperty(value="isActive")
    private String isActive = null;
    @JsonProperty(value="isEnabled")
    private String isEnabled = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="seatFee")
    private String seatFee = null;

    public FeatureSet currencyFeatureSetPrices(List<CurrencyFeatureSetPrice> currencyFeatureSetPrices) {
        this.currencyFeatureSetPrices = currencyFeatureSetPrices;
        return this;
    }

    public FeatureSet addCurrencyFeatureSetPricesItem(CurrencyFeatureSetPrice currencyFeatureSetPricesItem) {
        if (this.currencyFeatureSetPrices == null) {
            this.currencyFeatureSetPrices = new ArrayList<CurrencyFeatureSetPrice>();
        }
        this.currencyFeatureSetPrices.add(currencyFeatureSetPricesItem);
        return this;
    }

    @Schema(description="A complex type that contains alternate currency values that are configured for this plan feature set.")
    public List<CurrencyFeatureSetPrice> getCurrencyFeatureSetPrices() {
        return this.currencyFeatureSetPrices;
    }

    public void setCurrencyFeatureSetPrices(List<CurrencyFeatureSetPrice> currencyFeatureSetPrices) {
        this.currencyFeatureSetPrices = currencyFeatureSetPrices;
    }

    public FeatureSet envelopeFee(String envelopeFee) {
        this.envelopeFee = envelopeFee;
        return this;
    }

    @Schema(description="")
    public String getEnvelopeFee() {
        return this.envelopeFee;
    }

    public void setEnvelopeFee(String envelopeFee) {
        this.envelopeFee = envelopeFee;
    }

    public FeatureSet featureSetId(String featureSetId) {
        this.featureSetId = featureSetId;
        return this;
    }

    @Schema(description="A unique ID for the feature set.")
    public String getFeatureSetId() {
        return this.featureSetId;
    }

    public void setFeatureSetId(String featureSetId) {
        this.featureSetId = featureSetId;
    }

    public FeatureSet fixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
        return this;
    }

    @Schema(description="")
    public String getFixedFee() {
        return this.fixedFee;
    }

    public void setFixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
    }

    public FeatureSet is21CFRPart11(String is21CFRPart11) {
        this.is21CFRPart11 = is21CFRPart11;
        return this;
    }

    @Schema(description="When set to **true**, indicates that this module is enabled on the account.")
    public String getIs21CFRPart11() {
        return this.is21CFRPart11;
    }

    public void setIs21CFRPart11(String is21CFRPart11) {
        this.is21CFRPart11 = is21CFRPart11;
    }

    public FeatureSet isActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

    @Schema(description="")
    public String getIsActive() {
        return this.isActive;
    }

    public void setIsActive(String isActive) {
        this.isActive = isActive;
    }

    public FeatureSet isEnabled(String isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(description="Specifies whether the feature set is actively enabled as part of the plan.")
    public String getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(String isEnabled) {
        this.isEnabled = isEnabled;
    }

    public FeatureSet name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeatureSet seatFee(String seatFee) {
        this.seatFee = seatFee;
        return this;
    }

    @Schema(description="An incremental seat cost for seat-based plans. Only valid when isEnabled for the feature set is set to true.")
    public String getSeatFee() {
        return this.seatFee;
    }

    public void setSeatFee(String seatFee) {
        this.seatFee = seatFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSet featureSet = (FeatureSet)o;
        return Objects.equals(this.currencyFeatureSetPrices, featureSet.currencyFeatureSetPrices) && Objects.equals(this.envelopeFee, featureSet.envelopeFee) && Objects.equals(this.featureSetId, featureSet.featureSetId) && Objects.equals(this.fixedFee, featureSet.fixedFee) && Objects.equals(this.is21CFRPart11, featureSet.is21CFRPart11) && Objects.equals(this.isActive, featureSet.isActive) && Objects.equals(this.isEnabled, featureSet.isEnabled) && Objects.equals(this.name, featureSet.name) && Objects.equals(this.seatFee, featureSet.seatFee);
    }

    public int hashCode() {
        return Objects.hash(this.currencyFeatureSetPrices, this.envelopeFee, this.featureSetId, this.fixedFee, this.is21CFRPart11, this.isActive, this.isEnabled, this.name, this.seatFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSet {\n");
        sb.append("    currencyFeatureSetPrices: ").append(this.toIndentedString(this.currencyFeatureSetPrices)).append("\n");
        sb.append("    envelopeFee: ").append(this.toIndentedString(this.envelopeFee)).append("\n");
        sb.append("    featureSetId: ").append(this.toIndentedString(this.featureSetId)).append("\n");
        sb.append("    fixedFee: ").append(this.toIndentedString(this.fixedFee)).append("\n");
        sb.append("    is21CFRPart11: ").append(this.toIndentedString(this.is21CFRPart11)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    seatFee: ").append(this.toIndentedString(this.seatFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

