/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.RecipientOption;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Describes a group of recipients.")
public class RecipientGroup {
    @JsonProperty(value="groupMessage")
    private String groupMessage = null;
    @JsonProperty(value="groupName")
    private String groupName = null;
    @JsonProperty(value="recipients")
    private List<RecipientOption> recipients = null;

    public RecipientGroup groupMessage(String groupMessage) {
        this.groupMessage = groupMessage;
        return this;
    }

    @Schema(description="")
    public String getGroupMessage() {
        return this.groupMessage;
    }

    public void setGroupMessage(String groupMessage) {
        this.groupMessage = groupMessage;
    }

    public RecipientGroup groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Schema(description="The name of the group.")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public RecipientGroup recipients(List<RecipientOption> recipients) {
        this.recipients = recipients;
        return this;
    }

    public RecipientGroup addRecipientsItem(RecipientOption recipientsItem) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<RecipientOption>();
        }
        this.recipients.add(recipientsItem);
        return this;
    }

    @Schema(description="An array of powerform recipients.")
    public List<RecipientOption> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<RecipientOption> recipients) {
        this.recipients = recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientGroup recipientGroup = (RecipientGroup)o;
        return Objects.equals(this.groupMessage, recipientGroup.groupMessage) && Objects.equals(this.groupName, recipientGroup.groupName) && Objects.equals(this.recipients, recipientGroup.recipients);
    }

    public int hashCode() {
        return Objects.hash(this.groupMessage, this.groupName, this.recipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientGroup {\n");
        sb.append("    groupMessage: ").append(this.toIndentedString(this.groupMessage)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

