package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** This object contains information about the type of signature.. */
@Schema(description = "This object contains information about the type of signature.")
public class SignatureType {
  @JsonProperty("isDefault")
  private String isDefault = null;

  @JsonProperty("type")
  private String type = null;

  /**
   * isDefault.
   *
   * @return SignatureType
   */
  public SignatureType isDefault(String isDefault) {
    this.isDefault = isDefault;
    return this;
  }

  /**
   * .
   *
   * @return isDefault
   */
  @Schema(description = "")
  public String getIsDefault() {
    return isDefault;
  }

  /** setIsDefault. */
  public void setIsDefault(String isDefault) {
    this.isDefault = isDefault;
  }

  /**
   * type.
   *
   * @return SignatureType
   */
  public SignatureType type(String type) {
    this.type = type;
    return this;
  }

  /**
   * .
   *
   * @return type
   */
  @Schema(description = "")
  public String getType() {
    return type;
  }

  /** setType. */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignatureType signatureType = (SignatureType) o;
    return Objects.equals(this.isDefault, signatureType.isDefault)
        && Objects.equals(this.type, signatureType.type);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(isDefault, type);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignatureType {\n");

    sb.append("    isDefault: ").append(toIndentedString(isDefault)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
