/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.Filter;
import com.docusign.esign.model.FolderItemV2;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This object contains details about a folder.")
public class Folder {
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="filter")
    private Filter filter = null;
    @JsonProperty(value="folderId")
    private String folderId = null;
    @JsonProperty(value="folderItems")
    private List<FolderItemV2> folderItems = null;
    @JsonProperty(value="folders")
    private List<Folder> folders = null;
    @JsonProperty(value="hasAccess")
    private String hasAccess = null;
    @JsonProperty(value="hasSubFolders")
    private String hasSubFolders = null;
    @JsonProperty(value="itemCount")
    private String itemCount = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="owner")
    private UserInfo owner = null;
    @JsonProperty(value="parentFolderId")
    private String parentFolderId = null;
    @JsonProperty(value="parentFolderUri")
    private String parentFolderUri = null;
    @JsonProperty(value="subFolderCount")
    private String subFolderCount = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="uri")
    private String uri = null;

    public Folder errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Folder filter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Schema(description="An object used to present a filtered view of the items in a folder.")
    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Folder folderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    @Schema(description="")
    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public Folder folderItems(List<FolderItemV2> folderItems) {
        this.folderItems = folderItems;
        return this;
    }

    public Folder addFolderItemsItem(FolderItemV2 folderItemsItem) {
        if (this.folderItems == null) {
            this.folderItems = new ArrayList<FolderItemV2>();
        }
        this.folderItems.add(folderItemsItem);
        return this;
    }

    @Schema(description="A list of the envelopes in the specified folder or folders. ")
    public List<FolderItemV2> getFolderItems() {
        return this.folderItems;
    }

    public void setFolderItems(List<FolderItemV2> folderItems) {
        this.folderItems = folderItems;
    }

    public Folder folders(List<Folder> folders) {
        this.folders = folders;
        return this;
    }

    public Folder addFoldersItem(Folder foldersItem) {
        if (this.folders == null) {
            this.folders = new ArrayList<Folder>();
        }
        this.folders.add(foldersItem);
        return this;
    }

    @Schema(description="A collection of folder objects returned in a response.")
    public List<Folder> getFolders() {
        return this.folders;
    }

    public void setFolders(List<Folder> folders) {
        this.folders = folders;
    }

    public Folder hasAccess(String hasAccess) {
        this.hasAccess = hasAccess;
        return this;
    }

    @Schema(description="")
    public String getHasAccess() {
        return this.hasAccess;
    }

    public void setHasAccess(String hasAccess) {
        this.hasAccess = hasAccess;
    }

    public Folder hasSubFolders(String hasSubFolders) {
        this.hasSubFolders = hasSubFolders;
        return this;
    }

    @Schema(description="")
    public String getHasSubFolders() {
        return this.hasSubFolders;
    }

    public void setHasSubFolders(String hasSubFolders) {
        this.hasSubFolders = hasSubFolders;
    }

    public Folder itemCount(String itemCount) {
        this.itemCount = itemCount;
        return this;
    }

    @Schema(description="")
    public String getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(String itemCount) {
        this.itemCount = itemCount;
    }

    public Folder name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Folder owner(UserInfo owner) {
        this.owner = owner;
        return this;
    }

    @Schema(description="Information about the user who owns the folder.")
    public UserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(UserInfo owner) {
        this.owner = owner;
    }

    public Folder parentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    @Schema(description="")
    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Folder parentFolderUri(String parentFolderUri) {
        this.parentFolderUri = parentFolderUri;
        return this;
    }

    @Schema(description="")
    public String getParentFolderUri() {
        return this.parentFolderUri;
    }

    public void setParentFolderUri(String parentFolderUri) {
        this.parentFolderUri = parentFolderUri;
    }

    public Folder subFolderCount(String subFolderCount) {
        this.subFolderCount = subFolderCount;
        return this;
    }

    @Schema(description="")
    public String getSubFolderCount() {
        return this.subFolderCount;
    }

    public void setSubFolderCount(String subFolderCount) {
        this.subFolderCount = subFolderCount;
    }

    public Folder type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Folder uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(description="")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Folder folder = (Folder)o;
        return Objects.equals(this.errorDetails, folder.errorDetails) && Objects.equals(this.filter, folder.filter) && Objects.equals(this.folderId, folder.folderId) && Objects.equals(this.folderItems, folder.folderItems) && Objects.equals(this.folders, folder.folders) && Objects.equals(this.hasAccess, folder.hasAccess) && Objects.equals(this.hasSubFolders, folder.hasSubFolders) && Objects.equals(this.itemCount, folder.itemCount) && Objects.equals(this.name, folder.name) && Objects.equals(this.owner, folder.owner) && Objects.equals(this.parentFolderId, folder.parentFolderId) && Objects.equals(this.parentFolderUri, folder.parentFolderUri) && Objects.equals(this.subFolderCount, folder.subFolderCount) && Objects.equals(this.type, folder.type) && Objects.equals(this.uri, folder.uri);
    }

    public int hashCode() {
        return Objects.hash(this.errorDetails, this.filter, this.folderId, this.folderItems, this.folders, this.hasAccess, this.hasSubFolders, this.itemCount, this.name, this.owner, this.parentFolderId, this.parentFolderUri, this.subFolderCount, this.type, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Folder {\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        sb.append("    folderItems: ").append(this.toIndentedString(this.folderItems)).append("\n");
        sb.append("    folders: ").append(this.toIndentedString(this.folders)).append("\n");
        sb.append("    hasAccess: ").append(this.toIndentedString(this.hasAccess)).append("\n");
        sb.append("    hasSubFolders: ").append(this.toIndentedString(this.hasSubFolders)).append("\n");
        sb.append("    itemCount: ").append(this.toIndentedString(this.itemCount)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    parentFolderId: ").append(this.toIndentedString(this.parentFolderId)).append("\n");
        sb.append("    parentFolderUri: ").append(this.toIndentedString(this.parentFolderUri)).append("\n");
        sb.append("    subFolderCount: ").append(this.toIndentedString(this.subFolderCount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

