package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** This object contains details about a bulk send recipient.. */
@Schema(description = "This object contains details about a bulk send recipient.")
public class BulkSendingCopyRecipient implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("accessCode")
  private String accessCode = null;

  @JsonProperty("clientUserId")
  private String clientUserId = null;

  @JsonProperty("customFields")
  private java.util.List<String> customFields = null;

  @JsonProperty("deliveryMethod")
  private String deliveryMethod = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("emailNotification")
  private RecipientEmailNotification emailNotification = null;

  @JsonProperty("embeddedRecipientStartURL")
  private String embeddedRecipientStartURL = null;

  @JsonProperty("faxNumber")
  private String faxNumber = null;

  @JsonProperty("hostEmail")
  private String hostEmail = null;

  @JsonProperty("hostName")
  private String hostName = null;

  @JsonProperty("idCheckConfigurationName")
  private String idCheckConfigurationName = null;

  @JsonProperty("idCheckInformationInput")
  private IdCheckInformationInput idCheckInformationInput = null;

  @JsonProperty("identificationMethod")
  private String identificationMethod = null;

  @JsonProperty("identityVerification")
  private RecipientIdentityVerification identityVerification = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("note")
  private String note = null;

  @JsonProperty("phoneAuthentication")
  private RecipientPhoneAuthentication phoneAuthentication = null;

  @JsonProperty("recipientId")
  private String recipientId = null;

  @JsonProperty("recipientSignatureProviders")
  private java.util.List<RecipientSignatureProvider> recipientSignatureProviders = null;

  @JsonProperty("roleName")
  private String roleName = null;

  @JsonProperty("signerName")
  private String signerName = null;

  @JsonProperty("signingGroupId")
  private String signingGroupId = null;

  @JsonProperty("smsAuthentication")
  private RecipientSMSAuthentication smsAuthentication = null;

  @JsonProperty("socialAuthentications")
  private java.util.List<SocialAuthentication> socialAuthentications = null;

  @JsonProperty("tabs")
  private java.util.List<BulkSendingCopyTab> tabs = null;

  /**
   * accessCode.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient accessCode(String accessCode) {
    this.accessCode = accessCode;
    return this;
  }

  /**
   * If a value is provided, the recipient must enter the value as the access code to view and sign
   * the envelope. Maximum Length: 50 characters and it must conform to the account's access code
   * format setting. If blank, but the signer `accessCode` property is set in the envelope, then
   * that value is used. If blank and the signer `accessCode` property is not set, then the access
   * code is not required..
   *
   * @return accessCode
   */
  @Schema(
      description =
          "If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
  public String getAccessCode() {
    return accessCode;
  }

  /** setAccessCode. */
  public void setAccessCode(String accessCode) {
    this.accessCode = accessCode;
  }

  /**
   * clientUserId.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient clientUserId(String clientUserId) {
    this.clientUserId = clientUserId;
    return this;
  }

  /**
   * Specifies whether the recipient is embedded or remote. If the `clientUserId` property is not
   * null then the recipient is embedded. Note that if the `ClientUserId` property is set and either
   * `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to
   * **true**, an error is generated on sending.ng. Maximum length: 100 characters. .
   *
   * @return clientUserId
   */
  @Schema(
      description =
          "Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
  public String getClientUserId() {
    return clientUserId;
  }

  /** setClientUserId. */
  public void setClientUserId(String clientUserId) {
    this.clientUserId = clientUserId;
  }

  /**
   * customFields.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient customFields(java.util.List<String> customFields) {
    this.customFields = customFields;
    return this;
  }

  /**
   * addCustomFieldsItem.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient addCustomFieldsItem(String customFieldsItem) {
    if (this.customFields == null) {
      this.customFields = new java.util.ArrayList<>();
    }
    this.customFields.add(customFieldsItem);
    return this;
  }

  /**
   * An optional array of strings that allows the sender to provide custom data about the recipient.
   * This information is returned in the envelope status but otherwise not used by DocuSign. Each
   * customField string can be a maximum of 100 characters..
   *
   * @return customFields
   */
  @Schema(
      description =
          "An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
  public java.util.List<String> getCustomFields() {
    return customFields;
  }

  /** setCustomFields. */
  public void setCustomFields(java.util.List<String> customFields) {
    this.customFields = customFields;
  }

  /**
   * deliveryMethod.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient deliveryMethod(String deliveryMethod) {
    this.deliveryMethod = deliveryMethod;
    return this;
  }

  /**
   * Reserved: For DocuSign use only..
   *
   * @return deliveryMethod
   */
  @Schema(description = "Reserved: For DocuSign use only.")
  public String getDeliveryMethod() {
    return deliveryMethod;
  }

  /** setDeliveryMethod. */
  public void setDeliveryMethod(String deliveryMethod) {
    this.deliveryMethod = deliveryMethod;
  }

  /**
   * email.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient email(String email) {
    this.email = email;
    return this;
  }

  /**
   * .
   *
   * @return email
   */
  @Schema(description = "")
  public String getEmail() {
    return email;
  }

  /** setEmail. */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * emailNotification.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient emailNotification(RecipientEmailNotification emailNotification) {
    this.emailNotification = emailNotification;
    return this;
  }

  /**
   * A complex type that contains information sets the language of the recipient's email
   * information. **IMPORTANT**: If you enable email notification for one recipient, you must enable
   * email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb`
   * property settings. .
   *
   * @return emailNotification
   */
  @Schema(
      description =
          "A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings. ")
  public RecipientEmailNotification getEmailNotification() {
    return emailNotification;
  }

  /** setEmailNotification. */
  public void setEmailNotification(RecipientEmailNotification emailNotification) {
    this.emailNotification = emailNotification;
  }

  /**
   * embeddedRecipientStartURL.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient embeddedRecipientStartURL(String embeddedRecipientStartURL) {
    this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    return this;
  }

  /**
   * Specifies a sender provided valid URL string for redirecting an embedded recipient. When using
   * this option, the embedded recipient still receives an email from DocuSign, just as a remote
   * recipient would. When the document link in the email is clicked the recipient is redirected,
   * through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the
   * sender's system (the server responding to the URL) must request a recipient token to launch a
   * signing session. If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing
   * or viewing process directly at DocuSign. The signing or viewing action is initiated by the
   * DocuSign system and the transaction activity and Certificate of Completion records will reflect
   * this. In all other ways the process is identical to an embedded signing or viewing operation
   * that is launched by any partner. It is important to remember that in a typical embedded
   * workflow the authentication of an embedded recipient is the responsibility of the sending
   * application, DocuSign expects that senders will follow their own process for establishing the
   * recipient's identity. In this workflow the recipient goes through the sending application
   * before the embedded signing or viewing process in initiated. However, when the sending
   * application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to
   * the embedded signing or viewing process bypassing the sending application and any
   * authentication steps the sending application would use. In this case, DocuSign recommends that
   * you use one of the normal DocuSign authentication features (Access Code, Phone Authentication,
   * SMS Authentication, etc.) to verify the identity of the recipient. If the `clientUserId`
   * property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the
   * redirect URL and launch the standard signing process for the email recipient. Information can
   * be appended to the embedded recipient start URL using merge fields. The available merge fields
   * items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The
   * `customFields` property must be set fort the recipient or envelope. The merge fields are
   * enclosed in double brackets. *Example*: `http://senderHost/[[mergeField1]]/
   * beginSigningSession? [[mergeField2]]&[[mergeField3]]` .
   *
   * @return embeddedRecipientStartURL
   */
  @Schema(
      description =
          "Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ")
  public String getEmbeddedRecipientStartURL() {
    return embeddedRecipientStartURL;
  }

  /** setEmbeddedRecipientStartURL. */
  public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
    this.embeddedRecipientStartURL = embeddedRecipientStartURL;
  }

  /**
   * faxNumber.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient faxNumber(String faxNumber) {
    this.faxNumber = faxNumber;
    return this;
  }

  /**
   * Reserved:.
   *
   * @return faxNumber
   */
  @Schema(description = "Reserved:")
  public String getFaxNumber() {
    return faxNumber;
  }

  /** setFaxNumber. */
  public void setFaxNumber(String faxNumber) {
    this.faxNumber = faxNumber;
  }

  /**
   * hostEmail.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient hostEmail(String hostEmail) {
    this.hostEmail = hostEmail;
    return this;
  }

  /**
   * .
   *
   * @return hostEmail
   */
  @Schema(description = "")
  public String getHostEmail() {
    return hostEmail;
  }

  /** setHostEmail. */
  public void setHostEmail(String hostEmail) {
    this.hostEmail = hostEmail;
  }

  /**
   * hostName.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient hostName(String hostName) {
    this.hostName = hostName;
    return this;
  }

  /**
   * .
   *
   * @return hostName
   */
  @Schema(description = "")
  public String getHostName() {
    return hostName;
  }

  /** setHostName. */
  public void setHostName(String hostName) {
    this.hostName = hostName;
  }

  /**
   * idCheckConfigurationName.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient idCheckConfigurationName(String idCheckConfigurationName) {
    this.idCheckConfigurationName = idCheckConfigurationName;
    return this;
  }

  /**
   * Specifies authentication check by name. The names used here must be the same as the
   * authentication type names used by the account (these name can also be found in the web console
   * sending interface in the Identify list for a recipient,) This overrides any default
   * authentication setting. *Example*: Your account has ID Check and SMS Authentication available
   * and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID
   * check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use
   * SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number
   * information to the `smsAuthentication` node..
   *
   * @return idCheckConfigurationName
   */
  @Schema(
      description =
          "Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.")
  public String getIdCheckConfigurationName() {
    return idCheckConfigurationName;
  }

  /** setIdCheckConfigurationName. */
  public void setIdCheckConfigurationName(String idCheckConfigurationName) {
    this.idCheckConfigurationName = idCheckConfigurationName;
  }

  /**
   * idCheckInformationInput.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient idCheckInformationInput(
      IdCheckInformationInput idCheckInformationInput) {
    this.idCheckInformationInput = idCheckInformationInput;
    return this;
  }

  /**
   * An object that contains input information related to a recipient ID check..
   *
   * @return idCheckInformationInput
   */
  @Schema(
      description = "An object that contains input information related to a recipient ID check.")
  public IdCheckInformationInput getIdCheckInformationInput() {
    return idCheckInformationInput;
  }

  /** setIdCheckInformationInput. */
  public void setIdCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
    this.idCheckInformationInput = idCheckInformationInput;
  }

  /**
   * identificationMethod.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient identificationMethod(String identificationMethod) {
    this.identificationMethod = identificationMethod;
    return this;
  }

  /**
   * .
   *
   * @return identificationMethod
   */
  @Schema(description = "")
  public String getIdentificationMethod() {
    return identificationMethod;
  }

  /** setIdentificationMethod. */
  public void setIdentificationMethod(String identificationMethod) {
    this.identificationMethod = identificationMethod;
  }

  /**
   * identityVerification.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient identityVerification(
      RecipientIdentityVerification identityVerification) {
    this.identityVerification = identityVerification;
    return this;
  }

  /**
   * .
   *
   * @return identityVerification
   */
  @Schema(description = "")
  public RecipientIdentityVerification getIdentityVerification() {
    return identityVerification;
  }

  /** setIdentityVerification. */
  public void setIdentityVerification(RecipientIdentityVerification identityVerification) {
    this.identityVerification = identityVerification;
  }

  /**
   * name.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient name(String name) {
    this.name = name;
    return this;
  }

  /**
   * .
   *
   * @return name
   */
  @Schema(description = "")
  public String getName() {
    return name;
  }

  /** setName. */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * note.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient note(String note) {
    this.note = note;
    return this;
  }

  /**
   * Specifies a note that is unique to this recipient. This note is sent to the recipient via the
   * signing email. The note displays in the signing UI near the upper left corner of the document
   * on the signing screen. Maximum Length: 1000 characters..
   *
   * @return note
   */
  @Schema(
      description =
          "Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.")
  public String getNote() {
    return note;
  }

  /** setNote. */
  public void setNote(String note) {
    this.note = note;
  }

  /**
   * phoneAuthentication.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient phoneAuthentication(
      RecipientPhoneAuthentication phoneAuthentication) {
    this.phoneAuthentication = phoneAuthentication;
    return this;
  }

  /**
   * When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide
   * the recipient authentication method details. It contains the following elements: *
   * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number
   * they choose. * `senderProvidedNumbers`: ArrayOfStrings. A list of phone numbers the recipient
   * can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved
   * for DocuSign. .
   *
   * @return phoneAuthentication
   */
  @Schema(
      description =
          "When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide the recipient authentication method details. It contains the following elements:  * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number they choose. * `senderProvidedNumbers`: ArrayOfStrings.  A list of phone numbers the recipient can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved for DocuSign.  ")
  public RecipientPhoneAuthentication getPhoneAuthentication() {
    return phoneAuthentication;
  }

  /** setPhoneAuthentication. */
  public void setPhoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
    this.phoneAuthentication = phoneAuthentication;
  }

  /**
   * recipientId.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient recipientId(String recipientId) {
    this.recipientId = recipientId;
    return this;
  }

  /**
   * Unique for the recipient. It is used by the tab element to indicate which recipient is to sign
   * the Document..
   *
   * @return recipientId
   */
  @Schema(
      description =
          "Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
  public String getRecipientId() {
    return recipientId;
  }

  /** setRecipientId. */
  public void setRecipientId(String recipientId) {
    this.recipientId = recipientId;
  }

  /**
   * recipientSignatureProviders.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient recipientSignatureProviders(
      java.util.List<RecipientSignatureProvider> recipientSignatureProviders) {
    this.recipientSignatureProviders = recipientSignatureProviders;
    return this;
  }

  /**
   * addRecipientSignatureProvidersItem.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient addRecipientSignatureProvidersItem(
      RecipientSignatureProvider recipientSignatureProvidersItem) {
    if (this.recipientSignatureProviders == null) {
      this.recipientSignatureProviders = new java.util.ArrayList<>();
    }
    this.recipientSignatureProviders.add(recipientSignatureProvidersItem);
    return this;
  }

  /**
   * .
   *
   * @return recipientSignatureProviders
   */
  @Schema(description = "")
  public java.util.List<RecipientSignatureProvider> getRecipientSignatureProviders() {
    return recipientSignatureProviders;
  }

  /** setRecipientSignatureProviders. */
  public void setRecipientSignatureProviders(
      java.util.List<RecipientSignatureProvider> recipientSignatureProviders) {
    this.recipientSignatureProviders = recipientSignatureProviders;
  }

  /**
   * roleName.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

  /**
   * Optional element. Specifies the role name associated with the recipient.<br>
   * <br>
   * This is required when working with template recipients..
   *
   * @return roleName
   */
  @Schema(
      description =
          "Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
  public String getRoleName() {
    return roleName;
  }

  /** setRoleName. */
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  /**
   * signerName.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient signerName(String signerName) {
    this.signerName = signerName;
    return this;
  }

  /**
   * .
   *
   * @return signerName
   */
  @Schema(description = "")
  public String getSignerName() {
    return signerName;
  }

  /** setSignerName. */
  public void setSignerName(String signerName) {
    this.signerName = signerName;
  }

  /**
   * signingGroupId.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient signingGroupId(String signingGroupId) {
    this.signingGroupId = signingGroupId;
    return this;
  }

  /**
   * When set to **true** and the feature is enabled in the sender's account, the signing recipient
   * is required to draw signatures and initials at each signature/initial tab ( instead of adopting
   * a signature/initial style or only drawing a signature/initial once)..
   *
   * @return signingGroupId
   */
  @Schema(
      description =
          "When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
  public String getSigningGroupId() {
    return signingGroupId;
  }

  /** setSigningGroupId. */
  public void setSigningGroupId(String signingGroupId) {
    this.signingGroupId = signingGroupId;
  }

  /**
   * smsAuthentication.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient smsAuthentication(RecipientSMSAuthentication smsAuthentication) {
    this.smsAuthentication = smsAuthentication;
    return this;
  }

  /**
   * When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide
   * the recipient authentication method details. It contains the element `senderProvidedNumbers`,
   * which is an array of phone numbers that the recipient can use for SMS text authentication. .
   *
   * @return smsAuthentication
   */
  @Schema(
      description =
          "When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide the recipient authentication method details. It contains the element `senderProvidedNumbers`, which is an array of phone numbers that the recipient can use for SMS text authentication.   ")
  public RecipientSMSAuthentication getSmsAuthentication() {
    return smsAuthentication;
  }

  /** setSmsAuthentication. */
  public void setSmsAuthentication(RecipientSMSAuthentication smsAuthentication) {
    this.smsAuthentication = smsAuthentication;
  }

  /**
   * socialAuthentications.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient socialAuthentications(
      java.util.List<SocialAuthentication> socialAuthentications) {
    this.socialAuthentications = socialAuthentications;
    return this;
  }

  /**
   * addSocialAuthenticationsItem.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient addSocialAuthenticationsItem(
      SocialAuthentication socialAuthenticationsItem) {
    if (this.socialAuthentications == null) {
      this.socialAuthentications = new java.util.ArrayList<>();
    }
    this.socialAuthentications.add(socialAuthenticationsItem);
    return this;
  }

  /**
   * Lists the social ID type that can be used for recipient authentication..
   *
   * @return socialAuthentications
   */
  @Schema(description = " Lists the social ID type that can be used for recipient authentication.")
  public java.util.List<SocialAuthentication> getSocialAuthentications() {
    return socialAuthentications;
  }

  /** setSocialAuthentications. */
  public void setSocialAuthentications(java.util.List<SocialAuthentication> socialAuthentications) {
    this.socialAuthentications = socialAuthentications;
  }

  /**
   * tabs.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient tabs(java.util.List<BulkSendingCopyTab> tabs) {
    this.tabs = tabs;
    return this;
  }

  /**
   * addTabsItem.
   *
   * @return BulkSendingCopyRecipient
   */
  public BulkSendingCopyRecipient addTabsItem(BulkSendingCopyTab tabsItem) {
    if (this.tabs == null) {
      this.tabs = new java.util.ArrayList<>();
    }
    this.tabs.add(tabsItem);
    return this;
  }

  /**
   * .
   *
   * @return tabs
   */
  @Schema(description = "")
  public java.util.List<BulkSendingCopyTab> getTabs() {
    return tabs;
  }

  /** setTabs. */
  public void setTabs(java.util.List<BulkSendingCopyTab> tabs) {
    this.tabs = tabs;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BulkSendingCopyRecipient bulkSendingCopyRecipient = (BulkSendingCopyRecipient) o;
    return Objects.equals(this.accessCode, bulkSendingCopyRecipient.accessCode)
        && Objects.equals(this.clientUserId, bulkSendingCopyRecipient.clientUserId)
        && Objects.equals(this.customFields, bulkSendingCopyRecipient.customFields)
        && Objects.equals(this.deliveryMethod, bulkSendingCopyRecipient.deliveryMethod)
        && Objects.equals(this.email, bulkSendingCopyRecipient.email)
        && Objects.equals(this.emailNotification, bulkSendingCopyRecipient.emailNotification)
        && Objects.equals(
            this.embeddedRecipientStartURL, bulkSendingCopyRecipient.embeddedRecipientStartURL)
        && Objects.equals(this.faxNumber, bulkSendingCopyRecipient.faxNumber)
        && Objects.equals(this.hostEmail, bulkSendingCopyRecipient.hostEmail)
        && Objects.equals(this.hostName, bulkSendingCopyRecipient.hostName)
        && Objects.equals(
            this.idCheckConfigurationName, bulkSendingCopyRecipient.idCheckConfigurationName)
        && Objects.equals(
            this.idCheckInformationInput, bulkSendingCopyRecipient.idCheckInformationInput)
        && Objects.equals(this.identificationMethod, bulkSendingCopyRecipient.identificationMethod)
        && Objects.equals(this.identityVerification, bulkSendingCopyRecipient.identityVerification)
        && Objects.equals(this.name, bulkSendingCopyRecipient.name)
        && Objects.equals(this.note, bulkSendingCopyRecipient.note)
        && Objects.equals(this.phoneAuthentication, bulkSendingCopyRecipient.phoneAuthentication)
        && Objects.equals(this.recipientId, bulkSendingCopyRecipient.recipientId)
        && Objects.equals(
            this.recipientSignatureProviders, bulkSendingCopyRecipient.recipientSignatureProviders)
        && Objects.equals(this.roleName, bulkSendingCopyRecipient.roleName)
        && Objects.equals(this.signerName, bulkSendingCopyRecipient.signerName)
        && Objects.equals(this.signingGroupId, bulkSendingCopyRecipient.signingGroupId)
        && Objects.equals(this.smsAuthentication, bulkSendingCopyRecipient.smsAuthentication)
        && Objects.equals(
            this.socialAuthentications, bulkSendingCopyRecipient.socialAuthentications)
        && Objects.equals(this.tabs, bulkSendingCopyRecipient.tabs);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(
        accessCode,
        clientUserId,
        customFields,
        deliveryMethod,
        email,
        emailNotification,
        embeddedRecipientStartURL,
        faxNumber,
        hostEmail,
        hostName,
        idCheckConfigurationName,
        idCheckInformationInput,
        identificationMethod,
        identityVerification,
        name,
        note,
        phoneAuthentication,
        recipientId,
        recipientSignatureProviders,
        roleName,
        signerName,
        signingGroupId,
        smsAuthentication,
        socialAuthentications,
        tabs);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BulkSendingCopyRecipient {\n");

    sb.append("    accessCode: ").append(toIndentedString(accessCode)).append("\n");
    sb.append("    clientUserId: ").append(toIndentedString(clientUserId)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    deliveryMethod: ").append(toIndentedString(deliveryMethod)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    emailNotification: ").append(toIndentedString(emailNotification)).append("\n");
    sb.append("    embeddedRecipientStartURL: ")
        .append(toIndentedString(embeddedRecipientStartURL))
        .append("\n");
    sb.append("    faxNumber: ").append(toIndentedString(faxNumber)).append("\n");
    sb.append("    hostEmail: ").append(toIndentedString(hostEmail)).append("\n");
    sb.append("    hostName: ").append(toIndentedString(hostName)).append("\n");
    sb.append("    idCheckConfigurationName: ")
        .append(toIndentedString(idCheckConfigurationName))
        .append("\n");
    sb.append("    idCheckInformationInput: ")
        .append(toIndentedString(idCheckInformationInput))
        .append("\n");
    sb.append("    identificationMethod: ")
        .append(toIndentedString(identificationMethod))
        .append("\n");
    sb.append("    identityVerification: ")
        .append(toIndentedString(identityVerification))
        .append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    phoneAuthentication: ")
        .append(toIndentedString(phoneAuthentication))
        .append("\n");
    sb.append("    recipientId: ").append(toIndentedString(recipientId)).append("\n");
    sb.append("    recipientSignatureProviders: ")
        .append(toIndentedString(recipientSignatureProviders))
        .append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("    signerName: ").append(toIndentedString(signerName)).append("\n");
    sb.append("    signingGroupId: ").append(toIndentedString(signingGroupId)).append("\n");
    sb.append("    smsAuthentication: ").append(toIndentedString(smsAuthentication)).append("\n");
    sb.append("    socialAuthentications: ")
        .append(toIndentedString(socialAuthentications))
        .append("\n");
    sb.append("    tabs: ").append(toIndentedString(tabs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
