/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client;

import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.JSON;
import com.docusign.esign.client.Pair;
import com.docusign.esign.client.RFC3339DateFormat;
import com.docusign.esign.client.StringUtil;
import com.docusign.esign.client.auth.AccessTokenListener;
import com.docusign.esign.client.auth.ApiKeyAuth;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.HttpBasicAuth;
import com.docusign.esign.client.auth.JWTUtils;
import com.docusign.esign.client.auth.OAuth;
import com.docusign.esign.client.auth.OAuthFlow;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ApiClient {
    protected Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    public static final String PRODUCTION_REST_BASEPATH = "https://www.docusign.net/restapi";
    public static final String DEMO_REST_BASEPATH = "https://demo.docusign.net/restapi";
    public static final String STAGE_REST_BASEPATH = "https://stage.docusign.net/restapi";
    private String basePath = "https://demo.docusign.net/restapi";
    private String oAuthBasePath = "account.docusign.com";
    protected boolean debugging = false;
    protected int connectionTimeout = 0;
    private int readTimeout = 0;
    protected Client httpClient;
    protected JSON json = new JSON();
    protected String tempFolderPath = null;
    protected Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    protected DateFormat dateFormat;
    private SSLContext sslContext = null;
    private final String HTTPS = "https://";

    public ApiClient() {
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new RFC3339DateFormat();
        String javaVersion = System.getProperty("java.version");
        this.setUserAgent("Swagger-Codegen/v2.1/6.0.0-RC2/Java/" + javaVersion);
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("docusignAccessCode", new OAuth(this.httpClient));
        this.deriveOAuthBasePathFromRestBasePath();
    }

    public static DateFormat buildDefaultDateFormat() {
        return new RFC3339DateFormat();
    }

    public ApiClient(String basePath) {
        this();
        this.basePath = basePath;
        this.deriveOAuthBasePathFromRestBasePath();
    }

    public ApiClient(String oAuthBasePath, String[] authNames) {
        this();
        this.setOAuthBasePath(oAuthBasePath);
        for (String authName : authNames) {
            Authentication auth;
            if ("docusignAccessCode".equals(authName)) {
                auth = new OAuth(this.httpClient, OAuthFlow.accessCode, "https://" + oAuthBasePath + "/oauth/auth", "https://" + oAuthBasePath + "/oauth/token", "all");
            } else if ("docusignApiKey".equals(authName)) {
                auth = new ApiKeyAuth("header", "docusignApiKey");
            } else {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String oAuthBasePath, String authName) {
        this(oAuthBasePath, new String[]{authName});
    }

    public ApiClient(String oAuthBasePath, String authName, String clientId, String secret) {
        this(oAuthBasePath, authName);
        Authentication auth = this.authentications.get(authName);
        if (auth instanceof OAuth) {
            ((OAuth)auth).setClientId(clientId);
            ((OAuth)auth).setClientSecret(secret);
        }
    }

    public ApiClient rebuildHttpClient() {
        return this.setDebugging(this.debugging);
    }

    public ObjectMapper getObjectMapper() {
        return this.json.getObjectMapper();
    }

    public ApiClient setObjectMapper(ObjectMapper objectMapper) {
        this.json.setObjectMapper(objectMapper);
        this.rebuildHttpClient();
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.deriveOAuthBasePathFromRestBasePath();
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void addAuthorization(String authName, Authentication auth) {
        this.authentications.put(authName, auth);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void updateAccessToken() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            try {
                ((OAuth)auth).updateAccessToken();
            }
            catch (ApiException e) {
                throw new RuntimeException(e.getMessage());
            }
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public void setAccessToken(String accessToken, Long expiresIn) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken, expiresIn);
            return;
        }
        OAuth oAuth = new OAuth();
        oAuth.setAccessToken(accessToken, expiresIn);
        this.addAuthorization("docusignAccessCode", oAuth);
    }

    public String getAccessToken() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            return ((OAuth)auth).getAccessToken();
        }
        return null;
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.httpClient = this.buildHttpClient(debugging);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.httpClient.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public void configureAuthorizationFlow(String clientId, String clientSecret, String redirectURI) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            ((OAuth)auth).setClientId(clientId);
            ((OAuth)auth).setClientSecret(clientSecret);
            ((OAuth)auth).setRedirectURI(redirectURI);
            return;
        }
    }

    public String getAuthorizationUri() {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            return oauth.getAuthorizationUrl();
        }
        return null;
    }

    public URI getAuthorizationUri(String clientId, List<String> scopes, String redirectUri, String responseType, String state) throws IllegalArgumentException, UriBuilderException {
        String formattedScopes = scopes == null || scopes.size() < 1 ? "" : scopes.get(0);
        StringBuilder sb = new StringBuilder(formattedScopes);
        for (int i = 1; i < scopes.size(); ++i) {
            sb.append("%20" + scopes.get(i));
        }
        UriBuilder builder = UriBuilder.fromUri((String)this.getOAuthBasePath()).scheme("https").path("/oauth/auth").queryParam("response_type", new Object[]{responseType}).queryParam("scope", new Object[]{sb.toString()}).queryParam("client_id", new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirectUri});
        if (state != null) {
            builder = builder.queryParam("state", new Object[]{state});
        }
        return builder.build(new Object[0]);
    }

    public URI getAuthorizationUri(String clientId, List<String> scopes, String redirectUri, String responseType) throws IllegalArgumentException, UriBuilderException {
        return this.getAuthorizationUri(clientId, scopes, redirectUri, responseType, null);
    }

    private void deriveOAuthBasePathFromRestBasePath() {
        this.oAuthBasePath = this.basePath == null ? "account-d.docusign.com" : (this.basePath.startsWith("https://demo") || this.basePath.startsWith("http://demo") || this.basePath.startsWith("https://apps-d") || this.basePath.startsWith("http://apps-d") ? "account-d.docusign.com" : (this.basePath.startsWith("https://stage") || this.basePath.startsWith("http://stage") || this.basePath.startsWith("https://apps-s") || this.basePath.startsWith("http://apps-s") ? "account-s.docusign.com" : "account.docusign.com"));
    }

    private String getOAuthBasePath() {
        return this.oAuthBasePath;
    }

    public ApiClient setOAuthBasePath(String oAuthBasePath) {
        this.oAuthBasePath = oAuthBasePath;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth.OAuthToken generateAccessToken(String clientId, String clientSecret, String code) throws ApiException, IOException {
        String clientStr = (clientId == null ? "" : clientId) + ":" + (clientSecret == null ? "" : clientSecret);
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("code", code);
        form.put("grant_type", "authorization_code");
        Client client = this.buildHttpClient(this.debugging);
        WebTarget target = client.target("https://" + this.getOAuthBasePath() + "/oauth/token");
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(clientStr.getBytes(StandardCharsets.UTF_8)))).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Entity<?> entity = this.serialize(null, form, "application/x-www-form-urlencoded");
        Response response = null;
        try {
            response = invocationBuilder.post(entity);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<OAuth.OAuthToken> returnType = new GenericType<OAuth.OAuthToken>(){};
            OAuth.OAuthToken oAuthToken = this.deserialize(response, returnType);
            return oAuthToken;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth.UserInfo getUserInfo(String accessToken) throws IllegalArgumentException, ApiException {
        if (accessToken == null || "".equals(accessToken)) {
            throw new IllegalArgumentException("Cannot find a valid access token. Make sure OAuth is configured before you try again.");
        }
        Client client = this.buildHttpClient(this.debugging);
        WebTarget target = client.target("https://" + this.getOAuthBasePath() + "/oauth/userinfo");
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Authorization", (Object)("Bearer " + accessToken)).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Response response = null;
        try {
            response = invocationBuilder.get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<OAuth.UserInfo> returnType = new GenericType<OAuth.UserInfo>(){};
            OAuth.UserInfo userInfo = this.deserialize(response, returnType);
            return userInfo;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            OAuth oauth = (OAuth)auth;
            oauth.registerAccessTokenListener(accessTokenListener);
            return;
        }
    }

    public String getJWTUri(String clientId, String redirectURI, String oAuthBasePath) {
        return UriBuilder.fromUri((String)oAuthBasePath).scheme("https").path("/oauth/auth").queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{"signature%20impersonation"}).queryParam("client_id", new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirectURI}).build(new Object[0]).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void configureJWTAuthorizationFlow(String publicKeyFilename, String privateKeyFilename, String oAuthBasePath, String clientId, String userId, long expiresIn) throws ApiException, IOException {
        String assertion = JWTUtils.generateJWTAssertion(publicKeyFilename, privateKeyFilename, oAuthBasePath, clientId, userId, expiresIn);
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("assertion", assertion);
        form.put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        Client client = this.buildHttpClient(this.debugging);
        WebTarget target = client.target("https://" + oAuthBasePath + "/oauth/token");
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Entity<?> entity = this.serialize(null, form, "application/x-www-form-urlencoded");
        Response response = null;
        try {
            response = invocationBuilder.post(entity);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<JsonNode> returnType = new GenericType<JsonNode>(){};
            JsonNode responseJson = this.deserialize(response, returnType);
            if (!responseJson.has("access_token") || !responseJson.has("expires_in")) {
                throw new ApiException("Error while requesting an access token: " + responseJson);
            }
            String accessToken = responseJson.get("access_token").asText();
            expiresIn = responseJson.get("expires_in").asLong();
            this.setAccessToken(accessToken, expiresIn);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth.OAuthToken requestJWTUserToken(String clientId, String userId, List<String> scopes, byte[] rsaPrivateKey, long expiresIn) throws IllegalArgumentException, ApiException, IOException {
        String formattedScopes = scopes == null || scopes.size() < 1 ? "" : scopes.get(0);
        StringBuilder sb = new StringBuilder(formattedScopes);
        for (int i = 1; i < scopes.size(); ++i) {
            sb.append(" " + scopes.get(i));
        }
        String assertion = JWTUtils.generateJWTAssertionFromByteArray(rsaPrivateKey, this.getOAuthBasePath(), clientId, userId, expiresIn, sb.toString());
        HashMap<String, Object> form = new HashMap<String, Object>();
        form.put("assertion", assertion);
        form.put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        Client client = this.buildHttpClient(this.debugging);
        WebTarget target = client.target("https://" + this.getOAuthBasePath() + "/oauth/token");
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder = invocationBuilder.header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache");
        Entity<?> entity = this.serialize(null, form, "application/x-www-form-urlencoded");
        Response response = null;
        try {
            response = invocationBuilder.post(entity);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                String message = "error";
                String respBody = null;
                if (response.hasEntity()) {
                    try {
                        respBody = String.valueOf(response.readEntity(String.class));
                        message = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), message, this.buildResponseHeaders(response), respBody);
            }
            GenericType<OAuth.OAuthToken> returnType = new GenericType<OAuth.OAuthToken>(){};
            OAuth.OAuthToken oAuthToken = this.deserialize(response, returnType);
            if (oAuthToken.getAccessToken() == null || "".equals(oAuthToken.getAccessToken()) || oAuthToken.getExpiresIn() <= 0L) {
                throw new ApiException("Error while requesting an access token: " + response.toString());
            }
            OAuth.OAuthToken oAuthToken2 = oAuthToken;
            return oAuthToken2;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public OAuth.OAuthToken requestJWTApplicationToken(String clientId, List<String> scopes, byte[] rsaPrivateKey, long expiresIn) throws IllegalArgumentException, IOException, ApiException {
        return this.requestJWTUserToken(clientId, null, scopes, rsaPrivateKey, expiresIn);
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Object serialize(Object obj, String contentType, Map<String, Object> formParams) throws ApiException {
        return this.serialize(obj, formParams, contentType).getEntity();
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) throws ApiException {
        Entity entity;
        if (contentType.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                FormDataContentDisposition contentDisp;
                if (param.getValue() instanceof byte[]) {
                    byte[] bytes = (byte[])param.getValue();
                    contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(param.getKey())).size((long)bytes.length)).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)bytes, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                FormDataContentDisposition contentDisp2 = FormDataContentDisposition.name((String)param.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp2, this.parameterToString(param.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            if (contentType.startsWith("text/csv")) {
                return this.serializeToCsv(obj);
            }
            entity = Entity.entity((Object)obj, (String)contentType);
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (returnType.getRawType() == File.class) {
            File file = this.downloadFileFromResponse(response);
            return (T)file;
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        return (T)response.readEntity(returnType);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        void var14_20;
        Entity<?> entity;
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        WebTarget target = this.httpClient.target(this.basePath + path);
        if (queryParams != null) {
            for (Pair pair : queryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{pair.getValue()});
            }
        }
        if (collectionQueryParams != null) {
            for (Pair pair : collectionQueryParams) {
                if (pair.getValue() == null) continue;
                target = target.queryParam(pair.getName(), new Object[]{pair.getValue()});
            }
        }
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{accept});
        for (Map.Entry<String, String> entry : headerParams.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            invocationBuilder = invocationBuilder.header(entry.getKey(), (Object)string);
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            String value;
            String string = entry.getKey();
            if (headerParams.containsKey(string) || (value = entry.getValue()) == null) continue;
            invocationBuilder = invocationBuilder.header(string, (Object)value);
        }
        Entity<?> entity2 = entity = body == null && formParams.isEmpty() ? Entity.json((Object)"{}") : this.serialize(body, formParams, contentType);
        if (contentType.startsWith("multipart/form-data")) {
            for (Map.Entry entry : formParams.entrySet()) {
                BodyPart bodyPart;
                MultiPart mp;
                List bodyParts;
                if (!(entry.getValue() instanceof byte[]) || (bodyParts = (mp = (MultiPart)var14_20.getEntity()).getBodyParts()).isEmpty() || (bodyPart = (BodyPart)bodyParts.get(0)).getContentDisposition() == null) continue;
                String contentDispositionValue = bodyPart.getContentDisposition().toString();
                invocationBuilder = invocationBuilder.header("Content-Disposition", (Object)contentDispositionValue);
                Entity entity3 = Entity.entity(entry.getValue(), (String)"application/octet-stream");
            }
        }
        invocationBuilder = invocationBuilder.header("X-DocuSign-SDK", (Object)"Java");
        if (body == null && formParams.isEmpty()) {
            invocationBuilder = invocationBuilder.header("Content-Length", (Object)"0");
        }
        Response response = null;
        String string = "error";
        String respBody = null;
        try {
            void var16_32;
            T t;
            if ("GET".equals(method)) {
                response = invocationBuilder.get();
            } else if ("POST".equals(method)) {
                response = invocationBuilder.post((Entity)var14_20);
            } else if ("PUT".equals(method)) {
                response = invocationBuilder.put((Entity)var14_20);
            } else if ("DELETE".equals(method)) {
                response = invocationBuilder.method("DELETE", (Entity)var14_20);
            } else if ("PATCH".equals(method)) {
                response = invocationBuilder.method("PATCH", (Entity)var14_20);
            } else {
                if (!"HEAD".equals(method)) throw new ApiException(500, "unknown method type " + method);
                response = invocationBuilder.head();
            }
            this.statusCode = response.getStatusInfo().getStatusCode();
            this.responseHeaders = this.buildResponseHeaders(response);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                void var16_30;
                if (!response.hasEntity()) throw new ApiException(response.getStatusInfo().getStatusCode(), (String)var16_30, this.buildResponseHeaders(response), respBody);
                try {
                    respBody = String.valueOf(response.readEntity(String.class));
                    String string2 = "Error while requesting server, received a non successful HTTP code " + response.getStatusInfo().getStatusCode() + " with response Body: '" + respBody + "'";
                    throw new ApiException(response.getStatusInfo().getStatusCode(), (String)var16_30, this.buildResponseHeaders(response), respBody);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw new ApiException(response.getStatusInfo().getStatusCode(), (String)var16_30, this.buildResponseHeaders(response), respBody);
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                t = null;
                return t;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (returnType == null) {
                    t = null;
                    return t;
                }
                t = this.deserialize(response, returnType);
                return t;
            }
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), (String)var16_32, this.buildResponseHeaders(response), respBody);
            try {
                String string3 = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), (String)var16_32, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), (String)var16_32, this.buildResponseHeaders(response), respBody);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private Entity<?> serializeToCsv(Object obj) {
        if (obj == null) {
            return Entity.text((Object)"");
        }
        if (obj.getClass() == byte[].class) {
            return Entity.entity((Object)new String((byte[])obj), (MediaType)new MediaType("text", "csv"));
        }
        for (Method method : obj.getClass().getMethods()) {
            if (!"java.util.List".equals(method.getReturnType().getName())) continue;
            try {
                List itemList = (List)method.invoke(obj, new Object[0]);
                Object entry = itemList.get(0);
                ArrayList<String> stringList = new ArrayList<String>();
                char delimiter = ',';
                String lineSep = "\n";
                CsvMapper mapper = new CsvMapper();
                mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
                CsvSchema schema = mapper.schemaFor(entry.getClass());
                for (int i = 0; i < itemList.size(); ++i) {
                    schema = i == 0 ? schema.withHeader() : schema.withoutHeader();
                    String csv = mapper.writer((FormatSchema)schema.withColumnSeparator(delimiter).withoutQuoteChar().withLineSeparator(lineSep)).writeValueAsString(itemList.get(i));
                    stringList.add(csv);
                }
                return Entity.entity((Object)StringUtil.join(stringList.toArray(new String[0]), ""), (MediaType)new MediaType("text", "csv"));
            }
            catch (JsonProcessingException e) {
                System.out.println((Object)e);
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e);
            }
            catch (InvocationTargetException e) {
                System.out.println(e);
            }
        }
        return Entity.entity((Object)"", (MediaType)new MediaType("text", "csv"));
    }

    protected Client buildHttpClient(boolean debugging) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (debugging) {
            clientConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(51200)));
            clientConfig.property("jersey.config.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
            Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME).setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.glassfish.jersey.client").setLevel(Level.SEVERE);
        }
        this.performAdditionalClientConfiguration(clientConfig);
        try {
            String[] supportedProtocols = SSLContext.getDefault().createSSLEngine().getEnabledProtocols();
            if (!Arrays.asList(supportedProtocols).contains("TLSv1.2")) {
                throw new SecurityException("Docusign Java SDK requires TLSv1.2 Protocol");
            }
        }
        catch (SecurityException se) {
            System.err.println(se.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            System.err.println(nsae.getMessage());
        }
        if (this.sslContext == null) {
            try {
                this.sslContext = SSLContext.getInstance("TLSv1.2");
                this.sslContext.init(null, new TrustManager[]{new SecureTrustManager()}, new SecureRandom());
            }
            catch (Exception ex) {
                System.err.println("failed to initialize SSL context");
            }
        }
        clientConfig.connectorProvider(new ConnectorProvider(){
            Proxy p = null;

            private boolean isNonProxyHost(String host, String nonProxyHosts) {
                if (null == host || null == nonProxyHosts) {
                    return false;
                }
                for (String spec : nonProxyHosts.split("\\|")) {
                    int length = spec.length();
                    StringBuilder sb = new StringBuilder(length);
                    block5: for (int i = 0; i < length; ++i) {
                        char c = spec.charAt(i);
                        switch (c) {
                            case '*': {
                                sb.append(".*");
                                continue block5;
                            }
                            case '.': {
                                sb.append("\\.");
                                continue block5;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    if (!host.matches(sb.toString())) continue;
                    return true;
                }
                return false;
            }

            public Connector getConnector(Client client, Configuration configuration) {
                HttpUrlConnectorProvider customConnProv = new HttpUrlConnectorProvider();
                customConnProv.connectionFactory(new HttpUrlConnectorProvider.ConnectionFactory(){

                    public HttpURLConnection getConnection(URL url) throws IOException {
                        if (url == null) {
                            return null;
                        }
                        if (this.isNonProxyHost(url.getHost(), System.getProperty("http.nonProxyHosts"))) {
                            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(Proxy.NO_PROXY);
                            connection.setSSLSocketFactory(ApiClient.this.sslContext.getSocketFactory());
                            return connection;
                        }
                        if (p == null) {
                            Integer port;
                            String host;
                            if (System.getProperty("https.proxyHost") != null) {
                                host = System.getProperty("https.proxyHost");
                                port = Integer.getInteger("https.proxyPort");
                                if (host != null && port != null) {
                                    p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)port));
                                }
                                final String user = System.getProperty("https.proxyUser");
                                final String password = System.getProperty("https.proxyPassword");
                                if (user != null && password != null) {
                                    Authenticator.setDefault(new Authenticator(){

                                        @Override
                                        protected PasswordAuthentication getPasswordAuthentication() {
                                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(host) && port.intValue() == this.getRequestingPort()) {
                                                return new PasswordAuthentication(user, password.toCharArray());
                                            }
                                            return null;
                                        }
                                    });
                                }
                            } else if (System.getProperty("http.proxyHost") != null) {
                                host = System.getProperty("http.proxyHost");
                                port = Integer.getInteger("http.proxyPort");
                                if (host != null && port != null) {
                                    p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)port));
                                }
                                final String user = System.getProperty("http.proxyUser");
                                final String password = System.getProperty("http.proxyPassword");
                                if (user != null && password != null) {
                                    Authenticator.setDefault(new Authenticator(){

                                        @Override
                                        protected PasswordAuthentication getPasswordAuthentication() {
                                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(host) && port.intValue() == this.getRequestingPort()) {
                                                return new PasswordAuthentication(user, password.toCharArray());
                                            }
                                            return null;
                                        }
                                    });
                                }
                            }
                            if (p == null) {
                                p = Proxy.NO_PROXY;
                            }
                        }
                        InsecureHostnameVerifier allHostsValid = new InsecureHostnameVerifier();
                        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(p);
                        connection.setSSLSocketFactory(ApiClient.this.sslContext.getSocketFactory());
                        connection.setHostnameVerifier(allHostsValid);
                        return connection;
                    }
                });
                return customConnProv.getConnector(client, configuration);
            }
        });
        return ClientBuilder.newBuilder().sslContext(this.sslContext).withConfig((Configuration)clientConfig).build();
    }

    protected void performAdditionalClientConfiguration(ClientConfig clientConfig) {
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), headers);
        }
        return responseHeaders;
    }

    protected void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    class SecureTrustManager
    implements X509TrustManager {
        SecureTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public boolean isClientTrusted(X509Certificate[] arg0) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] arg0) {
            return true;
        }
    }

    class InsecureHostnameVerifier
    implements HostnameVerifier {
        InsecureHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

