/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AuthenticationStatus;
import com.docusign.esign.model.ConsentDetails;
import com.docusign.esign.model.DocumentVisibility;
import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.FeatureAvailableMetadata;
import com.docusign.esign.model.IdCheckInformationInput;
import com.docusign.esign.model.PropertyMetadata;
import com.docusign.esign.model.RecipientAdditionalNotification;
import com.docusign.esign.model.RecipientAttachment;
import com.docusign.esign.model.RecipientEmailNotification;
import com.docusign.esign.model.RecipientIdentityVerification;
import com.docusign.esign.model.RecipientPhoneAuthentication;
import com.docusign.esign.model.RecipientPhoneNumber;
import com.docusign.esign.model.RecipientProofFile;
import com.docusign.esign.model.RecipientSMSAuthentication;
import com.docusign.esign.model.SocialAuthentication;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains information about an intermediary recipient. An intermediary is a recipient who can, but is not required to, add name and email information for recipients at the same or subsequent level in the routing order, unless subsequent agents, editors or intermediaries are added.")
public class Intermediary
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accessCode")
    private String accessCode = null;
    @JsonProperty(value="accessCodeMetadata")
    private PropertyMetadata accessCodeMetadata = null;
    @JsonProperty(value="addAccessCodeToEmail")
    private String addAccessCodeToEmail = null;
    @JsonProperty(value="additionalNotifications")
    private List<RecipientAdditionalNotification> additionalNotifications = null;
    @JsonProperty(value="allowSystemOverrideForLockedRecipient")
    private String allowSystemOverrideForLockedRecipient = null;
    @JsonProperty(value="autoRespondedReason")
    private String autoRespondedReason = null;
    @JsonProperty(value="bulkSendV2Recipient")
    private String bulkSendV2Recipient = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="completedCount")
    private String completedCount = null;
    @JsonProperty(value="consentDetailsList")
    private List<ConsentDetails> consentDetailsList = null;
    @JsonProperty(value="customFields")
    private List<String> customFields = null;
    @JsonProperty(value="declinedDateTime")
    private String declinedDateTime = null;
    @JsonProperty(value="declinedReason")
    private String declinedReason = null;
    @JsonProperty(value="deliveredDateTime")
    private String deliveredDateTime = null;
    @JsonProperty(value="deliveryMethod")
    private String deliveryMethod = null;
    @JsonProperty(value="deliveryMethodMetadata")
    private PropertyMetadata deliveryMethodMetadata = null;
    @JsonProperty(value="designatorId")
    private String designatorId = null;
    @JsonProperty(value="designatorIdGuid")
    private String designatorIdGuid = null;
    @JsonProperty(value="documentTemplateId")
    private String documentTemplateId = null;
    @JsonProperty(value="documentVisibility")
    private List<DocumentVisibility> documentVisibility = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="emailMetadata")
    private PropertyMetadata emailMetadata = null;
    @JsonProperty(value="emailNotification")
    private RecipientEmailNotification emailNotification = null;
    @JsonProperty(value="emailRecipientPostSigningURL")
    private String emailRecipientPostSigningURL = null;
    @JsonProperty(value="embeddedRecipientStartURL")
    private String embeddedRecipientStartURL = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="excludedDocuments")
    private List<String> excludedDocuments = null;
    @JsonProperty(value="faxNumber")
    private String faxNumber = null;
    @JsonProperty(value="faxNumberMetadata")
    private PropertyMetadata faxNumberMetadata = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="firstNameMetadata")
    private PropertyMetadata firstNameMetadata = null;
    @JsonProperty(value="fullName")
    private String fullName = null;
    @JsonProperty(value="fullNameMetadata")
    private PropertyMetadata fullNameMetadata = null;
    @JsonProperty(value="idCheckConfigurationName")
    private String idCheckConfigurationName = null;
    @JsonProperty(value="idCheckConfigurationNameMetadata")
    private PropertyMetadata idCheckConfigurationNameMetadata = null;
    @JsonProperty(value="idCheckInformationInput")
    private IdCheckInformationInput idCheckInformationInput = null;
    @JsonProperty(value="identityVerification")
    private RecipientIdentityVerification identityVerification = null;
    @JsonProperty(value="inheritEmailNotificationConfiguration")
    private String inheritEmailNotificationConfiguration = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="lastNameMetadata")
    private PropertyMetadata lastNameMetadata = null;
    @JsonProperty(value="lockedRecipientPhoneAuthEditable")
    private String lockedRecipientPhoneAuthEditable = null;
    @JsonProperty(value="lockedRecipientSmsEditable")
    private String lockedRecipientSmsEditable = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="nameMetadata")
    private PropertyMetadata nameMetadata = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="noteMetadata")
    private PropertyMetadata noteMetadata = null;
    @JsonProperty(value="phoneAuthentication")
    private RecipientPhoneAuthentication phoneAuthentication = null;
    @JsonProperty(value="phoneNumber")
    private RecipientPhoneNumber phoneNumber = null;
    @JsonProperty(value="proofFile")
    private RecipientProofFile proofFile = null;
    @JsonProperty(value="recipientAttachments")
    private List<RecipientAttachment> recipientAttachments = null;
    @JsonProperty(value="recipientAuthenticationStatus")
    private AuthenticationStatus recipientAuthenticationStatus = null;
    @JsonProperty(value="recipientFeatureMetadata")
    private List<FeatureAvailableMetadata> recipientFeatureMetadata = null;
    @JsonProperty(value="recipientId")
    private String recipientId = null;
    @JsonProperty(value="recipientIdGuid")
    private String recipientIdGuid = null;
    @JsonProperty(value="recipientType")
    private String recipientType = null;
    @JsonProperty(value="recipientTypeMetadata")
    private PropertyMetadata recipientTypeMetadata = null;
    @JsonProperty(value="requireIdLookup")
    private String requireIdLookup = null;
    @JsonProperty(value="requireIdLookupMetadata")
    private PropertyMetadata requireIdLookupMetadata = null;
    @JsonProperty(value="roleName")
    private String roleName = null;
    @JsonProperty(value="routingOrder")
    private String routingOrder = null;
    @JsonProperty(value="routingOrderMetadata")
    private PropertyMetadata routingOrderMetadata = null;
    @JsonProperty(value="sentDateTime")
    private String sentDateTime = null;
    @JsonProperty(value="signedDateTime")
    private String signedDateTime = null;
    @JsonProperty(value="signingGroupId")
    private String signingGroupId = null;
    @JsonProperty(value="signingGroupIdMetadata")
    private PropertyMetadata signingGroupIdMetadata = null;
    @JsonProperty(value="signingGroupName")
    private String signingGroupName = null;
    @JsonProperty(value="signingGroupUsers")
    private List<UserInfo> signingGroupUsers = null;
    @JsonProperty(value="smsAuthentication")
    private RecipientSMSAuthentication smsAuthentication = null;
    @JsonProperty(value="socialAuthentications")
    private List<SocialAuthentication> socialAuthentications = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="statusCode")
    private String statusCode = null;
    @JsonProperty(value="suppressEmails")
    private String suppressEmails = null;
    @JsonProperty(value="templateLocked")
    private String templateLocked = null;
    @JsonProperty(value="templateRequired")
    private String templateRequired = null;
    @JsonProperty(value="totalTabCount")
    private String totalTabCount = null;
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="webFormRecipientViewId")
    private String webFormRecipientViewId = null;

    public Intermediary accessCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    @Schema(description="If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.")
    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public Intermediary accessCodeMetadata(PropertyMetadata accessCodeMetadata) {
        this.accessCodeMetadata = accessCodeMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `accessCode` property is editable. This property is read-only.")
    public PropertyMetadata getAccessCodeMetadata() {
        return this.accessCodeMetadata;
    }

    public void setAccessCodeMetadata(PropertyMetadata accessCodeMetadata) {
        this.accessCodeMetadata = accessCodeMetadata;
    }

    public Intermediary addAccessCodeToEmail(String addAccessCodeToEmail) {
        this.addAccessCodeToEmail = addAccessCodeToEmail;
        return this;
    }

    @Schema(description="This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.")
    public String getAddAccessCodeToEmail() {
        return this.addAccessCodeToEmail;
    }

    public void setAddAccessCodeToEmail(String addAccessCodeToEmail) {
        this.addAccessCodeToEmail = addAccessCodeToEmail;
    }

    public Intermediary additionalNotifications(List<RecipientAdditionalNotification> additionalNotifications) {
        this.additionalNotifications = additionalNotifications;
        return this;
    }

    public Intermediary addAdditionalNotificationsItem(RecipientAdditionalNotification additionalNotificationsItem) {
        if (this.additionalNotifications == null) {
            this.additionalNotifications = new ArrayList<RecipientAdditionalNotification>();
        }
        this.additionalNotifications.add(additionalNotificationsItem);
        return this;
    }

    @Schema(description="")
    public List<RecipientAdditionalNotification> getAdditionalNotifications() {
        return this.additionalNotifications;
    }

    public void setAdditionalNotifications(List<RecipientAdditionalNotification> additionalNotifications) {
        this.additionalNotifications = additionalNotifications;
    }

    public Intermediary allowSystemOverrideForLockedRecipient(String allowSystemOverrideForLockedRecipient) {
        this.allowSystemOverrideForLockedRecipient = allowSystemOverrideForLockedRecipient;
        return this;
    }

    @Schema(description="")
    public String getAllowSystemOverrideForLockedRecipient() {
        return this.allowSystemOverrideForLockedRecipient;
    }

    public void setAllowSystemOverrideForLockedRecipient(String allowSystemOverrideForLockedRecipient) {
        this.allowSystemOverrideForLockedRecipient = allowSystemOverrideForLockedRecipient;
    }

    public Intermediary autoRespondedReason(String autoRespondedReason) {
        this.autoRespondedReason = autoRespondedReason;
        return this;
    }

    @Schema(description="")
    public String getAutoRespondedReason() {
        return this.autoRespondedReason;
    }

    public void setAutoRespondedReason(String autoRespondedReason) {
        this.autoRespondedReason = autoRespondedReason;
    }

    public Intermediary bulkSendV2Recipient(String bulkSendV2Recipient) {
        this.bulkSendV2Recipient = bulkSendV2Recipient;
        return this;
    }

    @Schema(description="")
    public String getBulkSendV2Recipient() {
        return this.bulkSendV2Recipient;
    }

    public void setBulkSendV2Recipient(String bulkSendV2Recipient) {
        this.bulkSendV2Recipient = bulkSendV2Recipient;
    }

    public Intermediary clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters. ")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public Intermediary completedCount(String completedCount) {
        this.completedCount = completedCount;
        return this;
    }

    @Schema(description="")
    public String getCompletedCount() {
        return this.completedCount;
    }

    public void setCompletedCount(String completedCount) {
        this.completedCount = completedCount;
    }

    public Intermediary consentDetailsList(List<ConsentDetails> consentDetailsList) {
        this.consentDetailsList = consentDetailsList;
        return this;
    }

    public Intermediary addConsentDetailsListItem(ConsentDetails consentDetailsListItem) {
        if (this.consentDetailsList == null) {
            this.consentDetailsList = new ArrayList<ConsentDetails>();
        }
        this.consentDetailsList.add(consentDetailsListItem);
        return this;
    }

    @Schema(description="")
    public List<ConsentDetails> getConsentDetailsList() {
        return this.consentDetailsList;
    }

    public void setConsentDetailsList(List<ConsentDetails> consentDetailsList) {
        this.consentDetailsList = consentDetailsList;
    }

    public Intermediary customFields(List<String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Intermediary addCustomFieldsItem(String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<String>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Schema(description="An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
    public List<String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(List<String> customFields) {
        this.customFields = customFields;
    }

    public Intermediary declinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
        return this;
    }

    @Schema(description="The date and time the recipient declined the document.")
    public String getDeclinedDateTime() {
        return this.declinedDateTime;
    }

    public void setDeclinedDateTime(String declinedDateTime) {
        this.declinedDateTime = declinedDateTime;
    }

    public Intermediary declinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
        return this;
    }

    @Schema(description="The reason the recipient declined the document.")
    public String getDeclinedReason() {
        return this.declinedReason;
    }

    public void setDeclinedReason(String declinedReason) {
        this.declinedReason = declinedReason;
    }

    public Intermediary deliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
        return this;
    }

    @Schema(description="Reserved: For DocuSign use only.")
    public String getDeliveredDateTime() {
        return this.deliveredDateTime;
    }

    public void setDeliveredDateTime(String deliveredDateTime) {
        this.deliveredDateTime = deliveredDateTime;
    }

    public Intermediary deliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
        return this;
    }

    @Schema(description="Reserved: For DocuSign use only.")
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public Intermediary deliveryMethodMetadata(PropertyMetadata deliveryMethodMetadata) {
        this.deliveryMethodMetadata = deliveryMethodMetadata;
        return this;
    }

    @Schema(description="Reserved for DocuSign.")
    public PropertyMetadata getDeliveryMethodMetadata() {
        return this.deliveryMethodMetadata;
    }

    public void setDeliveryMethodMetadata(PropertyMetadata deliveryMethodMetadata) {
        this.deliveryMethodMetadata = deliveryMethodMetadata;
    }

    public Intermediary designatorId(String designatorId) {
        this.designatorId = designatorId;
        return this;
    }

    @Schema(description="")
    public String getDesignatorId() {
        return this.designatorId;
    }

    public void setDesignatorId(String designatorId) {
        this.designatorId = designatorId;
    }

    public Intermediary designatorIdGuid(String designatorIdGuid) {
        this.designatorIdGuid = designatorIdGuid;
        return this;
    }

    @Schema(description="")
    public String getDesignatorIdGuid() {
        return this.designatorIdGuid;
    }

    public void setDesignatorIdGuid(String designatorIdGuid) {
        this.designatorIdGuid = designatorIdGuid;
    }

    public Intermediary documentTemplateId(String documentTemplateId) {
        this.documentTemplateId = documentTemplateId;
        return this;
    }

    @Schema(description="")
    public String getDocumentTemplateId() {
        return this.documentTemplateId;
    }

    public void setDocumentTemplateId(String documentTemplateId) {
        this.documentTemplateId = documentTemplateId;
    }

    public Intermediary documentVisibility(List<DocumentVisibility> documentVisibility) {
        this.documentVisibility = documentVisibility;
        return this;
    }

    public Intermediary addDocumentVisibilityItem(DocumentVisibility documentVisibilityItem) {
        if (this.documentVisibility == null) {
            this.documentVisibility = new ArrayList<DocumentVisibility>();
        }
        this.documentVisibility.add(documentVisibilityItem);
        return this;
    }

    @Schema(description="")
    public List<DocumentVisibility> getDocumentVisibility() {
        return this.documentVisibility;
    }

    public void setDocumentVisibility(List<DocumentVisibility> documentVisibility) {
        this.documentVisibility = documentVisibility;
    }

    public Intermediary email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email id of the recipient. Notification of the document to sign is sent to this email id.   Maximum length: 100 characters. ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Intermediary emailMetadata(PropertyMetadata emailMetadata) {
        this.emailMetadata = emailMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `email` property is editable. This property is read-only.")
    public PropertyMetadata getEmailMetadata() {
        return this.emailMetadata;
    }

    public void setEmailMetadata(PropertyMetadata emailMetadata) {
        this.emailMetadata = emailMetadata;
    }

    public Intermediary emailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
        return this;
    }

    @Schema(description="A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings. ")
    public RecipientEmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(RecipientEmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    public Intermediary emailRecipientPostSigningURL(String emailRecipientPostSigningURL) {
        this.emailRecipientPostSigningURL = emailRecipientPostSigningURL;
        return this;
    }

    @Schema(description="")
    public String getEmailRecipientPostSigningURL() {
        return this.emailRecipientPostSigningURL;
    }

    public void setEmailRecipientPostSigningURL(String emailRecipientPostSigningURL) {
        this.emailRecipientPostSigningURL = emailRecipientPostSigningURL;
    }

    public Intermediary embeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
        return this;
    }

    @Schema(description="Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]` ")
    public String getEmbeddedRecipientStartURL() {
        return this.embeddedRecipientStartURL;
    }

    public void setEmbeddedRecipientStartURL(String embeddedRecipientStartURL) {
        this.embeddedRecipientStartURL = embeddedRecipientStartURL;
    }

    public Intermediary errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public Intermediary excludedDocuments(List<String> excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
        return this;
    }

    public Intermediary addExcludedDocumentsItem(String excludedDocumentsItem) {
        if (this.excludedDocuments == null) {
            this.excludedDocuments = new ArrayList<String>();
        }
        this.excludedDocuments.add(excludedDocumentsItem);
        return this;
    }

    @Schema(description="Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.")
    public List<String> getExcludedDocuments() {
        return this.excludedDocuments;
    }

    public void setExcludedDocuments(List<String> excludedDocuments) {
        this.excludedDocuments = excludedDocuments;
    }

    public Intermediary faxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
        return this;
    }

    @Schema(description="Reserved:")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public Intermediary faxNumberMetadata(PropertyMetadata faxNumberMetadata) {
        this.faxNumberMetadata = faxNumberMetadata;
        return this;
    }

    @Schema(description="Reserved for DocuSign.")
    public PropertyMetadata getFaxNumberMetadata() {
        return this.faxNumberMetadata;
    }

    public void setFaxNumberMetadata(PropertyMetadata faxNumberMetadata) {
        this.faxNumberMetadata = faxNumberMetadata;
    }

    public Intermediary firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(description="The user's first name.  Maximum Length: 50 characters.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Intermediary firstNameMetadata(PropertyMetadata firstNameMetadata) {
        this.firstNameMetadata = firstNameMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `firstName` property is editable. This property is read-only.")
    public PropertyMetadata getFirstNameMetadata() {
        return this.firstNameMetadata;
    }

    public void setFirstNameMetadata(PropertyMetadata firstNameMetadata) {
        this.firstNameMetadata = firstNameMetadata;
    }

    public Intermediary fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(description="")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Intermediary fullNameMetadata(PropertyMetadata fullNameMetadata) {
        this.fullNameMetadata = fullNameMetadata;
        return this;
    }

    @Schema(description="Reserved for DocuSign.")
    public PropertyMetadata getFullNameMetadata() {
        return this.fullNameMetadata;
    }

    public void setFullNameMetadata(PropertyMetadata fullNameMetadata) {
        this.fullNameMetadata = fullNameMetadata;
    }

    public Intermediary idCheckConfigurationName(String idCheckConfigurationName) {
        this.idCheckConfigurationName = idCheckConfigurationName;
        return this;
    }

    @Schema(description="Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.")
    public String getIdCheckConfigurationName() {
        return this.idCheckConfigurationName;
    }

    public void setIdCheckConfigurationName(String idCheckConfigurationName) {
        this.idCheckConfigurationName = idCheckConfigurationName;
    }

    public Intermediary idCheckConfigurationNameMetadata(PropertyMetadata idCheckConfigurationNameMetadata) {
        this.idCheckConfigurationNameMetadata = idCheckConfigurationNameMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `idCheckConfigurationName` property is editable. This property is read-only.")
    public PropertyMetadata getIdCheckConfigurationNameMetadata() {
        return this.idCheckConfigurationNameMetadata;
    }

    public void setIdCheckConfigurationNameMetadata(PropertyMetadata idCheckConfigurationNameMetadata) {
        this.idCheckConfigurationNameMetadata = idCheckConfigurationNameMetadata;
    }

    public Intermediary idCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
        this.idCheckInformationInput = idCheckInformationInput;
        return this;
    }

    @Schema(description="An object that contains input information related to a recipient ID check.")
    public IdCheckInformationInput getIdCheckInformationInput() {
        return this.idCheckInformationInput;
    }

    public void setIdCheckInformationInput(IdCheckInformationInput idCheckInformationInput) {
        this.idCheckInformationInput = idCheckInformationInput;
    }

    public Intermediary identityVerification(RecipientIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
        return this;
    }

    @Schema(description="Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).")
    public RecipientIdentityVerification getIdentityVerification() {
        return this.identityVerification;
    }

    public void setIdentityVerification(RecipientIdentityVerification identityVerification) {
        this.identityVerification = identityVerification;
    }

    public Intermediary inheritEmailNotificationConfiguration(String inheritEmailNotificationConfiguration) {
        this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
        return this;
    }

    @Schema(description="When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account. ")
    public String getInheritEmailNotificationConfiguration() {
        return this.inheritEmailNotificationConfiguration;
    }

    public void setInheritEmailNotificationConfiguration(String inheritEmailNotificationConfiguration) {
        this.inheritEmailNotificationConfiguration = inheritEmailNotificationConfiguration;
    }

    public Intermediary lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(description="")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Intermediary lastNameMetadata(PropertyMetadata lastNameMetadata) {
        this.lastNameMetadata = lastNameMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `lastName` property is editable. This property is read-only.")
    public PropertyMetadata getLastNameMetadata() {
        return this.lastNameMetadata;
    }

    public void setLastNameMetadata(PropertyMetadata lastNameMetadata) {
        this.lastNameMetadata = lastNameMetadata;
    }

    public Intermediary lockedRecipientPhoneAuthEditable(String lockedRecipientPhoneAuthEditable) {
        this.lockedRecipientPhoneAuthEditable = lockedRecipientPhoneAuthEditable;
        return this;
    }

    @Schema(description="")
    public String getLockedRecipientPhoneAuthEditable() {
        return this.lockedRecipientPhoneAuthEditable;
    }

    public void setLockedRecipientPhoneAuthEditable(String lockedRecipientPhoneAuthEditable) {
        this.lockedRecipientPhoneAuthEditable = lockedRecipientPhoneAuthEditable;
    }

    public Intermediary lockedRecipientSmsEditable(String lockedRecipientSmsEditable) {
        this.lockedRecipientSmsEditable = lockedRecipientSmsEditable;
        return this;
    }

    @Schema(description="")
    public String getLockedRecipientSmsEditable() {
        return this.lockedRecipientSmsEditable;
    }

    public void setLockedRecipientSmsEditable(String lockedRecipientSmsEditable) {
        this.lockedRecipientSmsEditable = lockedRecipientSmsEditable;
    }

    public Intermediary name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Intermediary nameMetadata(PropertyMetadata nameMetadata) {
        this.nameMetadata = nameMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `name` property is editable. This property is read-only.")
    public PropertyMetadata getNameMetadata() {
        return this.nameMetadata;
    }

    public void setNameMetadata(PropertyMetadata nameMetadata) {
        this.nameMetadata = nameMetadata;
    }

    public Intermediary note(String note) {
        this.note = note;
        return this;
    }

    @Schema(description="Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Intermediary noteMetadata(PropertyMetadata noteMetadata) {
        this.noteMetadata = noteMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `note` property is editable. This property is read-only.")
    public PropertyMetadata getNoteMetadata() {
        return this.noteMetadata;
    }

    public void setNoteMetadata(PropertyMetadata noteMetadata) {
        this.noteMetadata = noteMetadata;
    }

    public Intermediary phoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
        this.phoneAuthentication = phoneAuthentication;
        return this;
    }

    @Schema(description="When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide the recipient authentication method details. It contains the following elements:  * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number they choose. * `senderProvidedNumbers`: ArrayOfStrings.  A list of phone numbers the recipient can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved for DocuSign.  ")
    public RecipientPhoneAuthentication getPhoneAuthentication() {
        return this.phoneAuthentication;
    }

    public void setPhoneAuthentication(RecipientPhoneAuthentication phoneAuthentication) {
        this.phoneAuthentication = phoneAuthentication;
    }

    public Intermediary phoneNumber(RecipientPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="Describes the recipient phone number.")
    public RecipientPhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(RecipientPhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Intermediary proofFile(RecipientProofFile proofFile) {
        this.proofFile = proofFile;
        return this;
    }

    @Schema(description="")
    public RecipientProofFile getProofFile() {
        return this.proofFile;
    }

    public void setProofFile(RecipientProofFile proofFile) {
        this.proofFile = proofFile;
    }

    public Intermediary recipientAttachments(List<RecipientAttachment> recipientAttachments) {
        this.recipientAttachments = recipientAttachments;
        return this;
    }

    public Intermediary addRecipientAttachmentsItem(RecipientAttachment recipientAttachmentsItem) {
        if (this.recipientAttachments == null) {
            this.recipientAttachments = new ArrayList<RecipientAttachment>();
        }
        this.recipientAttachments.add(recipientAttachmentsItem);
        return this;
    }

    @Schema(description="Reserved:")
    public List<RecipientAttachment> getRecipientAttachments() {
        return this.recipientAttachments;
    }

    public void setRecipientAttachments(List<RecipientAttachment> recipientAttachments) {
        this.recipientAttachments = recipientAttachments;
    }

    public Intermediary recipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
        this.recipientAuthenticationStatus = recipientAuthenticationStatus;
        return this;
    }

    @Schema(description="Information about the recipient's authentication status. This property is read-only.")
    public AuthenticationStatus getRecipientAuthenticationStatus() {
        return this.recipientAuthenticationStatus;
    }

    public void setRecipientAuthenticationStatus(AuthenticationStatus recipientAuthenticationStatus) {
        this.recipientAuthenticationStatus = recipientAuthenticationStatus;
    }

    public Intermediary recipientFeatureMetadata(List<FeatureAvailableMetadata> recipientFeatureMetadata) {
        this.recipientFeatureMetadata = recipientFeatureMetadata;
        return this;
    }

    public Intermediary addRecipientFeatureMetadataItem(FeatureAvailableMetadata recipientFeatureMetadataItem) {
        if (this.recipientFeatureMetadata == null) {
            this.recipientFeatureMetadata = new ArrayList<FeatureAvailableMetadata>();
        }
        this.recipientFeatureMetadata.add(recipientFeatureMetadataItem);
        return this;
    }

    @Schema(description="")
    public List<FeatureAvailableMetadata> getRecipientFeatureMetadata() {
        return this.recipientFeatureMetadata;
    }

    public void setRecipientFeatureMetadata(List<FeatureAvailableMetadata> recipientFeatureMetadata) {
        this.recipientFeatureMetadata = recipientFeatureMetadata;
    }

    public Intermediary recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @Schema(description="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public Intermediary recipientIdGuid(String recipientIdGuid) {
        this.recipientIdGuid = recipientIdGuid;
        return this;
    }

    @Schema(description="")
    public String getRecipientIdGuid() {
        return this.recipientIdGuid;
    }

    public void setRecipientIdGuid(String recipientIdGuid) {
        this.recipientIdGuid = recipientIdGuid;
    }

    public Intermediary recipientType(String recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @Schema(description="")
    public String getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(String recipientType) {
        this.recipientType = recipientType;
    }

    public Intermediary recipientTypeMetadata(PropertyMetadata recipientTypeMetadata) {
        this.recipientTypeMetadata = recipientTypeMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `recipientType` property is editable. This property is read-only.")
    public PropertyMetadata getRecipientTypeMetadata() {
        return this.recipientTypeMetadata;
    }

    public void setRecipientTypeMetadata(PropertyMetadata recipientTypeMetadata) {
        this.recipientTypeMetadata = recipientTypeMetadata;
    }

    public Intermediary requireIdLookup(String requireIdLookup) {
        this.requireIdLookup = requireIdLookup;
        return this;
    }

    @Schema(description="When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity. ")
    public String getRequireIdLookup() {
        return this.requireIdLookup;
    }

    public void setRequireIdLookup(String requireIdLookup) {
        this.requireIdLookup = requireIdLookup;
    }

    public Intermediary requireIdLookupMetadata(PropertyMetadata requireIdLookupMetadata) {
        this.requireIdLookupMetadata = requireIdLookupMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `requireIdLookup` property is editable. This property is read-only.")
    public PropertyMetadata getRequireIdLookupMetadata() {
        return this.requireIdLookupMetadata;
    }

    public void setRequireIdLookupMetadata(PropertyMetadata requireIdLookupMetadata) {
        this.requireIdLookupMetadata = requireIdLookupMetadata;
    }

    public Intermediary roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Schema(description="Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Intermediary routingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
        return this;
    }

    @Schema(description="Specifies the routing order of the recipient in the envelope. ")
    public String getRoutingOrder() {
        return this.routingOrder;
    }

    public void setRoutingOrder(String routingOrder) {
        this.routingOrder = routingOrder;
    }

    public Intermediary routingOrderMetadata(PropertyMetadata routingOrderMetadata) {
        this.routingOrderMetadata = routingOrderMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `routingOrder` property is editable. This property is read-only.")
    public PropertyMetadata getRoutingOrderMetadata() {
        return this.routingOrderMetadata;
    }

    public void setRoutingOrderMetadata(PropertyMetadata routingOrderMetadata) {
        this.routingOrderMetadata = routingOrderMetadata;
    }

    public Intermediary sentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    @Schema(description="The date and time the envelope was sent.")
    public String getSentDateTime() {
        return this.sentDateTime;
    }

    public void setSentDateTime(String sentDateTime) {
        this.sentDateTime = sentDateTime;
    }

    public Intermediary signedDateTime(String signedDateTime) {
        this.signedDateTime = signedDateTime;
        return this;
    }

    @Schema(description="Reserved: For DocuSign use only. ")
    public String getSignedDateTime() {
        return this.signedDateTime;
    }

    public void setSignedDateTime(String signedDateTime) {
        this.signedDateTime = signedDateTime;
    }

    public Intermediary signingGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
        return this;
    }

    @Schema(description="When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).")
    public String getSigningGroupId() {
        return this.signingGroupId;
    }

    public void setSigningGroupId(String signingGroupId) {
        this.signingGroupId = signingGroupId;
    }

    public Intermediary signingGroupIdMetadata(PropertyMetadata signingGroupIdMetadata) {
        this.signingGroupIdMetadata = signingGroupIdMetadata;
        return this;
    }

    @Schema(description="Metadata that indicates whether the `signingGroupId` property is editable. This property is read-only.")
    public PropertyMetadata getSigningGroupIdMetadata() {
        return this.signingGroupIdMetadata;
    }

    public void setSigningGroupIdMetadata(PropertyMetadata signingGroupIdMetadata) {
        this.signingGroupIdMetadata = signingGroupIdMetadata;
    }

    public Intermediary signingGroupName(String signingGroupName) {
        this.signingGroupName = signingGroupName;
        return this;
    }

    @Schema(description="The display name for the signing group.   Maximum Length: 100 characters. ")
    public String getSigningGroupName() {
        return this.signingGroupName;
    }

    public void setSigningGroupName(String signingGroupName) {
        this.signingGroupName = signingGroupName;
    }

    public Intermediary signingGroupUsers(List<UserInfo> signingGroupUsers) {
        this.signingGroupUsers = signingGroupUsers;
        return this;
    }

    public Intermediary addSigningGroupUsersItem(UserInfo signingGroupUsersItem) {
        if (this.signingGroupUsers == null) {
            this.signingGroupUsers = new ArrayList<UserInfo>();
        }
        this.signingGroupUsers.add(signingGroupUsersItem);
        return this;
    }

    @Schema(description="A complex type that contains information about users in the signing group.")
    public List<UserInfo> getSigningGroupUsers() {
        return this.signingGroupUsers;
    }

    public void setSigningGroupUsers(List<UserInfo> signingGroupUsers) {
        this.signingGroupUsers = signingGroupUsers;
    }

    public Intermediary smsAuthentication(RecipientSMSAuthentication smsAuthentication) {
        this.smsAuthentication = smsAuthentication;
        return this;
    }

    @Schema(description="When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide the recipient authentication method details. It contains the element `senderProvidedNumbers`, which is an array of phone numbers that the recipient can use for SMS text authentication.   ")
    public RecipientSMSAuthentication getSmsAuthentication() {
        return this.smsAuthentication;
    }

    public void setSmsAuthentication(RecipientSMSAuthentication smsAuthentication) {
        this.smsAuthentication = smsAuthentication;
    }

    public Intermediary socialAuthentications(List<SocialAuthentication> socialAuthentications) {
        this.socialAuthentications = socialAuthentications;
        return this;
    }

    public Intermediary addSocialAuthenticationsItem(SocialAuthentication socialAuthenticationsItem) {
        if (this.socialAuthentications == null) {
            this.socialAuthentications = new ArrayList<SocialAuthentication>();
        }
        this.socialAuthentications.add(socialAuthenticationsItem);
        return this;
    }

    @Schema(description=" Lists the social ID type that can be used for recipient authentication.")
    public List<SocialAuthentication> getSocialAuthentications() {
        return this.socialAuthentications;
    }

    public void setSocialAuthentications(List<SocialAuthentication> socialAuthentications) {
        this.socialAuthentications = socialAuthentications;
    }

    public Intermediary status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Intermediary statusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Schema(description="")
    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public Intermediary suppressEmails(String suppressEmails) {
        this.suppressEmails = suppressEmails;
        return this;
    }

    @Schema(description="")
    public String getSuppressEmails() {
        return this.suppressEmails;
    }

    public void setSuppressEmails(String suppressEmails) {
        this.suppressEmails = suppressEmails;
    }

    public Intermediary templateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
        return this;
    }

    @Schema(description="When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. ")
    public String getTemplateLocked() {
        return this.templateLocked;
    }

    public void setTemplateLocked(String templateLocked) {
        this.templateLocked = templateLocked;
    }

    public Intermediary templateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
        return this;
    }

    @Schema(description="When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.")
    public String getTemplateRequired() {
        return this.templateRequired;
    }

    public void setTemplateRequired(String templateRequired) {
        this.templateRequired = templateRequired;
    }

    public Intermediary totalTabCount(String totalTabCount) {
        this.totalTabCount = totalTabCount;
        return this;
    }

    @Schema(description="")
    public String getTotalTabCount() {
        return this.totalTabCount;
    }

    public void setTotalTabCount(String totalTabCount) {
        this.totalTabCount = totalTabCount;
    }

    public Intermediary userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Schema(description="")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Intermediary webFormRecipientViewId(String webFormRecipientViewId) {
        this.webFormRecipientViewId = webFormRecipientViewId;
        return this;
    }

    @Schema(description="")
    public String getWebFormRecipientViewId() {
        return this.webFormRecipientViewId;
    }

    public void setWebFormRecipientViewId(String webFormRecipientViewId) {
        this.webFormRecipientViewId = webFormRecipientViewId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Intermediary intermediary = (Intermediary)o;
        return Objects.equals(this.accessCode, intermediary.accessCode) && Objects.equals(this.accessCodeMetadata, intermediary.accessCodeMetadata) && Objects.equals(this.addAccessCodeToEmail, intermediary.addAccessCodeToEmail) && Objects.equals(this.additionalNotifications, intermediary.additionalNotifications) && Objects.equals(this.allowSystemOverrideForLockedRecipient, intermediary.allowSystemOverrideForLockedRecipient) && Objects.equals(this.autoRespondedReason, intermediary.autoRespondedReason) && Objects.equals(this.bulkSendV2Recipient, intermediary.bulkSendV2Recipient) && Objects.equals(this.clientUserId, intermediary.clientUserId) && Objects.equals(this.completedCount, intermediary.completedCount) && Objects.equals(this.consentDetailsList, intermediary.consentDetailsList) && Objects.equals(this.customFields, intermediary.customFields) && Objects.equals(this.declinedDateTime, intermediary.declinedDateTime) && Objects.equals(this.declinedReason, intermediary.declinedReason) && Objects.equals(this.deliveredDateTime, intermediary.deliveredDateTime) && Objects.equals(this.deliveryMethod, intermediary.deliveryMethod) && Objects.equals(this.deliveryMethodMetadata, intermediary.deliveryMethodMetadata) && Objects.equals(this.designatorId, intermediary.designatorId) && Objects.equals(this.designatorIdGuid, intermediary.designatorIdGuid) && Objects.equals(this.documentTemplateId, intermediary.documentTemplateId) && Objects.equals(this.documentVisibility, intermediary.documentVisibility) && Objects.equals(this.email, intermediary.email) && Objects.equals(this.emailMetadata, intermediary.emailMetadata) && Objects.equals(this.emailNotification, intermediary.emailNotification) && Objects.equals(this.emailRecipientPostSigningURL, intermediary.emailRecipientPostSigningURL) && Objects.equals(this.embeddedRecipientStartURL, intermediary.embeddedRecipientStartURL) && Objects.equals(this.errorDetails, intermediary.errorDetails) && Objects.equals(this.excludedDocuments, intermediary.excludedDocuments) && Objects.equals(this.faxNumber, intermediary.faxNumber) && Objects.equals(this.faxNumberMetadata, intermediary.faxNumberMetadata) && Objects.equals(this.firstName, intermediary.firstName) && Objects.equals(this.firstNameMetadata, intermediary.firstNameMetadata) && Objects.equals(this.fullName, intermediary.fullName) && Objects.equals(this.fullNameMetadata, intermediary.fullNameMetadata) && Objects.equals(this.idCheckConfigurationName, intermediary.idCheckConfigurationName) && Objects.equals(this.idCheckConfigurationNameMetadata, intermediary.idCheckConfigurationNameMetadata) && Objects.equals(this.idCheckInformationInput, intermediary.idCheckInformationInput) && Objects.equals(this.identityVerification, intermediary.identityVerification) && Objects.equals(this.inheritEmailNotificationConfiguration, intermediary.inheritEmailNotificationConfiguration) && Objects.equals(this.lastName, intermediary.lastName) && Objects.equals(this.lastNameMetadata, intermediary.lastNameMetadata) && Objects.equals(this.lockedRecipientPhoneAuthEditable, intermediary.lockedRecipientPhoneAuthEditable) && Objects.equals(this.lockedRecipientSmsEditable, intermediary.lockedRecipientSmsEditable) && Objects.equals(this.name, intermediary.name) && Objects.equals(this.nameMetadata, intermediary.nameMetadata) && Objects.equals(this.note, intermediary.note) && Objects.equals(this.noteMetadata, intermediary.noteMetadata) && Objects.equals(this.phoneAuthentication, intermediary.phoneAuthentication) && Objects.equals(this.phoneNumber, intermediary.phoneNumber) && Objects.equals(this.proofFile, intermediary.proofFile) && Objects.equals(this.recipientAttachments, intermediary.recipientAttachments) && Objects.equals(this.recipientAuthenticationStatus, intermediary.recipientAuthenticationStatus) && Objects.equals(this.recipientFeatureMetadata, intermediary.recipientFeatureMetadata) && Objects.equals(this.recipientId, intermediary.recipientId) && Objects.equals(this.recipientIdGuid, intermediary.recipientIdGuid) && Objects.equals(this.recipientType, intermediary.recipientType) && Objects.equals(this.recipientTypeMetadata, intermediary.recipientTypeMetadata) && Objects.equals(this.requireIdLookup, intermediary.requireIdLookup) && Objects.equals(this.requireIdLookupMetadata, intermediary.requireIdLookupMetadata) && Objects.equals(this.roleName, intermediary.roleName) && Objects.equals(this.routingOrder, intermediary.routingOrder) && Objects.equals(this.routingOrderMetadata, intermediary.routingOrderMetadata) && Objects.equals(this.sentDateTime, intermediary.sentDateTime) && Objects.equals(this.signedDateTime, intermediary.signedDateTime) && Objects.equals(this.signingGroupId, intermediary.signingGroupId) && Objects.equals(this.signingGroupIdMetadata, intermediary.signingGroupIdMetadata) && Objects.equals(this.signingGroupName, intermediary.signingGroupName) && Objects.equals(this.signingGroupUsers, intermediary.signingGroupUsers) && Objects.equals(this.smsAuthentication, intermediary.smsAuthentication) && Objects.equals(this.socialAuthentications, intermediary.socialAuthentications) && Objects.equals(this.status, intermediary.status) && Objects.equals(this.statusCode, intermediary.statusCode) && Objects.equals(this.suppressEmails, intermediary.suppressEmails) && Objects.equals(this.templateLocked, intermediary.templateLocked) && Objects.equals(this.templateRequired, intermediary.templateRequired) && Objects.equals(this.totalTabCount, intermediary.totalTabCount) && Objects.equals(this.userId, intermediary.userId) && Objects.equals(this.webFormRecipientViewId, intermediary.webFormRecipientViewId);
    }

    public int hashCode() {
        return Objects.hash(this.accessCode, this.accessCodeMetadata, this.addAccessCodeToEmail, this.additionalNotifications, this.allowSystemOverrideForLockedRecipient, this.autoRespondedReason, this.bulkSendV2Recipient, this.clientUserId, this.completedCount, this.consentDetailsList, this.customFields, this.declinedDateTime, this.declinedReason, this.deliveredDateTime, this.deliveryMethod, this.deliveryMethodMetadata, this.designatorId, this.designatorIdGuid, this.documentTemplateId, this.documentVisibility, this.email, this.emailMetadata, this.emailNotification, this.emailRecipientPostSigningURL, this.embeddedRecipientStartURL, this.errorDetails, this.excludedDocuments, this.faxNumber, this.faxNumberMetadata, this.firstName, this.firstNameMetadata, this.fullName, this.fullNameMetadata, this.idCheckConfigurationName, this.idCheckConfigurationNameMetadata, this.idCheckInformationInput, this.identityVerification, this.inheritEmailNotificationConfiguration, this.lastName, this.lastNameMetadata, this.lockedRecipientPhoneAuthEditable, this.lockedRecipientSmsEditable, this.name, this.nameMetadata, this.note, this.noteMetadata, this.phoneAuthentication, this.phoneNumber, this.proofFile, this.recipientAttachments, this.recipientAuthenticationStatus, this.recipientFeatureMetadata, this.recipientId, this.recipientIdGuid, this.recipientType, this.recipientTypeMetadata, this.requireIdLookup, this.requireIdLookupMetadata, this.roleName, this.routingOrder, this.routingOrderMetadata, this.sentDateTime, this.signedDateTime, this.signingGroupId, this.signingGroupIdMetadata, this.signingGroupName, this.signingGroupUsers, this.smsAuthentication, this.socialAuthentications, this.status, this.statusCode, this.suppressEmails, this.templateLocked, this.templateRequired, this.totalTabCount, this.userId, this.webFormRecipientViewId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Intermediary {\n");
        sb.append("    accessCode: ").append(this.toIndentedString(this.accessCode)).append("\n");
        sb.append("    accessCodeMetadata: ").append(this.toIndentedString(this.accessCodeMetadata)).append("\n");
        sb.append("    addAccessCodeToEmail: ").append(this.toIndentedString(this.addAccessCodeToEmail)).append("\n");
        sb.append("    additionalNotifications: ").append(this.toIndentedString(this.additionalNotifications)).append("\n");
        sb.append("    allowSystemOverrideForLockedRecipient: ").append(this.toIndentedString(this.allowSystemOverrideForLockedRecipient)).append("\n");
        sb.append("    autoRespondedReason: ").append(this.toIndentedString(this.autoRespondedReason)).append("\n");
        sb.append("    bulkSendV2Recipient: ").append(this.toIndentedString(this.bulkSendV2Recipient)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    completedCount: ").append(this.toIndentedString(this.completedCount)).append("\n");
        sb.append("    consentDetailsList: ").append(this.toIndentedString(this.consentDetailsList)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    declinedDateTime: ").append(this.toIndentedString(this.declinedDateTime)).append("\n");
        sb.append("    declinedReason: ").append(this.toIndentedString(this.declinedReason)).append("\n");
        sb.append("    deliveredDateTime: ").append(this.toIndentedString(this.deliveredDateTime)).append("\n");
        sb.append("    deliveryMethod: ").append(this.toIndentedString(this.deliveryMethod)).append("\n");
        sb.append("    deliveryMethodMetadata: ").append(this.toIndentedString(this.deliveryMethodMetadata)).append("\n");
        sb.append("    designatorId: ").append(this.toIndentedString(this.designatorId)).append("\n");
        sb.append("    designatorIdGuid: ").append(this.toIndentedString(this.designatorIdGuid)).append("\n");
        sb.append("    documentTemplateId: ").append(this.toIndentedString(this.documentTemplateId)).append("\n");
        sb.append("    documentVisibility: ").append(this.toIndentedString(this.documentVisibility)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    emailMetadata: ").append(this.toIndentedString(this.emailMetadata)).append("\n");
        sb.append("    emailNotification: ").append(this.toIndentedString(this.emailNotification)).append("\n");
        sb.append("    emailRecipientPostSigningURL: ").append(this.toIndentedString(this.emailRecipientPostSigningURL)).append("\n");
        sb.append("    embeddedRecipientStartURL: ").append(this.toIndentedString(this.embeddedRecipientStartURL)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    excludedDocuments: ").append(this.toIndentedString(this.excludedDocuments)).append("\n");
        sb.append("    faxNumber: ").append(this.toIndentedString(this.faxNumber)).append("\n");
        sb.append("    faxNumberMetadata: ").append(this.toIndentedString(this.faxNumberMetadata)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    firstNameMetadata: ").append(this.toIndentedString(this.firstNameMetadata)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    fullNameMetadata: ").append(this.toIndentedString(this.fullNameMetadata)).append("\n");
        sb.append("    idCheckConfigurationName: ").append(this.toIndentedString(this.idCheckConfigurationName)).append("\n");
        sb.append("    idCheckConfigurationNameMetadata: ").append(this.toIndentedString(this.idCheckConfigurationNameMetadata)).append("\n");
        sb.append("    idCheckInformationInput: ").append(this.toIndentedString(this.idCheckInformationInput)).append("\n");
        sb.append("    identityVerification: ").append(this.toIndentedString(this.identityVerification)).append("\n");
        sb.append("    inheritEmailNotificationConfiguration: ").append(this.toIndentedString(this.inheritEmailNotificationConfiguration)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    lastNameMetadata: ").append(this.toIndentedString(this.lastNameMetadata)).append("\n");
        sb.append("    lockedRecipientPhoneAuthEditable: ").append(this.toIndentedString(this.lockedRecipientPhoneAuthEditable)).append("\n");
        sb.append("    lockedRecipientSmsEditable: ").append(this.toIndentedString(this.lockedRecipientSmsEditable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameMetadata: ").append(this.toIndentedString(this.nameMetadata)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    noteMetadata: ").append(this.toIndentedString(this.noteMetadata)).append("\n");
        sb.append("    phoneAuthentication: ").append(this.toIndentedString(this.phoneAuthentication)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    proofFile: ").append(this.toIndentedString(this.proofFile)).append("\n");
        sb.append("    recipientAttachments: ").append(this.toIndentedString(this.recipientAttachments)).append("\n");
        sb.append("    recipientAuthenticationStatus: ").append(this.toIndentedString(this.recipientAuthenticationStatus)).append("\n");
        sb.append("    recipientFeatureMetadata: ").append(this.toIndentedString(this.recipientFeatureMetadata)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    recipientIdGuid: ").append(this.toIndentedString(this.recipientIdGuid)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString(this.recipientType)).append("\n");
        sb.append("    recipientTypeMetadata: ").append(this.toIndentedString(this.recipientTypeMetadata)).append("\n");
        sb.append("    requireIdLookup: ").append(this.toIndentedString(this.requireIdLookup)).append("\n");
        sb.append("    requireIdLookupMetadata: ").append(this.toIndentedString(this.requireIdLookupMetadata)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    routingOrder: ").append(this.toIndentedString(this.routingOrder)).append("\n");
        sb.append("    routingOrderMetadata: ").append(this.toIndentedString(this.routingOrderMetadata)).append("\n");
        sb.append("    sentDateTime: ").append(this.toIndentedString(this.sentDateTime)).append("\n");
        sb.append("    signedDateTime: ").append(this.toIndentedString(this.signedDateTime)).append("\n");
        sb.append("    signingGroupId: ").append(this.toIndentedString(this.signingGroupId)).append("\n");
        sb.append("    signingGroupIdMetadata: ").append(this.toIndentedString(this.signingGroupIdMetadata)).append("\n");
        sb.append("    signingGroupName: ").append(this.toIndentedString(this.signingGroupName)).append("\n");
        sb.append("    signingGroupUsers: ").append(this.toIndentedString(this.signingGroupUsers)).append("\n");
        sb.append("    smsAuthentication: ").append(this.toIndentedString(this.smsAuthentication)).append("\n");
        sb.append("    socialAuthentications: ").append(this.toIndentedString(this.socialAuthentications)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    suppressEmails: ").append(this.toIndentedString(this.suppressEmails)).append("\n");
        sb.append("    templateLocked: ").append(this.toIndentedString(this.templateLocked)).append("\n");
        sb.append("    templateRequired: ").append(this.toIndentedString(this.templateRequired)).append("\n");
        sb.append("    totalTabCount: ").append(this.toIndentedString(this.totalTabCount)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    webFormRecipientViewId: ").append(this.toIndentedString(this.webFormRecipientViewId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

