/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.AuthenticationMethod;
import com.docusign.webforms.model.CreateInstanceRequestBodyRecipients;
import com.docusign.webforms.model.SendOption;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Request body containing properties that will be used to create instance.")
public class CreateInstanceRequestBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="formValues")
    private Map<String, Object> formValues = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="authenticationInstant")
    private String authenticationInstant = null;
    @JsonProperty(value="authenticationMethod")
    private AuthenticationMethod authenticationMethod = null;
    @JsonProperty(value="assertionId")
    private String assertionId = null;
    @JsonProperty(value="securityDomain")
    private String securityDomain = null;
    @JsonProperty(value="returnUrl")
    private String returnUrl = null;
    @JsonProperty(value="expirationOffset")
    private Integer expirationOffset = null;
    @JsonProperty(value="sendOption")
    private SendOption sendOption = null;
    @JsonProperty(value="brandId")
    private String brandId = null;
    @JsonProperty(value="recipients")
    private List<CreateInstanceRequestBodyRecipients> recipients = null;
    @JsonProperty(value="tags")
    private List<String> tags = null;

    public CreateInstanceRequestBody formValues(Map<String, Object> formValues) {
        this.formValues = formValues;
        return this;
    }

    public CreateInstanceRequestBody putFormValuesItem(String key, Object formValuesItem) {
        if (this.formValues == null) {
            this.formValues = new HashMap<String, Object>();
        }
        this.formValues.put(key, formValuesItem);
        return this;
    }

    @Schema(example="{\"Textbox_Name\":\"First Last\",\"Email_primary\":\"example@example.com\",\"Date_birth\":\"2020-01-01\",\"Number_age\":52,\"Select_state\":\"California\",\"Radio_Gender\":\"Female\",\"Checkbox_hobbies\":[\"singing\",\"dancing\"],\"ID_card_attachment\":{\"documentName\":\"id_card.pdf\"}}", description="Key-value pairs (where key is the component name and value is the form value) used to create a form instance. For key of type TextBox, Email, Date, Select and RadioButtonGroup the value is of string type. For key of type Number, the value is of number type. For key of type of CheckboxGroup, the value is of type array of string.")
    public Map<String, Object> getFormValues() {
        return this.formValues;
    }

    public void setFormValues(Map<String, Object> formValues) {
        this.formValues = formValues;
    }

    public CreateInstanceRequestBody clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public CreateInstanceRequestBody authenticationInstant(String authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
        return this;
    }

    @Schema(description="")
    public String getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(String authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
    }

    public CreateInstanceRequestBody authenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    @Schema(description="")
    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public CreateInstanceRequestBody assertionId(String assertionId) {
        this.assertionId = assertionId;
        return this;
    }

    @Schema(description="")
    public String getAssertionId() {
        return this.assertionId;
    }

    public void setAssertionId(String assertionId) {
        this.assertionId = assertionId;
    }

    public CreateInstanceRequestBody securityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    @Schema(description="")
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public CreateInstanceRequestBody returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public CreateInstanceRequestBody expirationOffset(Integer expirationOffset) {
        this.expirationOffset = expirationOffset;
        return this;
    }

    @Schema(description="")
    public Integer getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(Integer expirationOffset) {
        this.expirationOffset = expirationOffset;
    }

    public CreateInstanceRequestBody sendOption(SendOption sendOption) {
        this.sendOption = sendOption;
        return this;
    }

    @Schema(description="")
    public SendOption getSendOption() {
        return this.sendOption;
    }

    public void setSendOption(SendOption sendOption) {
        this.sendOption = sendOption;
    }

    public CreateInstanceRequestBody brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @Schema(description="")
    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public CreateInstanceRequestBody recipients(List<CreateInstanceRequestBodyRecipients> recipients) {
        this.recipients = recipients;
        return this;
    }

    public CreateInstanceRequestBody addRecipientsItem(CreateInstanceRequestBodyRecipients recipientsItem) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<CreateInstanceRequestBodyRecipients>();
        }
        this.recipients.add(recipientsItem);
        return this;
    }

    @Schema(description="The recipients who will receive the form in email")
    public List<CreateInstanceRequestBodyRecipients> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<CreateInstanceRequestBodyRecipients> recipients) {
        this.recipients = recipients;
    }

    public CreateInstanceRequestBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateInstanceRequestBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Schema(example="[\"loan_application\",\"finance_dept\"]", description="List of tags provided by the user with each request. This field is optional.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateInstanceRequestBody createInstanceRequestBody = (CreateInstanceRequestBody)o;
        return Objects.equals(this.formValues, createInstanceRequestBody.formValues) && Objects.equals(this.clientUserId, createInstanceRequestBody.clientUserId) && Objects.equals(this.authenticationInstant, createInstanceRequestBody.authenticationInstant) && Objects.equals((Object)this.authenticationMethod, (Object)createInstanceRequestBody.authenticationMethod) && Objects.equals(this.assertionId, createInstanceRequestBody.assertionId) && Objects.equals(this.securityDomain, createInstanceRequestBody.securityDomain) && Objects.equals(this.returnUrl, createInstanceRequestBody.returnUrl) && Objects.equals(this.expirationOffset, createInstanceRequestBody.expirationOffset) && Objects.equals((Object)this.sendOption, (Object)createInstanceRequestBody.sendOption) && Objects.equals(this.brandId, createInstanceRequestBody.brandId) && Objects.equals(this.recipients, createInstanceRequestBody.recipients) && Objects.equals(this.tags, createInstanceRequestBody.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formValues, this.clientUserId, this.authenticationInstant, this.authenticationMethod, this.assertionId, this.securityDomain, this.returnUrl, this.expirationOffset, this.sendOption, this.brandId, this.recipients, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateInstanceRequestBody {\n");
        sb.append("    formValues: ").append(this.toIndentedString(this.formValues)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    authenticationInstant: ").append(this.toIndentedString(this.authenticationInstant)).append("\n");
        sb.append("    authenticationMethod: ").append(this.toIndentedString((Object)this.authenticationMethod)).append("\n");
        sb.append("    assertionId: ").append(this.toIndentedString(this.assertionId)).append("\n");
        sb.append("    securityDomain: ").append(this.toIndentedString(this.securityDomain)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    expirationOffset: ").append(this.toIndentedString(this.expirationOffset)).append("\n");
        sb.append("    sendOption: ").append(this.toIndentedString((Object)this.sendOption)).append("\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

