/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.InstanceSource;
import com.docusign.webforms.model.WebFormUserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Web Form Instance metadata containing information like created by, created time, etc.")
public class WebFormInstanceMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="expirationDateTime")
    private String expirationDateTime = null;
    @JsonProperty(value="createdDateTime")
    private String createdDateTime = null;
    @JsonProperty(value="createdBy")
    private WebFormUserInfo createdBy = null;
    @JsonProperty(value="lastModifiedDateTime")
    private String lastModifiedDateTime = null;
    @JsonProperty(value="lastModifiedBy")
    private WebFormUserInfo lastModifiedBy = null;
    @JsonProperty(value="submittedDateTime")
    private String submittedDateTime = null;
    @JsonProperty(value="instanceSource")
    private InstanceSource instanceSource = null;

    public WebFormInstanceMetadata expirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @Schema(required=true, description="")
    public String getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public WebFormInstanceMetadata createdDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    @Schema(required=true, description="")
    public String getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public WebFormInstanceMetadata createdBy(WebFormUserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(required=true, description="The user that created the Web Form Instance")
    public WebFormUserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(WebFormUserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public WebFormInstanceMetadata lastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Schema(description="")
    public String getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public WebFormInstanceMetadata lastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    @Schema(description="The user that last modified the Web Form Instance")
    public WebFormUserInfo getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public WebFormInstanceMetadata submittedDateTime(String submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
        return this;
    }

    @Schema(description="")
    public String getSubmittedDateTime() {
        return this.submittedDateTime;
    }

    public void setSubmittedDateTime(String submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
    }

    public WebFormInstanceMetadata instanceSource(InstanceSource instanceSource) {
        this.instanceSource = instanceSource;
        return this;
    }

    @Schema(description="")
    public InstanceSource getInstanceSource() {
        return this.instanceSource;
    }

    public void setInstanceSource(InstanceSource instanceSource) {
        this.instanceSource = instanceSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormInstanceMetadata webFormInstanceMetadata = (WebFormInstanceMetadata)o;
        return Objects.equals(this.expirationDateTime, webFormInstanceMetadata.expirationDateTime) && Objects.equals(this.createdDateTime, webFormInstanceMetadata.createdDateTime) && Objects.equals(this.createdBy, webFormInstanceMetadata.createdBy) && Objects.equals(this.lastModifiedDateTime, webFormInstanceMetadata.lastModifiedDateTime) && Objects.equals(this.lastModifiedBy, webFormInstanceMetadata.lastModifiedBy) && Objects.equals(this.submittedDateTime, webFormInstanceMetadata.submittedDateTime) && Objects.equals((Object)this.instanceSource, (Object)webFormInstanceMetadata.instanceSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expirationDateTime, this.createdDateTime, this.createdBy, this.lastModifiedDateTime, this.lastModifiedBy, this.submittedDateTime, this.instanceSource});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormInstanceMetadata {\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    createdDateTime: ").append(this.toIndentedString(this.createdDateTime)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    lastModifiedDateTime: ").append(this.toIndentedString(this.lastModifiedDateTime)).append("\n");
        sb.append("    lastModifiedBy: ").append(this.toIndentedString(this.lastModifiedBy)).append("\n");
        sb.append("    submittedDateTime: ").append(this.toIndentedString(this.submittedDateTime)).append("\n");
        sb.append("    instanceSource: ").append(this.toIndentedString((Object)this.instanceSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

