/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.WebFormComponentType;
import com.docusign.webforms.model.WebFormSource;
import com.docusign.webforms.model.WebFormType;
import com.docusign.webforms.model.WebFormUserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="Form metadata")
public class WebFormMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="source")
    private WebFormSource source = null;
    @JsonProperty(value="type")
    private WebFormType type = null;
    @JsonProperty(value="sourceFormId")
    private String sourceFormId = null;
    @JsonProperty(value="owner")
    private WebFormUserInfo owner = null;
    @JsonProperty(value="sender")
    private WebFormUserInfo sender = null;
    @JsonProperty(value="lastModifiedBy")
    private WebFormUserInfo lastModifiedBy = null;
    @JsonProperty(value="formContentModifiedBy")
    private WebFormUserInfo formContentModifiedBy = null;
    @JsonProperty(value="formPropertiesModifiedBy")
    private WebFormUserInfo formPropertiesModifiedBy = null;
    @JsonProperty(value="lastPublishedBy")
    private WebFormUserInfo lastPublishedBy = null;
    @JsonProperty(value="lastEnabledBy")
    private WebFormUserInfo lastEnabledBy = null;
    @JsonProperty(value="lastDisabledBy")
    private WebFormUserInfo lastDisabledBy = null;
    @JsonProperty(value="archivedDateTime")
    private String archivedDateTime = null;
    @JsonProperty(value="createdDateTime")
    private String createdDateTime = null;
    @JsonProperty(value="lastModifiedDateTime")
    private String lastModifiedDateTime = null;
    @JsonProperty(value="formContentModifiedDateTime")
    private String formContentModifiedDateTime = null;
    @JsonProperty(value="formPropertiesModifiedDateTime")
    private String formPropertiesModifiedDateTime = null;
    @JsonProperty(value="lastPublishedDateTime")
    private String lastPublishedDateTime = null;
    @JsonProperty(value="lastEnabledDateTime")
    private String lastEnabledDateTime = null;
    @JsonProperty(value="lastDisabledDateTime")
    private String lastDisabledDateTime = null;
    @JsonProperty(value="lastSenderConsentDateTime")
    private String lastSenderConsentDateTime = null;
    @JsonProperty(value="publishedSlug")
    private String publishedSlug = null;
    @JsonProperty(value="publishedComponentNames")
    private Map<String, WebFormComponentType> publishedComponentNames = null;

    public WebFormMetadata source(WebFormSource source) {
        this.source = source;
        return this;
    }

    @Schema(description="The source from which the webform is created. Accepted values are [templates, blank, form]")
    public WebFormSource getSource() {
        return this.source;
    }

    public void setSource(WebFormSource source) {
        this.source = source;
    }

    public WebFormMetadata type(WebFormType type) {
        this.type = type;
        return this;
    }

    @Schema(description="Represents webform type. Possible values are [standalone, hasEsignTemplate]")
    public WebFormType getType() {
        return this.type;
    }

    public void setType(WebFormType type) {
        this.type = type;
    }

    public WebFormMetadata sourceFormId(String sourceFormId) {
        this.sourceFormId = sourceFormId;
        return this;
    }

    @Schema(description="The source form id from which the webform is created.")
    public String getSourceFormId() {
        return this.sourceFormId;
    }

    public void setSourceFormId(String sourceFormId) {
        this.sourceFormId = sourceFormId;
    }

    public WebFormMetadata owner(WebFormUserInfo owner) {
        this.owner = owner;
        return this;
    }

    @Schema(description="The user that created the form or has been transferred ownership")
    public WebFormUserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(WebFormUserInfo owner) {
        this.owner = owner;
    }

    public WebFormMetadata sender(WebFormUserInfo sender) {
        this.sender = sender;
        return this;
    }

    @Schema(description="The user that has added their consent to the form for sending actions")
    public WebFormUserInfo getSender() {
        return this.sender;
    }

    public void setSender(WebFormUserInfo sender) {
        this.sender = sender;
    }

    public WebFormMetadata lastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    @Schema(description="Track the user that last modified anything related to the form")
    public WebFormUserInfo getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public WebFormMetadata formContentModifiedBy(WebFormUserInfo formContentModifiedBy) {
        this.formContentModifiedBy = formContentModifiedBy;
        return this;
    }

    @Schema(description="Track the user that last modified the form content")
    public WebFormUserInfo getFormContentModifiedBy() {
        return this.formContentModifiedBy;
    }

    public void setFormContentModifiedBy(WebFormUserInfo formContentModifiedBy) {
        this.formContentModifiedBy = formContentModifiedBy;
    }

    public WebFormMetadata formPropertiesModifiedBy(WebFormUserInfo formPropertiesModifiedBy) {
        this.formPropertiesModifiedBy = formPropertiesModifiedBy;
        return this;
    }

    @Schema(description="Track the user that last modified the form properties")
    public WebFormUserInfo getFormPropertiesModifiedBy() {
        return this.formPropertiesModifiedBy;
    }

    public void setFormPropertiesModifiedBy(WebFormUserInfo formPropertiesModifiedBy) {
        this.formPropertiesModifiedBy = formPropertiesModifiedBy;
    }

    public WebFormMetadata lastPublishedBy(WebFormUserInfo lastPublishedBy) {
        this.lastPublishedBy = lastPublishedBy;
        return this;
    }

    @Schema(description="Track the user that last published a draft version to active")
    public WebFormUserInfo getLastPublishedBy() {
        return this.lastPublishedBy;
    }

    public void setLastPublishedBy(WebFormUserInfo lastPublishedBy) {
        this.lastPublishedBy = lastPublishedBy;
    }

    public WebFormMetadata lastEnabledBy(WebFormUserInfo lastEnabledBy) {
        this.lastEnabledBy = lastEnabledBy;
        return this;
    }

    @Schema(description="Track the user that last unpublished an active version")
    public WebFormUserInfo getLastEnabledBy() {
        return this.lastEnabledBy;
    }

    public void setLastEnabledBy(WebFormUserInfo lastEnabledBy) {
        this.lastEnabledBy = lastEnabledBy;
    }

    public WebFormMetadata lastDisabledBy(WebFormUserInfo lastDisabledBy) {
        this.lastDisabledBy = lastDisabledBy;
        return this;
    }

    @Schema(description="Track the user that last unpublished an active version")
    public WebFormUserInfo getLastDisabledBy() {
        return this.lastDisabledBy;
    }

    public void setLastDisabledBy(WebFormUserInfo lastDisabledBy) {
        this.lastDisabledBy = lastDisabledBy;
    }

    public WebFormMetadata archivedDateTime(String archivedDateTime) {
        this.archivedDateTime = archivedDateTime;
        return this;
    }

    @Schema(description="The last time the web form was archived")
    public String getArchivedDateTime() {
        return this.archivedDateTime;
    }

    public void setArchivedDateTime(String archivedDateTime) {
        this.archivedDateTime = archivedDateTime;
    }

    public WebFormMetadata createdDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    @Schema(description="Track the time the web form was created")
    public String getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public WebFormMetadata lastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Schema(description="The last time anything was modified on the form")
    public String getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public WebFormMetadata formContentModifiedDateTime(String formContentModifiedDateTime) {
        this.formContentModifiedDateTime = formContentModifiedDateTime;
        return this;
    }

    @Schema(description="Track the last time web form content changed.")
    public String getFormContentModifiedDateTime() {
        return this.formContentModifiedDateTime;
    }

    public void setFormContentModifiedDateTime(String formContentModifiedDateTime) {
        this.formContentModifiedDateTime = formContentModifiedDateTime;
    }

    public WebFormMetadata formPropertiesModifiedDateTime(String formPropertiesModifiedDateTime) {
        this.formPropertiesModifiedDateTime = formPropertiesModifiedDateTime;
        return this;
    }

    @Schema(description="Track the last time the form properties changed.")
    public String getFormPropertiesModifiedDateTime() {
        return this.formPropertiesModifiedDateTime;
    }

    public void setFormPropertiesModifiedDateTime(String formPropertiesModifiedDateTime) {
        this.formPropertiesModifiedDateTime = formPropertiesModifiedDateTime;
    }

    public WebFormMetadata lastPublishedDateTime(String lastPublishedDateTime) {
        this.lastPublishedDateTime = lastPublishedDateTime;
        return this;
    }

    @Schema(description="Track the last time a draft version was published to active")
    public String getLastPublishedDateTime() {
        return this.lastPublishedDateTime;
    }

    public void setLastPublishedDateTime(String lastPublishedDateTime) {
        this.lastPublishedDateTime = lastPublishedDateTime;
    }

    public WebFormMetadata lastEnabledDateTime(String lastEnabledDateTime) {
        this.lastEnabledDateTime = lastEnabledDateTime;
        return this;
    }

    @Schema(description="Track the last time the form was enabled")
    public String getLastEnabledDateTime() {
        return this.lastEnabledDateTime;
    }

    public void setLastEnabledDateTime(String lastEnabledDateTime) {
        this.lastEnabledDateTime = lastEnabledDateTime;
    }

    public WebFormMetadata lastDisabledDateTime(String lastDisabledDateTime) {
        this.lastDisabledDateTime = lastDisabledDateTime;
        return this;
    }

    @Schema(description="Track the last time the form was disabled")
    public String getLastDisabledDateTime() {
        return this.lastDisabledDateTime;
    }

    public void setLastDisabledDateTime(String lastDisabledDateTime) {
        this.lastDisabledDateTime = lastDisabledDateTime;
    }

    public WebFormMetadata lastSenderConsentDateTime(String lastSenderConsentDateTime) {
        this.lastSenderConsentDateTime = lastSenderConsentDateTime;
        return this;
    }

    @Schema(description="Track the last time a user added their consent for the form.")
    public String getLastSenderConsentDateTime() {
        return this.lastSenderConsentDateTime;
    }

    public void setLastSenderConsentDateTime(String lastSenderConsentDateTime) {
        this.lastSenderConsentDateTime = lastSenderConsentDateTime;
    }

    public WebFormMetadata publishedSlug(String publishedSlug) {
        this.publishedSlug = publishedSlug;
        return this;
    }

    @Schema(example="BFS6Zw9QxKnerieBsgRyif", description="The public friendly slug that is used to access the form from the player")
    public String getPublishedSlug() {
        return this.publishedSlug;
    }

    public void setPublishedSlug(String publishedSlug) {
        this.publishedSlug = publishedSlug;
    }

    public WebFormMetadata publishedComponentNames(Map<String, WebFormComponentType> publishedComponentNames) {
        this.publishedComponentNames = publishedComponentNames;
        return this;
    }

    public WebFormMetadata putPublishedComponentNamesItem(String key, WebFormComponentType publishedComponentNamesItem) {
        if (this.publishedComponentNames == null) {
            this.publishedComponentNames = new HashMap<String, WebFormComponentType>();
        }
        this.publishedComponentNames.put(key, publishedComponentNamesItem);
        return this;
    }

    @Schema(description="A dictionary containing the mapping of component names to their respective component types for all the published components.")
    public Map<String, WebFormComponentType> getPublishedComponentNames() {
        return this.publishedComponentNames;
    }

    public void setPublishedComponentNames(Map<String, WebFormComponentType> publishedComponentNames) {
        this.publishedComponentNames = publishedComponentNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormMetadata webFormMetadata = (WebFormMetadata)o;
        return Objects.equals((Object)this.source, (Object)webFormMetadata.source) && Objects.equals((Object)this.type, (Object)webFormMetadata.type) && Objects.equals(this.sourceFormId, webFormMetadata.sourceFormId) && Objects.equals(this.owner, webFormMetadata.owner) && Objects.equals(this.sender, webFormMetadata.sender) && Objects.equals(this.lastModifiedBy, webFormMetadata.lastModifiedBy) && Objects.equals(this.formContentModifiedBy, webFormMetadata.formContentModifiedBy) && Objects.equals(this.formPropertiesModifiedBy, webFormMetadata.formPropertiesModifiedBy) && Objects.equals(this.lastPublishedBy, webFormMetadata.lastPublishedBy) && Objects.equals(this.lastEnabledBy, webFormMetadata.lastEnabledBy) && Objects.equals(this.lastDisabledBy, webFormMetadata.lastDisabledBy) && Objects.equals(this.archivedDateTime, webFormMetadata.archivedDateTime) && Objects.equals(this.createdDateTime, webFormMetadata.createdDateTime) && Objects.equals(this.lastModifiedDateTime, webFormMetadata.lastModifiedDateTime) && Objects.equals(this.formContentModifiedDateTime, webFormMetadata.formContentModifiedDateTime) && Objects.equals(this.formPropertiesModifiedDateTime, webFormMetadata.formPropertiesModifiedDateTime) && Objects.equals(this.lastPublishedDateTime, webFormMetadata.lastPublishedDateTime) && Objects.equals(this.lastEnabledDateTime, webFormMetadata.lastEnabledDateTime) && Objects.equals(this.lastDisabledDateTime, webFormMetadata.lastDisabledDateTime) && Objects.equals(this.lastSenderConsentDateTime, webFormMetadata.lastSenderConsentDateTime) && Objects.equals(this.publishedSlug, webFormMetadata.publishedSlug) && Objects.equals(this.publishedComponentNames, webFormMetadata.publishedComponentNames);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.sourceFormId, this.owner, this.sender, this.lastModifiedBy, this.formContentModifiedBy, this.formPropertiesModifiedBy, this.lastPublishedBy, this.lastEnabledBy, this.lastDisabledBy, this.archivedDateTime, this.createdDateTime, this.lastModifiedDateTime, this.formContentModifiedDateTime, this.formPropertiesModifiedDateTime, this.lastPublishedDateTime, this.lastEnabledDateTime, this.lastDisabledDateTime, this.lastSenderConsentDateTime, this.publishedSlug, this.publishedComponentNames});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormMetadata {\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sourceFormId: ").append(this.toIndentedString(this.sourceFormId)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    lastModifiedBy: ").append(this.toIndentedString(this.lastModifiedBy)).append("\n");
        sb.append("    formContentModifiedBy: ").append(this.toIndentedString(this.formContentModifiedBy)).append("\n");
        sb.append("    formPropertiesModifiedBy: ").append(this.toIndentedString(this.formPropertiesModifiedBy)).append("\n");
        sb.append("    lastPublishedBy: ").append(this.toIndentedString(this.lastPublishedBy)).append("\n");
        sb.append("    lastEnabledBy: ").append(this.toIndentedString(this.lastEnabledBy)).append("\n");
        sb.append("    lastDisabledBy: ").append(this.toIndentedString(this.lastDisabledBy)).append("\n");
        sb.append("    archivedDateTime: ").append(this.toIndentedString(this.archivedDateTime)).append("\n");
        sb.append("    createdDateTime: ").append(this.toIndentedString(this.createdDateTime)).append("\n");
        sb.append("    lastModifiedDateTime: ").append(this.toIndentedString(this.lastModifiedDateTime)).append("\n");
        sb.append("    formContentModifiedDateTime: ").append(this.toIndentedString(this.formContentModifiedDateTime)).append("\n");
        sb.append("    formPropertiesModifiedDateTime: ").append(this.toIndentedString(this.formPropertiesModifiedDateTime)).append("\n");
        sb.append("    lastPublishedDateTime: ").append(this.toIndentedString(this.lastPublishedDateTime)).append("\n");
        sb.append("    lastEnabledDateTime: ").append(this.toIndentedString(this.lastEnabledDateTime)).append("\n");
        sb.append("    lastDisabledDateTime: ").append(this.toIndentedString(this.lastDisabledDateTime)).append("\n");
        sb.append("    lastSenderConsentDateTime: ").append(this.toIndentedString(this.lastSenderConsentDateTime)).append("\n");
        sb.append("    publishedSlug: ").append(this.toIndentedString(this.publishedSlug)).append("\n");
        sb.append("    publishedComponentNames: ").append(this.toIndentedString(this.publishedComponentNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

