/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk;

import com.docusign.iam.sdk.SDKConfiguration;
import com.docusign.iam.sdk.SecuritySource;
import com.docusign.iam.sdk.models.components.AuthorizationCodeGrantResponse;
import com.docusign.iam.sdk.models.components.ConfidentialAuthCodeGrantRequestBody;
import com.docusign.iam.sdk.models.components.JWTGrantResponse;
import com.docusign.iam.sdk.models.components.PublicAuthCodeGrantRequestBody;
import com.docusign.iam.sdk.models.components.UserInfo;
import com.docusign.iam.sdk.models.errors.APIException;
import com.docusign.iam.sdk.models.errors.OAuthErrorResponse;
import com.docusign.iam.sdk.models.operations.AuthorizationCodeGrant;
import com.docusign.iam.sdk.models.operations.GetTokenFromConfidentialAuthCodeRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetTokenFromConfidentialAuthCodeResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromConfidentialAuthCodeSecurity;
import com.docusign.iam.sdk.models.operations.GetTokenFromJWTGrantRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetTokenFromJWTGrantResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromPublicAuthCodeRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetTokenFromPublicAuthCodeResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenResponseBody;
import com.docusign.iam.sdk.models.operations.GetTokenFromRefreshTokenSecurity;
import com.docusign.iam.sdk.models.operations.GetUserInfoRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetUserInfoResponse;
import com.docusign.iam.sdk.models.operations.JWTGrant;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.BackoffStrategy;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.HTTPRequest;
import com.docusign.iam.sdk.utils.Hook;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.Retries;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.SerializedBody;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Auth
implements SDKMethodInterfaces.MethodCallGetTokenFromConfidentialAuthCode,
SDKMethodInterfaces.MethodCallGetTokenFromPublicAuthCode,
SDKMethodInterfaces.MethodCallGetTokenFromJWTGrant,
SDKMethodInterfaces.MethodCallGetTokenFromRefreshToken,
SDKMethodInterfaces.MethodCallGetUserInfo {
    public static final String[] GET_TOKEN_FROM_CONFIDENTIAL_AUTH_CODE_SERVERS = new String[]{"https://account-d.docusign.com", "https://account.docusign.com"};
    public static final String[] GET_TOKEN_FROM_PUBLIC_AUTH_CODE_SERVERS = new String[]{"https://account-d.docusign.com", "https://account.docusign.com"};
    public static final String[] GET_TOKEN_FROM_JWT_GRANT_SERVERS = new String[]{"https://account-d.docusign.com", "https://account.docusign.com"};
    public static final String[] GET_TOKEN_FROM_REFRESH_TOKEN_SERVERS = new String[]{"https://account-d.docusign.com", "https://account.docusign.com"};
    public static final String[] GET_USER_INFO_SERVERS = new String[]{"https://account-d.docusign.com", "https://account.docusign.com"};
    private final SDKConfiguration sdkConfiguration;

    Auth(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder getTokenFromConfidentialAuthCode() {
        return new GetTokenFromConfidentialAuthCodeRequestBuilder(this);
    }

    public GetTokenFromConfidentialAuthCodeResponse getTokenFromConfidentialAuthCode(ConfidentialAuthCodeGrantRequestBody request, GetTokenFromConfidentialAuthCodeSecurity security) throws Exception {
        return this.getTokenFromConfidentialAuthCode(request, security, Optional.empty(), Optional.empty());
    }

    @Override
    public GetTokenFromConfidentialAuthCodeResponse getTokenFromConfidentialAuthCode(ConfidentialAuthCodeGrantRequestBody request, GetTokenFromConfidentialAuthCodeSecurity security, Optional<String> serverURL, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = serverURL.isPresent() && !serverURL.get().isBlank() ? serverURL.get() : Utils.templateUrl(GET_TOKEN_FROM_CONFIDENTIAL_AUTH_CODE_SERVERS[0], new HashMap<String, String>());
        String _url = Utils.generateURL(_baseUrl, "/oauth/token#FromConfidentialAuthCode");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<ConfidentialAuthCodeGrantRequestBody>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "request", "form", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(SecuritySource.of(security));
        Utils.configureSecurity(_req, security);
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromConfidentialAuthCode", Optional.empty(), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromConfidentialAuthCode", Optional.empty(), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromConfidentialAuthCode", Optional.empty(), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetTokenFromConfidentialAuthCodeResponse.Builder _resBuilder = GetTokenFromConfidentialAuthCodeResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetTokenFromConfidentialAuthCodeResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AuthorizationCodeGrantResponse _out = (AuthorizationCodeGrantResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<AuthorizationCodeGrantResponse>(){});
                _res.withAuthorizationCodeGrantResponse(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OAuthErrorResponse _out = (OAuthErrorResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OAuthErrorResponse>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetTokenFromPublicAuthCodeRequestBuilder getTokenFromPublicAuthCode() {
        return new GetTokenFromPublicAuthCodeRequestBuilder(this);
    }

    public GetTokenFromPublicAuthCodeResponse getTokenFromPublicAuthCode(PublicAuthCodeGrantRequestBody request) throws Exception {
        return this.getTokenFromPublicAuthCode(request, Optional.empty(), Optional.empty());
    }

    @Override
    public GetTokenFromPublicAuthCodeResponse getTokenFromPublicAuthCode(PublicAuthCodeGrantRequestBody request, Optional<String> serverURL, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = serverURL.isPresent() && !serverURL.get().isBlank() ? serverURL.get() : Utils.templateUrl(GET_TOKEN_FROM_PUBLIC_AUTH_CODE_SERVERS[0], new HashMap<String, String>());
        String _url = Utils.generateURL(_baseUrl, "/oauth/token#FromPublicAuthCode");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<PublicAuthCodeGrantRequestBody>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "request", "form", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromPublicAuthCode", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromPublicAuthCode", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromPublicAuthCode", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetTokenFromPublicAuthCodeResponse.Builder _resBuilder = GetTokenFromPublicAuthCodeResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetTokenFromPublicAuthCodeResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AuthorizationCodeGrantResponse _out = (AuthorizationCodeGrantResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<AuthorizationCodeGrantResponse>(){});
                _res.withAuthorizationCodeGrantResponse(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OAuthErrorResponse _out = (OAuthErrorResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OAuthErrorResponse>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetTokenFromJWTGrantRequestBuilder getTokenFromJwtGrant() {
        return new GetTokenFromJWTGrantRequestBuilder(this);
    }

    public GetTokenFromJWTGrantResponse getTokenFromJwtGrant(JWTGrant request) throws Exception {
        return this.getTokenFromJwtGrant(request, Optional.empty(), Optional.empty());
    }

    @Override
    public GetTokenFromJWTGrantResponse getTokenFromJwtGrant(JWTGrant request, Optional<String> serverURL, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = serverURL.isPresent() && !serverURL.get().isBlank() ? serverURL.get() : Utils.templateUrl(GET_TOKEN_FROM_JWT_GRANT_SERVERS[0], new HashMap<String, String>());
        String _url = Utils.generateURL(_baseUrl, "/oauth/token#FromJWTGrant");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<JWTGrant>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "request", "form", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromJWTGrant", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromJWTGrant", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromJWTGrant", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetTokenFromJWTGrantResponse.Builder _resBuilder = GetTokenFromJWTGrantResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetTokenFromJWTGrantResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                JWTGrantResponse _out = (JWTGrantResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<JWTGrantResponse>(){});
                _res.withJWTGrantResponse(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OAuthErrorResponse _out = (OAuthErrorResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OAuthErrorResponse>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetTokenFromRefreshTokenRequestBuilder getTokenFromRefreshToken() {
        return new GetTokenFromRefreshTokenRequestBuilder(this);
    }

    public GetTokenFromRefreshTokenResponse getTokenFromRefreshToken(AuthorizationCodeGrant request, GetTokenFromRefreshTokenSecurity security) throws Exception {
        return this.getTokenFromRefreshToken(request, security, Optional.empty(), Optional.empty());
    }

    @Override
    public GetTokenFromRefreshTokenResponse getTokenFromRefreshToken(AuthorizationCodeGrant request, GetTokenFromRefreshTokenSecurity security, Optional<String> serverURL, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = serverURL.isPresent() && !serverURL.get().isBlank() ? serverURL.get() : Utils.templateUrl(GET_TOKEN_FROM_REFRESH_TOKEN_SERVERS[0], new HashMap<String, String>());
        String _url = Utils.generateURL(_baseUrl, "/oauth/token#FromRefreshToken");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<AuthorizationCodeGrant>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "request", "form", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(SecuritySource.of(security));
        Utils.configureSecurity(_req, security);
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromRefreshToken", Optional.empty(), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromRefreshToken", Optional.empty(), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetTokenFromRefreshToken", Optional.empty(), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetTokenFromRefreshTokenResponse.Builder _resBuilder = GetTokenFromRefreshTokenResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetTokenFromRefreshTokenResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                GetTokenFromRefreshTokenResponseBody _out = (GetTokenFromRefreshTokenResponseBody)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<GetTokenFromRefreshTokenResponseBody>(){});
                _res.withObject(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OAuthErrorResponse _out = (OAuthErrorResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OAuthErrorResponse>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetUserInfoRequestBuilder getUserInfo() {
        return new GetUserInfoRequestBuilder(this);
    }

    public GetUserInfoResponse getUserInfoDirect() throws Exception {
        return this.getUserInfo(Optional.empty(), Optional.empty());
    }

    @Override
    public GetUserInfoResponse getUserInfo(Optional<String> serverURL, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = serverURL.isPresent() && !serverURL.get().isBlank() ? serverURL.get() : Utils.templateUrl(GET_USER_INFO_SERVERS[0], new HashMap<String, String>());
        String _url = Utils.generateURL(_baseUrl, "/oauth/userinfo");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetUserInfo", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetUserInfo", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetUserInfo", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetUserInfoResponse.Builder _resBuilder = GetUserInfoResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetUserInfoResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                UserInfo _out = (UserInfo)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<UserInfo>(){});
                _res.withUserInfo(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                OAuthErrorResponse _out = (OAuthErrorResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<OAuthErrorResponse>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

