/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk;

import com.docusign.iam.sdk.SDKConfiguration;
import com.docusign.iam.sdk.SecuritySource;
import com.docusign.iam.sdk.models.components.CancelWorkflowInstanceResponse;
import com.docusign.iam.sdk.models.components.WorkflowInstance;
import com.docusign.iam.sdk.models.components.WorkflowInstanceCollection;
import com.docusign.iam.sdk.models.errors.APIException;
import com.docusign.iam.sdk.models.errors.Error;
import com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceRequest;
import com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceRequestBuilder;
import com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceResponse;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstanceRequest;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstanceRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstanceResponse;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstancesListRequest;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstancesListRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetWorkflowInstancesListResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.BackoffStrategy;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.HTTPRequest;
import com.docusign.iam.sdk.utils.Hook;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.Retries;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class WorkflowInstanceManagement
implements SDKMethodInterfaces.MethodCallGetWorkflowInstancesList,
SDKMethodInterfaces.MethodCallGetWorkflowInstance,
SDKMethodInterfaces.MethodCallCancelWorkflowInstance {
    private final SDKConfiguration sdkConfiguration;

    WorkflowInstanceManagement(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetWorkflowInstancesListRequestBuilder getWorkflowInstancesList() {
        return new GetWorkflowInstancesListRequestBuilder(this);
    }

    public GetWorkflowInstancesListResponse getWorkflowInstancesList(String accountId, String workflowId) throws Exception {
        return this.getWorkflowInstancesList(accountId, workflowId, Optional.empty());
    }

    @Override
    public GetWorkflowInstancesListResponse getWorkflowInstancesList(String accountId, String workflowId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetWorkflowInstancesListRequest request = GetWorkflowInstancesListRequest.builder().accountId(accountId).workflowId(workflowId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(GetWorkflowInstancesListRequest.class, _baseUrl, "/accounts/{accountId}/workflows/{workflowId}/instances", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstancesList", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstancesList", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstancesList", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetWorkflowInstancesListResponse.Builder _resBuilder = GetWorkflowInstancesListResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetWorkflowInstancesListResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                WorkflowInstanceCollection _out = (WorkflowInstanceCollection)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<WorkflowInstanceCollection>(){});
                _res.withWorkflowInstanceCollection(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetWorkflowInstanceRequestBuilder getWorkflowInstance() {
        return new GetWorkflowInstanceRequestBuilder(this);
    }

    public GetWorkflowInstanceResponse getWorkflowInstance(String accountId, String workflowId, String instanceId) throws Exception {
        return this.getWorkflowInstance(accountId, workflowId, instanceId, Optional.empty());
    }

    @Override
    public GetWorkflowInstanceResponse getWorkflowInstance(String accountId, String workflowId, String instanceId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetWorkflowInstanceRequest request = GetWorkflowInstanceRequest.builder().accountId(accountId).workflowId(workflowId).instanceId(instanceId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(GetWorkflowInstanceRequest.class, _baseUrl, "/accounts/{accountId}/workflows/{workflowId}/instances/{instanceId}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "getWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetWorkflowInstanceResponse.Builder _resBuilder = GetWorkflowInstanceResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetWorkflowInstanceResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                WorkflowInstance _out = (WorkflowInstance)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<WorkflowInstance>(){});
                _res.withWorkflowInstance(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CancelWorkflowInstanceRequestBuilder cancelWorkflowInstance() {
        return new CancelWorkflowInstanceRequestBuilder(this);
    }

    public com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceResponse cancelWorkflowInstance(String accountId, String workflowId, String instanceId) throws Exception {
        return this.cancelWorkflowInstance(accountId, workflowId, instanceId, Optional.empty());
    }

    @Override
    public com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceResponse cancelWorkflowInstance(String accountId, String workflowId, String instanceId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CancelWorkflowInstanceRequest request = CancelWorkflowInstanceRequest.builder().accountId(accountId).workflowId(workflowId).instanceId(instanceId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(CancelWorkflowInstanceRequest.class, _baseUrl, "/accounts/{accountId}/workflows/{workflowId}/instances/{instanceId}/actions/cancel", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "cancelWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "cancelWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "cancelWorkflowInstance", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CancelWorkflowInstanceResponse.Builder _resBuilder = com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        com.docusign.iam.sdk.models.operations.CancelWorkflowInstanceResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                CancelWorkflowInstanceResponse _out = (CancelWorkflowInstanceResponse)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<CancelWorkflowInstanceResponse>(){});
                _res.withCancelWorkflowInstanceResponse(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

