/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk;

import com.docusign.iam.sdk.SDKConfiguration;
import com.docusign.iam.sdk.SecuritySource;
import com.docusign.iam.sdk.models.components.TriggerWorkflow;
import com.docusign.iam.sdk.models.components.TriggerWorkflowSuccess;
import com.docusign.iam.sdk.models.components.WorkflowTriggerRequirementsSuccess;
import com.docusign.iam.sdk.models.components.WorkflowsListSuccess;
import com.docusign.iam.sdk.models.errors.APIException;
import com.docusign.iam.sdk.models.errors.Error;
import com.docusign.iam.sdk.models.operations.GetWorkflowTriggerRequirementsRequest;
import com.docusign.iam.sdk.models.operations.GetWorkflowTriggerRequirementsRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetWorkflowTriggerRequirementsResponse;
import com.docusign.iam.sdk.models.operations.GetWorkflowsListRequest;
import com.docusign.iam.sdk.models.operations.GetWorkflowsListRequestBuilder;
import com.docusign.iam.sdk.models.operations.GetWorkflowsListResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.models.operations.TriggerWorkflowRequest;
import com.docusign.iam.sdk.models.operations.TriggerWorkflowRequestBuilder;
import com.docusign.iam.sdk.models.operations.TriggerWorkflowResponse;
import com.docusign.iam.sdk.utils.BackoffStrategy;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.HTTPRequest;
import com.docusign.iam.sdk.utils.Hook;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.Retries;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.SerializedBody;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Workflows
implements SDKMethodInterfaces.MethodCallGetWorkflowsList,
SDKMethodInterfaces.MethodCallGetWorkflowTriggerRequirements,
SDKMethodInterfaces.MethodCallTriggerWorkflow {
    private final SDKConfiguration sdkConfiguration;

    Workflows(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetWorkflowsListRequestBuilder getWorkflowsList() {
        return new GetWorkflowsListRequestBuilder(this);
    }

    public GetWorkflowsListResponse getWorkflowsList(String accountId) throws Exception {
        return this.getWorkflowsList(accountId, Optional.empty());
    }

    @Override
    public GetWorkflowsListResponse getWorkflowsList(String accountId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetWorkflowsListRequest request = GetWorkflowsListRequest.builder().accountId(accountId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(GetWorkflowsListRequest.class, _baseUrl, "/accounts/{accountId}/workflows", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowsList", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowsList", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowsList", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetWorkflowsListResponse.Builder _resBuilder = GetWorkflowsListResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetWorkflowsListResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                WorkflowsListSuccess _out = (WorkflowsListSuccess)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<WorkflowsListSuccess>(){});
                _res.withWorkflowsListSuccess(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GetWorkflowTriggerRequirementsRequestBuilder getWorkflowTriggerRequirements() {
        return new GetWorkflowTriggerRequirementsRequestBuilder(this);
    }

    public GetWorkflowTriggerRequirementsResponse getWorkflowTriggerRequirements(String accountId, String workflowId) throws Exception {
        return this.getWorkflowTriggerRequirements(accountId, workflowId, Optional.empty());
    }

    @Override
    public GetWorkflowTriggerRequirementsResponse getWorkflowTriggerRequirements(String accountId, String workflowId, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        GetWorkflowTriggerRequirementsRequest request = GetWorkflowTriggerRequirementsRequest.builder().accountId(accountId).workflowId(workflowId).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(GetWorkflowTriggerRequirementsRequest.class, _baseUrl, "/accounts/{accountId}/workflows/{workflowId}/trigger-requirements", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowTriggerRequirements", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowTriggerRequirements", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GetWorkflowTriggerRequirements", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GetWorkflowTriggerRequirementsResponse.Builder _resBuilder = GetWorkflowTriggerRequirementsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GetWorkflowTriggerRequirementsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                WorkflowTriggerRequirementsSuccess _out = (WorkflowTriggerRequirementsSuccess)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<WorkflowTriggerRequirementsSuccess>(){});
                _res.withWorkflowTriggerRequirementsSuccess(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public TriggerWorkflowRequestBuilder triggerWorkflow() {
        return new TriggerWorkflowRequestBuilder(this);
    }

    public TriggerWorkflowResponse triggerWorkflow(String accountId, String workflowId, TriggerWorkflow triggerWorkflow) throws Exception {
        return this.triggerWorkflow(accountId, workflowId, triggerWorkflow, Optional.empty());
    }

    @Override
    public TriggerWorkflowResponse triggerWorkflow(String accountId, String workflowId, TriggerWorkflow triggerWorkflow, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        TriggerWorkflowRequest request = TriggerWorkflowRequest.builder().accountId(accountId).workflowId(workflowId).triggerWorkflow(triggerWorkflow).build();
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(TriggerWorkflowRequest.class, _baseUrl, "/accounts/{accountId}/workflows/{workflowId}/actions/trigger", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "triggerWorkflow", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(5000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(30000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        _statusCodes.add("429");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "TriggerWorkflow", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "TriggerWorkflow", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "TriggerWorkflow", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        TriggerWorkflowResponse.Builder _resBuilder = TriggerWorkflowResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        TriggerWorkflowResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "201")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                TriggerWorkflowSuccess _out = (TriggerWorkflowSuccess)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<TriggerWorkflowSuccess>(){});
                _res.withTriggerWorkflowSuccess(Optional.ofNullable(_out));
                return _res;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "401", "403", "404")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                Error _out = (Error)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<Error>(){});
                throw _out;
            }
            throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new APIException(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new APIException(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

