/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class AgreementSummary {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="summary")
    private Optional<String> summary;

    @JsonCreator
    public AgreementSummary(@JsonProperty(value="summary") Optional<String> summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = summary;
    }

    public AgreementSummary() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> summary() {
        return this.summary;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AgreementSummary withSummary(String summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = Optional.ofNullable(summary);
        return this;
    }

    public AgreementSummary withSummary(Optional<String> summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = summary;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgreementSummary other = (AgreementSummary)o;
        return Objects.deepEquals(this.summary, other.summary);
    }

    public int hashCode() {
        return Objects.hash(this.summary);
    }

    public String toString() {
        return Utils.toString(AgreementSummary.class, "summary", this.summary);
    }

    public static final class Builder {
        private Optional<String> summary = Optional.empty();

        private Builder() {
        }

        public Builder summary(String summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = Optional.ofNullable(summary);
            return this;
        }

        public Builder summary(Optional<String> summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = summary;
            return this;
        }

        public AgreementSummary build() {
            return new AgreementSummary(this.summary);
        }
    }
}

