/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class AuthorizationCodeGrantResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;

    @JsonCreator
    public AuthorizationCodeGrantResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="expires_in") long expiresIn) {
        Utils.checkNotNull(accessToken, "accessToken");
        Utils.checkNotNull(tokenType, "tokenType");
        Utils.checkNotNull(refreshToken, "refreshToken");
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }

    @JsonIgnore
    public String accessToken() {
        return this.accessToken;
    }

    @JsonIgnore
    public String tokenType() {
        return this.tokenType;
    }

    @JsonIgnore
    public String refreshToken() {
        return this.refreshToken;
    }

    @JsonIgnore
    public long expiresIn() {
        return this.expiresIn;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AuthorizationCodeGrantResponse withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    public AuthorizationCodeGrantResponse withTokenType(String tokenType) {
        Utils.checkNotNull(tokenType, "tokenType");
        this.tokenType = tokenType;
        return this;
    }

    public AuthorizationCodeGrantResponse withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    public AuthorizationCodeGrantResponse withExpiresIn(long expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = expiresIn;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationCodeGrantResponse other = (AuthorizationCodeGrantResponse)o;
        return Objects.deepEquals(this.accessToken, other.accessToken) && Objects.deepEquals(this.tokenType, other.tokenType) && Objects.deepEquals(this.refreshToken, other.refreshToken) && Objects.deepEquals(this.expiresIn, other.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn);
    }

    public String toString() {
        return Utils.toString(AuthorizationCodeGrantResponse.class, "accessToken", this.accessToken, "tokenType", this.tokenType, "refreshToken", this.refreshToken, "expiresIn", this.expiresIn);
    }

    public static final class Builder {
        private String accessToken;
        private String tokenType;
        private String refreshToken;
        private Long expiresIn;

        private Builder() {
        }

        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            Utils.checkNotNull(tokenType, "tokenType");
            this.tokenType = tokenType;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = expiresIn;
            return this;
        }

        public AuthorizationCodeGrantResponse build() {
            return new AuthorizationCodeGrantResponse(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn);
        }
    }
}

