/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.OneOfDeserializer;
import com.docusign.iam.sdk.utils.TypedObject;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=_Deserializer.class)
public class CustomProperty {
    @JsonValue
    private TypedObject value;

    private CustomProperty(TypedObject value) {
        this.value = value;
    }

    public static CustomProperty of(String value) {
        Utils.checkNotNull(value, "value");
        return new CustomProperty(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<String>(){}));
    }

    public static CustomProperty of(double value) {
        Utils.checkNotNull(value, "value");
        return new CustomProperty(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<Double>(){}));
    }

    public static CustomProperty of(boolean value) {
        Utils.checkNotNull(value, "value");
        return new CustomProperty(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<Boolean>(){}));
    }

    public static CustomProperty of(Map<String, Object> value) {
        Utils.checkNotNull(value, "value");
        return new CustomProperty(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<Map<String, Object>>(){}));
    }

    public static CustomProperty of(List<Object> value) {
        Utils.checkNotNull(value, "value");
        return new CustomProperty(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<List<Object>>(){}));
    }

    public Object value() {
        return this.value.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomProperty other = (CustomProperty)o;
        return Objects.deepEquals(this.value.value(), other.value.value());
    }

    public int hashCode() {
        return Objects.hash(this.value.value());
    }

    public String toString() {
        return Utils.toString(CustomProperty.class, "value", this.value);
    }

    public static final class _Deserializer
    extends OneOfDeserializer<CustomProperty> {
        public _Deserializer() {
            super(CustomProperty.class, false, Utils.TypeReferenceWithShape.of(new TypeReference<List<Object>>(){}, Utils.JsonShape.DEFAULT), Utils.TypeReferenceWithShape.of(new TypeReference<Map<String, Object>>(){}, Utils.JsonShape.DEFAULT), Utils.TypeReferenceWithShape.of(new TypeReference<Boolean>(){}, Utils.JsonShape.DEFAULT), Utils.TypeReferenceWithShape.of(new TypeReference<Double>(){}, Utils.JsonShape.DEFAULT), Utils.TypeReferenceWithShape.of(new TypeReference<String>(){}, Utils.JsonShape.DEFAULT));
        }
    }
}

