/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class JWTGrantResponse {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="expires_in")
    private long expiresIn;

    @JsonCreator
    public JWTGrantResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="expires_in") long expiresIn) {
        Utils.checkNotNull(accessToken, "accessToken");
        Utils.checkNotNull(tokenType, "tokenType");
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    @JsonIgnore
    public String accessToken() {
        return this.accessToken;
    }

    @JsonIgnore
    public String tokenType() {
        return this.tokenType;
    }

    @JsonIgnore
    public long expiresIn() {
        return this.expiresIn;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public JWTGrantResponse withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    public JWTGrantResponse withTokenType(String tokenType) {
        Utils.checkNotNull(tokenType, "tokenType");
        this.tokenType = tokenType;
        return this;
    }

    public JWTGrantResponse withExpiresIn(long expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = expiresIn;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTGrantResponse other = (JWTGrantResponse)o;
        return Objects.deepEquals(this.accessToken, other.accessToken) && Objects.deepEquals(this.tokenType, other.tokenType) && Objects.deepEquals(this.expiresIn, other.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn);
    }

    public String toString() {
        return Utils.toString(JWTGrantResponse.class, "accessToken", this.accessToken, "tokenType", this.tokenType, "expiresIn", this.expiresIn);
    }

    public static final class Builder {
        private String accessToken;
        private String tokenType;
        private Long expiresIn;

        private Builder() {
        }

        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            Utils.checkNotNull(tokenType, "tokenType");
            this.tokenType = tokenType;
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = expiresIn;
            return this;
        }

        public JWTGrantResponse build() {
            return new JWTGrantResponse(this.accessToken, this.tokenType, this.expiresIn);
        }
    }
}

