/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Party {
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name_in_agreement")
    private JsonNullable<String> nameInAgreement;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="preferred_name")
    private JsonNullable<String> preferredName;

    @JsonCreator
    public Party(@JsonProperty(value="id") String id, @JsonProperty(value="name_in_agreement") JsonNullable<String> nameInAgreement, @JsonProperty(value="preferred_name") JsonNullable<String> preferredName) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(nameInAgreement, "nameInAgreement");
        Utils.checkNotNull(preferredName, "preferredName");
        this.id = id;
        this.nameInAgreement = nameInAgreement;
        this.preferredName = preferredName;
    }

    public Party(String id) {
        this(id, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> nameInAgreement() {
        return this.nameInAgreement;
    }

    @JsonIgnore
    public JsonNullable<String> preferredName() {
        return this.preferredName;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Party withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Party withNameInAgreement(String nameInAgreement) {
        Utils.checkNotNull(nameInAgreement, "nameInAgreement");
        this.nameInAgreement = JsonNullable.of((Object)nameInAgreement);
        return this;
    }

    public Party withNameInAgreement(JsonNullable<String> nameInAgreement) {
        Utils.checkNotNull(nameInAgreement, "nameInAgreement");
        this.nameInAgreement = nameInAgreement;
        return this;
    }

    public Party withPreferredName(String preferredName) {
        Utils.checkNotNull(preferredName, "preferredName");
        this.preferredName = JsonNullable.of((Object)preferredName);
        return this;
    }

    public Party withPreferredName(JsonNullable<String> preferredName) {
        Utils.checkNotNull(preferredName, "preferredName");
        this.preferredName = preferredName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Party other = (Party)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.nameInAgreement, other.nameInAgreement) && Objects.deepEquals(this.preferredName, other.preferredName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.nameInAgreement, this.preferredName);
    }

    public String toString() {
        return Utils.toString(Party.class, "id", this.id, "nameInAgreement", this.nameInAgreement, "preferredName", this.preferredName);
    }

    public static final class Builder {
        private String id;
        private JsonNullable<String> nameInAgreement = JsonNullable.undefined();
        private JsonNullable<String> preferredName = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder nameInAgreement(String nameInAgreement) {
            Utils.checkNotNull(nameInAgreement, "nameInAgreement");
            this.nameInAgreement = JsonNullable.of((Object)nameInAgreement);
            return this;
        }

        public Builder nameInAgreement(JsonNullable<String> nameInAgreement) {
            Utils.checkNotNull(nameInAgreement, "nameInAgreement");
            this.nameInAgreement = nameInAgreement;
            return this;
        }

        public Builder preferredName(String preferredName) {
            Utils.checkNotNull(preferredName, "preferredName");
            this.preferredName = JsonNullable.of((Object)preferredName);
            return this;
        }

        public Builder preferredName(JsonNullable<String> preferredName) {
            Utils.checkNotNull(preferredName, "preferredName");
            this.preferredName = preferredName;
            return this;
        }

        public Party build() {
            return new Party(this.id, this.nameInAgreement, this.preferredName);
        }
    }
}

