/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.CurrencyCode;
import com.docusign.iam.sdk.models.components.PaymentTermsDueDate;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Provisions {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="assignment_type")
    private Optional<String> assignmentType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="assignment_change_of_control")
    private Optional<String> assignmentChangeOfControl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="assignment_termination_rights")
    private Optional<String> assignmentTerminationRights;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="confidentiality_obligation_period")
    private JsonNullable<String> confidentialityObligationPeriod;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="governing_law")
    private JsonNullable<String> governingLaw;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="jurisdiction")
    private JsonNullable<String> jurisdiction;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="nda_type")
    private JsonNullable<String> ndaType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="annual_agreement_value")
    private JsonNullable<Double> annualAgreementValue;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="annual_agreement_value_currency_code")
    private JsonNullable<? extends CurrencyCode> annualAgreementValueCurrencyCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="total_agreement_value")
    private JsonNullable<Double> totalAgreementValue;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="total_agreement_value_currency_code")
    private JsonNullable<? extends CurrencyCode> totalAgreementValueCurrencyCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="payment_terms_due_date")
    private Optional<? extends PaymentTermsDueDate> paymentTermsDueDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="can_charge_late_payment_fees")
    private JsonNullable<Boolean> canChargeLatePaymentFees;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="late_payment_fee_percent")
    private JsonNullable<Long> latePaymentFeePercent;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="liability_cap_fixed_amount")
    private JsonNullable<Double> liabilityCapFixedAmount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="liability_cap_currency_code")
    private JsonNullable<? extends CurrencyCode> liabilityCapCurrencyCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="liability_cap_multiplier")
    private JsonNullable<Double> liabilityCapMultiplier;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="liability_cap_duration")
    private JsonNullable<String> liabilityCapDuration;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="price_cap_percent_increase")
    private JsonNullable<Float> priceCapPercentIncrease;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_type")
    private JsonNullable<String> renewalType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_notice_period")
    private JsonNullable<String> renewalNoticePeriod;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_notice_date")
    private JsonNullable<OffsetDateTime> renewalNoticeDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="auto_renewal_term_length")
    private JsonNullable<String> autoRenewalTermLength;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_extension_period")
    private JsonNullable<String> renewalExtensionPeriod;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_process_owner")
    private JsonNullable<String> renewalProcessOwner;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="renewal_additional_info")
    private JsonNullable<String> renewalAdditionalInfo;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="termination_period_for_cause")
    private JsonNullable<String> terminationPeriodForCause;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="termination_period_for_convenience")
    private JsonNullable<String> terminationPeriodForConvenience;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="effective_date")
    private JsonNullable<LocalDate> effectiveDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expiration_date")
    private JsonNullable<LocalDate> expirationDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="execution_date")
    private JsonNullable<LocalDate> executionDate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="term_length")
    private JsonNullable<String> termLength;

    @JsonCreator
    public Provisions(@JsonProperty(value="assignment_type") Optional<String> assignmentType, @JsonProperty(value="assignment_change_of_control") Optional<String> assignmentChangeOfControl, @JsonProperty(value="assignment_termination_rights") Optional<String> assignmentTerminationRights, @JsonProperty(value="confidentiality_obligation_period") JsonNullable<String> confidentialityObligationPeriod, @JsonProperty(value="governing_law") JsonNullable<String> governingLaw, @JsonProperty(value="jurisdiction") JsonNullable<String> jurisdiction, @JsonProperty(value="nda_type") JsonNullable<String> ndaType, @JsonProperty(value="annual_agreement_value") JsonNullable<Double> annualAgreementValue, @JsonProperty(value="annual_agreement_value_currency_code") JsonNullable<? extends CurrencyCode> annualAgreementValueCurrencyCode, @JsonProperty(value="total_agreement_value") JsonNullable<Double> totalAgreementValue, @JsonProperty(value="total_agreement_value_currency_code") JsonNullable<? extends CurrencyCode> totalAgreementValueCurrencyCode, @JsonProperty(value="payment_terms_due_date") Optional<? extends PaymentTermsDueDate> paymentTermsDueDate, @JsonProperty(value="can_charge_late_payment_fees") JsonNullable<Boolean> canChargeLatePaymentFees, @JsonProperty(value="late_payment_fee_percent") JsonNullable<Long> latePaymentFeePercent, @JsonProperty(value="liability_cap_fixed_amount") JsonNullable<Double> liabilityCapFixedAmount, @JsonProperty(value="liability_cap_currency_code") JsonNullable<? extends CurrencyCode> liabilityCapCurrencyCode, @JsonProperty(value="liability_cap_multiplier") JsonNullable<Double> liabilityCapMultiplier, @JsonProperty(value="liability_cap_duration") JsonNullable<String> liabilityCapDuration, @JsonProperty(value="price_cap_percent_increase") JsonNullable<Float> priceCapPercentIncrease, @JsonProperty(value="renewal_type") JsonNullable<String> renewalType, @JsonProperty(value="renewal_notice_period") JsonNullable<String> renewalNoticePeriod, @JsonProperty(value="renewal_notice_date") JsonNullable<OffsetDateTime> renewalNoticeDate, @JsonProperty(value="auto_renewal_term_length") JsonNullable<String> autoRenewalTermLength, @JsonProperty(value="renewal_extension_period") JsonNullable<String> renewalExtensionPeriod, @JsonProperty(value="renewal_process_owner") JsonNullable<String> renewalProcessOwner, @JsonProperty(value="renewal_additional_info") JsonNullable<String> renewalAdditionalInfo, @JsonProperty(value="termination_period_for_cause") JsonNullable<String> terminationPeriodForCause, @JsonProperty(value="termination_period_for_convenience") JsonNullable<String> terminationPeriodForConvenience, @JsonProperty(value="effective_date") JsonNullable<LocalDate> effectiveDate, @JsonProperty(value="expiration_date") JsonNullable<LocalDate> expirationDate, @JsonProperty(value="execution_date") JsonNullable<LocalDate> executionDate, @JsonProperty(value="term_length") JsonNullable<String> termLength) {
        Utils.checkNotNull(assignmentType, "assignmentType");
        Utils.checkNotNull(assignmentChangeOfControl, "assignmentChangeOfControl");
        Utils.checkNotNull(assignmentTerminationRights, "assignmentTerminationRights");
        Utils.checkNotNull(confidentialityObligationPeriod, "confidentialityObligationPeriod");
        Utils.checkNotNull(governingLaw, "governingLaw");
        Utils.checkNotNull(jurisdiction, "jurisdiction");
        Utils.checkNotNull(ndaType, "ndaType");
        Utils.checkNotNull(annualAgreementValue, "annualAgreementValue");
        Utils.checkNotNull(annualAgreementValueCurrencyCode, "annualAgreementValueCurrencyCode");
        Utils.checkNotNull(totalAgreementValue, "totalAgreementValue");
        Utils.checkNotNull(totalAgreementValueCurrencyCode, "totalAgreementValueCurrencyCode");
        Utils.checkNotNull(paymentTermsDueDate, "paymentTermsDueDate");
        Utils.checkNotNull(canChargeLatePaymentFees, "canChargeLatePaymentFees");
        Utils.checkNotNull(latePaymentFeePercent, "latePaymentFeePercent");
        Utils.checkNotNull(liabilityCapFixedAmount, "liabilityCapFixedAmount");
        Utils.checkNotNull(liabilityCapCurrencyCode, "liabilityCapCurrencyCode");
        Utils.checkNotNull(liabilityCapMultiplier, "liabilityCapMultiplier");
        Utils.checkNotNull(liabilityCapDuration, "liabilityCapDuration");
        Utils.checkNotNull(priceCapPercentIncrease, "priceCapPercentIncrease");
        Utils.checkNotNull(renewalType, "renewalType");
        Utils.checkNotNull(renewalNoticePeriod, "renewalNoticePeriod");
        Utils.checkNotNull(renewalNoticeDate, "renewalNoticeDate");
        Utils.checkNotNull(autoRenewalTermLength, "autoRenewalTermLength");
        Utils.checkNotNull(renewalExtensionPeriod, "renewalExtensionPeriod");
        Utils.checkNotNull(renewalProcessOwner, "renewalProcessOwner");
        Utils.checkNotNull(renewalAdditionalInfo, "renewalAdditionalInfo");
        Utils.checkNotNull(terminationPeriodForCause, "terminationPeriodForCause");
        Utils.checkNotNull(terminationPeriodForConvenience, "terminationPeriodForConvenience");
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        Utils.checkNotNull(expirationDate, "expirationDate");
        Utils.checkNotNull(executionDate, "executionDate");
        Utils.checkNotNull(termLength, "termLength");
        this.assignmentType = assignmentType;
        this.assignmentChangeOfControl = assignmentChangeOfControl;
        this.assignmentTerminationRights = assignmentTerminationRights;
        this.confidentialityObligationPeriod = confidentialityObligationPeriod;
        this.governingLaw = governingLaw;
        this.jurisdiction = jurisdiction;
        this.ndaType = ndaType;
        this.annualAgreementValue = annualAgreementValue;
        this.annualAgreementValueCurrencyCode = annualAgreementValueCurrencyCode;
        this.totalAgreementValue = totalAgreementValue;
        this.totalAgreementValueCurrencyCode = totalAgreementValueCurrencyCode;
        this.paymentTermsDueDate = paymentTermsDueDate;
        this.canChargeLatePaymentFees = canChargeLatePaymentFees;
        this.latePaymentFeePercent = latePaymentFeePercent;
        this.liabilityCapFixedAmount = liabilityCapFixedAmount;
        this.liabilityCapCurrencyCode = liabilityCapCurrencyCode;
        this.liabilityCapMultiplier = liabilityCapMultiplier;
        this.liabilityCapDuration = liabilityCapDuration;
        this.priceCapPercentIncrease = priceCapPercentIncrease;
        this.renewalType = renewalType;
        this.renewalNoticePeriod = renewalNoticePeriod;
        this.renewalNoticeDate = renewalNoticeDate;
        this.autoRenewalTermLength = autoRenewalTermLength;
        this.renewalExtensionPeriod = renewalExtensionPeriod;
        this.renewalProcessOwner = renewalProcessOwner;
        this.renewalAdditionalInfo = renewalAdditionalInfo;
        this.terminationPeriodForCause = terminationPeriodForCause;
        this.terminationPeriodForConvenience = terminationPeriodForConvenience;
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.executionDate = executionDate;
        this.termLength = termLength;
    }

    public Provisions() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<? extends CurrencyCode>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<? extends CurrencyCode>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<? extends CurrencyCode>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Float>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<LocalDate>)JsonNullable.undefined(), (JsonNullable<LocalDate>)JsonNullable.undefined(), (JsonNullable<LocalDate>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<String> assignmentType() {
        return this.assignmentType;
    }

    @JsonIgnore
    public Optional<String> assignmentChangeOfControl() {
        return this.assignmentChangeOfControl;
    }

    @JsonIgnore
    public Optional<String> assignmentTerminationRights() {
        return this.assignmentTerminationRights;
    }

    @JsonIgnore
    public JsonNullable<String> confidentialityObligationPeriod() {
        return this.confidentialityObligationPeriod;
    }

    @JsonIgnore
    public JsonNullable<String> governingLaw() {
        return this.governingLaw;
    }

    @JsonIgnore
    public JsonNullable<String> jurisdiction() {
        return this.jurisdiction;
    }

    @JsonIgnore
    public JsonNullable<String> ndaType() {
        return this.ndaType;
    }

    @JsonIgnore
    public JsonNullable<Double> annualAgreementValue() {
        return this.annualAgreementValue;
    }

    @JsonIgnore
    public JsonNullable<CurrencyCode> annualAgreementValueCurrencyCode() {
        return this.annualAgreementValueCurrencyCode;
    }

    @JsonIgnore
    public JsonNullable<Double> totalAgreementValue() {
        return this.totalAgreementValue;
    }

    @JsonIgnore
    public JsonNullable<CurrencyCode> totalAgreementValueCurrencyCode() {
        return this.totalAgreementValueCurrencyCode;
    }

    @JsonIgnore
    public Optional<PaymentTermsDueDate> paymentTermsDueDate() {
        return this.paymentTermsDueDate;
    }

    @JsonIgnore
    public JsonNullable<Boolean> canChargeLatePaymentFees() {
        return this.canChargeLatePaymentFees;
    }

    @JsonIgnore
    public JsonNullable<Long> latePaymentFeePercent() {
        return this.latePaymentFeePercent;
    }

    @JsonIgnore
    public JsonNullable<Double> liabilityCapFixedAmount() {
        return this.liabilityCapFixedAmount;
    }

    @JsonIgnore
    public JsonNullable<CurrencyCode> liabilityCapCurrencyCode() {
        return this.liabilityCapCurrencyCode;
    }

    @JsonIgnore
    public JsonNullable<Double> liabilityCapMultiplier() {
        return this.liabilityCapMultiplier;
    }

    @JsonIgnore
    public JsonNullable<String> liabilityCapDuration() {
        return this.liabilityCapDuration;
    }

    @JsonIgnore
    public JsonNullable<Float> priceCapPercentIncrease() {
        return this.priceCapPercentIncrease;
    }

    @JsonIgnore
    public JsonNullable<String> renewalType() {
        return this.renewalType;
    }

    @JsonIgnore
    public JsonNullable<String> renewalNoticePeriod() {
        return this.renewalNoticePeriod;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> renewalNoticeDate() {
        return this.renewalNoticeDate;
    }

    @JsonIgnore
    public JsonNullable<String> autoRenewalTermLength() {
        return this.autoRenewalTermLength;
    }

    @JsonIgnore
    public JsonNullable<String> renewalExtensionPeriod() {
        return this.renewalExtensionPeriod;
    }

    @JsonIgnore
    public JsonNullable<String> renewalProcessOwner() {
        return this.renewalProcessOwner;
    }

    @JsonIgnore
    public JsonNullable<String> renewalAdditionalInfo() {
        return this.renewalAdditionalInfo;
    }

    @JsonIgnore
    public JsonNullable<String> terminationPeriodForCause() {
        return this.terminationPeriodForCause;
    }

    @JsonIgnore
    public JsonNullable<String> terminationPeriodForConvenience() {
        return this.terminationPeriodForConvenience;
    }

    @JsonIgnore
    public JsonNullable<LocalDate> effectiveDate() {
        return this.effectiveDate;
    }

    @JsonIgnore
    public JsonNullable<LocalDate> expirationDate() {
        return this.expirationDate;
    }

    @JsonIgnore
    public JsonNullable<LocalDate> executionDate() {
        return this.executionDate;
    }

    @JsonIgnore
    public JsonNullable<String> termLength() {
        return this.termLength;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Provisions withAssignmentType(String assignmentType) {
        Utils.checkNotNull(assignmentType, "assignmentType");
        this.assignmentType = Optional.ofNullable(assignmentType);
        return this;
    }

    public Provisions withAssignmentType(Optional<String> assignmentType) {
        Utils.checkNotNull(assignmentType, "assignmentType");
        this.assignmentType = assignmentType;
        return this;
    }

    public Provisions withAssignmentChangeOfControl(String assignmentChangeOfControl) {
        Utils.checkNotNull(assignmentChangeOfControl, "assignmentChangeOfControl");
        this.assignmentChangeOfControl = Optional.ofNullable(assignmentChangeOfControl);
        return this;
    }

    public Provisions withAssignmentChangeOfControl(Optional<String> assignmentChangeOfControl) {
        Utils.checkNotNull(assignmentChangeOfControl, "assignmentChangeOfControl");
        this.assignmentChangeOfControl = assignmentChangeOfControl;
        return this;
    }

    public Provisions withAssignmentTerminationRights(String assignmentTerminationRights) {
        Utils.checkNotNull(assignmentTerminationRights, "assignmentTerminationRights");
        this.assignmentTerminationRights = Optional.ofNullable(assignmentTerminationRights);
        return this;
    }

    public Provisions withAssignmentTerminationRights(Optional<String> assignmentTerminationRights) {
        Utils.checkNotNull(assignmentTerminationRights, "assignmentTerminationRights");
        this.assignmentTerminationRights = assignmentTerminationRights;
        return this;
    }

    public Provisions withConfidentialityObligationPeriod(String confidentialityObligationPeriod) {
        Utils.checkNotNull(confidentialityObligationPeriod, "confidentialityObligationPeriod");
        this.confidentialityObligationPeriod = JsonNullable.of((Object)confidentialityObligationPeriod);
        return this;
    }

    public Provisions withConfidentialityObligationPeriod(JsonNullable<String> confidentialityObligationPeriod) {
        Utils.checkNotNull(confidentialityObligationPeriod, "confidentialityObligationPeriod");
        this.confidentialityObligationPeriod = confidentialityObligationPeriod;
        return this;
    }

    public Provisions withGoverningLaw(String governingLaw) {
        Utils.checkNotNull(governingLaw, "governingLaw");
        this.governingLaw = JsonNullable.of((Object)governingLaw);
        return this;
    }

    public Provisions withGoverningLaw(JsonNullable<String> governingLaw) {
        Utils.checkNotNull(governingLaw, "governingLaw");
        this.governingLaw = governingLaw;
        return this;
    }

    public Provisions withJurisdiction(String jurisdiction) {
        Utils.checkNotNull(jurisdiction, "jurisdiction");
        this.jurisdiction = JsonNullable.of((Object)jurisdiction);
        return this;
    }

    public Provisions withJurisdiction(JsonNullable<String> jurisdiction) {
        Utils.checkNotNull(jurisdiction, "jurisdiction");
        this.jurisdiction = jurisdiction;
        return this;
    }

    public Provisions withNdaType(String ndaType) {
        Utils.checkNotNull(ndaType, "ndaType");
        this.ndaType = JsonNullable.of((Object)ndaType);
        return this;
    }

    public Provisions withNdaType(JsonNullable<String> ndaType) {
        Utils.checkNotNull(ndaType, "ndaType");
        this.ndaType = ndaType;
        return this;
    }

    public Provisions withAnnualAgreementValue(double annualAgreementValue) {
        Utils.checkNotNull(annualAgreementValue, "annualAgreementValue");
        this.annualAgreementValue = JsonNullable.of((Object)annualAgreementValue);
        return this;
    }

    public Provisions withAnnualAgreementValue(JsonNullable<Double> annualAgreementValue) {
        Utils.checkNotNull(annualAgreementValue, "annualAgreementValue");
        this.annualAgreementValue = annualAgreementValue;
        return this;
    }

    public Provisions withAnnualAgreementValueCurrencyCode(CurrencyCode annualAgreementValueCurrencyCode) {
        Utils.checkNotNull(annualAgreementValueCurrencyCode, "annualAgreementValueCurrencyCode");
        this.annualAgreementValueCurrencyCode = JsonNullable.of((Object)((Object)annualAgreementValueCurrencyCode));
        return this;
    }

    public Provisions withAnnualAgreementValueCurrencyCode(JsonNullable<? extends CurrencyCode> annualAgreementValueCurrencyCode) {
        Utils.checkNotNull(annualAgreementValueCurrencyCode, "annualAgreementValueCurrencyCode");
        this.annualAgreementValueCurrencyCode = annualAgreementValueCurrencyCode;
        return this;
    }

    public Provisions withTotalAgreementValue(double totalAgreementValue) {
        Utils.checkNotNull(totalAgreementValue, "totalAgreementValue");
        this.totalAgreementValue = JsonNullable.of((Object)totalAgreementValue);
        return this;
    }

    public Provisions withTotalAgreementValue(JsonNullable<Double> totalAgreementValue) {
        Utils.checkNotNull(totalAgreementValue, "totalAgreementValue");
        this.totalAgreementValue = totalAgreementValue;
        return this;
    }

    public Provisions withTotalAgreementValueCurrencyCode(CurrencyCode totalAgreementValueCurrencyCode) {
        Utils.checkNotNull(totalAgreementValueCurrencyCode, "totalAgreementValueCurrencyCode");
        this.totalAgreementValueCurrencyCode = JsonNullable.of((Object)((Object)totalAgreementValueCurrencyCode));
        return this;
    }

    public Provisions withTotalAgreementValueCurrencyCode(JsonNullable<? extends CurrencyCode> totalAgreementValueCurrencyCode) {
        Utils.checkNotNull(totalAgreementValueCurrencyCode, "totalAgreementValueCurrencyCode");
        this.totalAgreementValueCurrencyCode = totalAgreementValueCurrencyCode;
        return this;
    }

    public Provisions withPaymentTermsDueDate(PaymentTermsDueDate paymentTermsDueDate) {
        Utils.checkNotNull(paymentTermsDueDate, "paymentTermsDueDate");
        this.paymentTermsDueDate = Optional.ofNullable(paymentTermsDueDate);
        return this;
    }

    public Provisions withPaymentTermsDueDate(Optional<? extends PaymentTermsDueDate> paymentTermsDueDate) {
        Utils.checkNotNull(paymentTermsDueDate, "paymentTermsDueDate");
        this.paymentTermsDueDate = paymentTermsDueDate;
        return this;
    }

    public Provisions withCanChargeLatePaymentFees(boolean canChargeLatePaymentFees) {
        Utils.checkNotNull(canChargeLatePaymentFees, "canChargeLatePaymentFees");
        this.canChargeLatePaymentFees = JsonNullable.of((Object)canChargeLatePaymentFees);
        return this;
    }

    public Provisions withCanChargeLatePaymentFees(JsonNullable<Boolean> canChargeLatePaymentFees) {
        Utils.checkNotNull(canChargeLatePaymentFees, "canChargeLatePaymentFees");
        this.canChargeLatePaymentFees = canChargeLatePaymentFees;
        return this;
    }

    public Provisions withLatePaymentFeePercent(long latePaymentFeePercent) {
        Utils.checkNotNull(latePaymentFeePercent, "latePaymentFeePercent");
        this.latePaymentFeePercent = JsonNullable.of((Object)latePaymentFeePercent);
        return this;
    }

    public Provisions withLatePaymentFeePercent(JsonNullable<Long> latePaymentFeePercent) {
        Utils.checkNotNull(latePaymentFeePercent, "latePaymentFeePercent");
        this.latePaymentFeePercent = latePaymentFeePercent;
        return this;
    }

    public Provisions withLiabilityCapFixedAmount(double liabilityCapFixedAmount) {
        Utils.checkNotNull(liabilityCapFixedAmount, "liabilityCapFixedAmount");
        this.liabilityCapFixedAmount = JsonNullable.of((Object)liabilityCapFixedAmount);
        return this;
    }

    public Provisions withLiabilityCapFixedAmount(JsonNullable<Double> liabilityCapFixedAmount) {
        Utils.checkNotNull(liabilityCapFixedAmount, "liabilityCapFixedAmount");
        this.liabilityCapFixedAmount = liabilityCapFixedAmount;
        return this;
    }

    public Provisions withLiabilityCapCurrencyCode(CurrencyCode liabilityCapCurrencyCode) {
        Utils.checkNotNull(liabilityCapCurrencyCode, "liabilityCapCurrencyCode");
        this.liabilityCapCurrencyCode = JsonNullable.of((Object)((Object)liabilityCapCurrencyCode));
        return this;
    }

    public Provisions withLiabilityCapCurrencyCode(JsonNullable<? extends CurrencyCode> liabilityCapCurrencyCode) {
        Utils.checkNotNull(liabilityCapCurrencyCode, "liabilityCapCurrencyCode");
        this.liabilityCapCurrencyCode = liabilityCapCurrencyCode;
        return this;
    }

    public Provisions withLiabilityCapMultiplier(double liabilityCapMultiplier) {
        Utils.checkNotNull(liabilityCapMultiplier, "liabilityCapMultiplier");
        this.liabilityCapMultiplier = JsonNullable.of((Object)liabilityCapMultiplier);
        return this;
    }

    public Provisions withLiabilityCapMultiplier(JsonNullable<Double> liabilityCapMultiplier) {
        Utils.checkNotNull(liabilityCapMultiplier, "liabilityCapMultiplier");
        this.liabilityCapMultiplier = liabilityCapMultiplier;
        return this;
    }

    public Provisions withLiabilityCapDuration(String liabilityCapDuration) {
        Utils.checkNotNull(liabilityCapDuration, "liabilityCapDuration");
        this.liabilityCapDuration = JsonNullable.of((Object)liabilityCapDuration);
        return this;
    }

    public Provisions withLiabilityCapDuration(JsonNullable<String> liabilityCapDuration) {
        Utils.checkNotNull(liabilityCapDuration, "liabilityCapDuration");
        this.liabilityCapDuration = liabilityCapDuration;
        return this;
    }

    public Provisions withPriceCapPercentIncrease(float priceCapPercentIncrease) {
        Utils.checkNotNull(Float.valueOf(priceCapPercentIncrease), "priceCapPercentIncrease");
        this.priceCapPercentIncrease = JsonNullable.of((Object)Float.valueOf(priceCapPercentIncrease));
        return this;
    }

    public Provisions withPriceCapPercentIncrease(JsonNullable<Float> priceCapPercentIncrease) {
        Utils.checkNotNull(priceCapPercentIncrease, "priceCapPercentIncrease");
        this.priceCapPercentIncrease = priceCapPercentIncrease;
        return this;
    }

    public Provisions withRenewalType(String renewalType) {
        Utils.checkNotNull(renewalType, "renewalType");
        this.renewalType = JsonNullable.of((Object)renewalType);
        return this;
    }

    public Provisions withRenewalType(JsonNullable<String> renewalType) {
        Utils.checkNotNull(renewalType, "renewalType");
        this.renewalType = renewalType;
        return this;
    }

    public Provisions withRenewalNoticePeriod(String renewalNoticePeriod) {
        Utils.checkNotNull(renewalNoticePeriod, "renewalNoticePeriod");
        this.renewalNoticePeriod = JsonNullable.of((Object)renewalNoticePeriod);
        return this;
    }

    public Provisions withRenewalNoticePeriod(JsonNullable<String> renewalNoticePeriod) {
        Utils.checkNotNull(renewalNoticePeriod, "renewalNoticePeriod");
        this.renewalNoticePeriod = renewalNoticePeriod;
        return this;
    }

    public Provisions withRenewalNoticeDate(OffsetDateTime renewalNoticeDate) {
        Utils.checkNotNull(renewalNoticeDate, "renewalNoticeDate");
        this.renewalNoticeDate = JsonNullable.of((Object)renewalNoticeDate);
        return this;
    }

    public Provisions withRenewalNoticeDate(JsonNullable<OffsetDateTime> renewalNoticeDate) {
        Utils.checkNotNull(renewalNoticeDate, "renewalNoticeDate");
        this.renewalNoticeDate = renewalNoticeDate;
        return this;
    }

    public Provisions withAutoRenewalTermLength(String autoRenewalTermLength) {
        Utils.checkNotNull(autoRenewalTermLength, "autoRenewalTermLength");
        this.autoRenewalTermLength = JsonNullable.of((Object)autoRenewalTermLength);
        return this;
    }

    public Provisions withAutoRenewalTermLength(JsonNullable<String> autoRenewalTermLength) {
        Utils.checkNotNull(autoRenewalTermLength, "autoRenewalTermLength");
        this.autoRenewalTermLength = autoRenewalTermLength;
        return this;
    }

    public Provisions withRenewalExtensionPeriod(String renewalExtensionPeriod) {
        Utils.checkNotNull(renewalExtensionPeriod, "renewalExtensionPeriod");
        this.renewalExtensionPeriod = JsonNullable.of((Object)renewalExtensionPeriod);
        return this;
    }

    public Provisions withRenewalExtensionPeriod(JsonNullable<String> renewalExtensionPeriod) {
        Utils.checkNotNull(renewalExtensionPeriod, "renewalExtensionPeriod");
        this.renewalExtensionPeriod = renewalExtensionPeriod;
        return this;
    }

    public Provisions withRenewalProcessOwner(String renewalProcessOwner) {
        Utils.checkNotNull(renewalProcessOwner, "renewalProcessOwner");
        this.renewalProcessOwner = JsonNullable.of((Object)renewalProcessOwner);
        return this;
    }

    public Provisions withRenewalProcessOwner(JsonNullable<String> renewalProcessOwner) {
        Utils.checkNotNull(renewalProcessOwner, "renewalProcessOwner");
        this.renewalProcessOwner = renewalProcessOwner;
        return this;
    }

    public Provisions withRenewalAdditionalInfo(String renewalAdditionalInfo) {
        Utils.checkNotNull(renewalAdditionalInfo, "renewalAdditionalInfo");
        this.renewalAdditionalInfo = JsonNullable.of((Object)renewalAdditionalInfo);
        return this;
    }

    public Provisions withRenewalAdditionalInfo(JsonNullable<String> renewalAdditionalInfo) {
        Utils.checkNotNull(renewalAdditionalInfo, "renewalAdditionalInfo");
        this.renewalAdditionalInfo = renewalAdditionalInfo;
        return this;
    }

    public Provisions withTerminationPeriodForCause(String terminationPeriodForCause) {
        Utils.checkNotNull(terminationPeriodForCause, "terminationPeriodForCause");
        this.terminationPeriodForCause = JsonNullable.of((Object)terminationPeriodForCause);
        return this;
    }

    public Provisions withTerminationPeriodForCause(JsonNullable<String> terminationPeriodForCause) {
        Utils.checkNotNull(terminationPeriodForCause, "terminationPeriodForCause");
        this.terminationPeriodForCause = terminationPeriodForCause;
        return this;
    }

    public Provisions withTerminationPeriodForConvenience(String terminationPeriodForConvenience) {
        Utils.checkNotNull(terminationPeriodForConvenience, "terminationPeriodForConvenience");
        this.terminationPeriodForConvenience = JsonNullable.of((Object)terminationPeriodForConvenience);
        return this;
    }

    public Provisions withTerminationPeriodForConvenience(JsonNullable<String> terminationPeriodForConvenience) {
        Utils.checkNotNull(terminationPeriodForConvenience, "terminationPeriodForConvenience");
        this.terminationPeriodForConvenience = terminationPeriodForConvenience;
        return this;
    }

    public Provisions withEffectiveDate(LocalDate effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = JsonNullable.of((Object)effectiveDate);
        return this;
    }

    public Provisions withEffectiveDate(JsonNullable<LocalDate> effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = effectiveDate;
        return this;
    }

    public Provisions withExpirationDate(LocalDate expirationDate) {
        Utils.checkNotNull(expirationDate, "expirationDate");
        this.expirationDate = JsonNullable.of((Object)expirationDate);
        return this;
    }

    public Provisions withExpirationDate(JsonNullable<LocalDate> expirationDate) {
        Utils.checkNotNull(expirationDate, "expirationDate");
        this.expirationDate = expirationDate;
        return this;
    }

    public Provisions withExecutionDate(LocalDate executionDate) {
        Utils.checkNotNull(executionDate, "executionDate");
        this.executionDate = JsonNullable.of((Object)executionDate);
        return this;
    }

    public Provisions withExecutionDate(JsonNullable<LocalDate> executionDate) {
        Utils.checkNotNull(executionDate, "executionDate");
        this.executionDate = executionDate;
        return this;
    }

    public Provisions withTermLength(String termLength) {
        Utils.checkNotNull(termLength, "termLength");
        this.termLength = JsonNullable.of((Object)termLength);
        return this;
    }

    public Provisions withTermLength(JsonNullable<String> termLength) {
        Utils.checkNotNull(termLength, "termLength");
        this.termLength = termLength;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Provisions other = (Provisions)o;
        return Objects.deepEquals(this.assignmentType, other.assignmentType) && Objects.deepEquals(this.assignmentChangeOfControl, other.assignmentChangeOfControl) && Objects.deepEquals(this.assignmentTerminationRights, other.assignmentTerminationRights) && Objects.deepEquals(this.confidentialityObligationPeriod, other.confidentialityObligationPeriod) && Objects.deepEquals(this.governingLaw, other.governingLaw) && Objects.deepEquals(this.jurisdiction, other.jurisdiction) && Objects.deepEquals(this.ndaType, other.ndaType) && Objects.deepEquals(this.annualAgreementValue, other.annualAgreementValue) && Objects.deepEquals(this.annualAgreementValueCurrencyCode, other.annualAgreementValueCurrencyCode) && Objects.deepEquals(this.totalAgreementValue, other.totalAgreementValue) && Objects.deepEquals(this.totalAgreementValueCurrencyCode, other.totalAgreementValueCurrencyCode) && Objects.deepEquals(this.paymentTermsDueDate, other.paymentTermsDueDate) && Objects.deepEquals(this.canChargeLatePaymentFees, other.canChargeLatePaymentFees) && Objects.deepEquals(this.latePaymentFeePercent, other.latePaymentFeePercent) && Objects.deepEquals(this.liabilityCapFixedAmount, other.liabilityCapFixedAmount) && Objects.deepEquals(this.liabilityCapCurrencyCode, other.liabilityCapCurrencyCode) && Objects.deepEquals(this.liabilityCapMultiplier, other.liabilityCapMultiplier) && Objects.deepEquals(this.liabilityCapDuration, other.liabilityCapDuration) && Objects.deepEquals(this.priceCapPercentIncrease, other.priceCapPercentIncrease) && Objects.deepEquals(this.renewalType, other.renewalType) && Objects.deepEquals(this.renewalNoticePeriod, other.renewalNoticePeriod) && Objects.deepEquals(this.renewalNoticeDate, other.renewalNoticeDate) && Objects.deepEquals(this.autoRenewalTermLength, other.autoRenewalTermLength) && Objects.deepEquals(this.renewalExtensionPeriod, other.renewalExtensionPeriod) && Objects.deepEquals(this.renewalProcessOwner, other.renewalProcessOwner) && Objects.deepEquals(this.renewalAdditionalInfo, other.renewalAdditionalInfo) && Objects.deepEquals(this.terminationPeriodForCause, other.terminationPeriodForCause) && Objects.deepEquals(this.terminationPeriodForConvenience, other.terminationPeriodForConvenience) && Objects.deepEquals(this.effectiveDate, other.effectiveDate) && Objects.deepEquals(this.expirationDate, other.expirationDate) && Objects.deepEquals(this.executionDate, other.executionDate) && Objects.deepEquals(this.termLength, other.termLength);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentType, this.assignmentChangeOfControl, this.assignmentTerminationRights, this.confidentialityObligationPeriod, this.governingLaw, this.jurisdiction, this.ndaType, this.annualAgreementValue, this.annualAgreementValueCurrencyCode, this.totalAgreementValue, this.totalAgreementValueCurrencyCode, this.paymentTermsDueDate, this.canChargeLatePaymentFees, this.latePaymentFeePercent, this.liabilityCapFixedAmount, this.liabilityCapCurrencyCode, this.liabilityCapMultiplier, this.liabilityCapDuration, this.priceCapPercentIncrease, this.renewalType, this.renewalNoticePeriod, this.renewalNoticeDate, this.autoRenewalTermLength, this.renewalExtensionPeriod, this.renewalProcessOwner, this.renewalAdditionalInfo, this.terminationPeriodForCause, this.terminationPeriodForConvenience, this.effectiveDate, this.expirationDate, this.executionDate, this.termLength);
    }

    public String toString() {
        return Utils.toString(Provisions.class, "assignmentType", this.assignmentType, "assignmentChangeOfControl", this.assignmentChangeOfControl, "assignmentTerminationRights", this.assignmentTerminationRights, "confidentialityObligationPeriod", this.confidentialityObligationPeriod, "governingLaw", this.governingLaw, "jurisdiction", this.jurisdiction, "ndaType", this.ndaType, "annualAgreementValue", this.annualAgreementValue, "annualAgreementValueCurrencyCode", this.annualAgreementValueCurrencyCode, "totalAgreementValue", this.totalAgreementValue, "totalAgreementValueCurrencyCode", this.totalAgreementValueCurrencyCode, "paymentTermsDueDate", this.paymentTermsDueDate, "canChargeLatePaymentFees", this.canChargeLatePaymentFees, "latePaymentFeePercent", this.latePaymentFeePercent, "liabilityCapFixedAmount", this.liabilityCapFixedAmount, "liabilityCapCurrencyCode", this.liabilityCapCurrencyCode, "liabilityCapMultiplier", this.liabilityCapMultiplier, "liabilityCapDuration", this.liabilityCapDuration, "priceCapPercentIncrease", this.priceCapPercentIncrease, "renewalType", this.renewalType, "renewalNoticePeriod", this.renewalNoticePeriod, "renewalNoticeDate", this.renewalNoticeDate, "autoRenewalTermLength", this.autoRenewalTermLength, "renewalExtensionPeriod", this.renewalExtensionPeriod, "renewalProcessOwner", this.renewalProcessOwner, "renewalAdditionalInfo", this.renewalAdditionalInfo, "terminationPeriodForCause", this.terminationPeriodForCause, "terminationPeriodForConvenience", this.terminationPeriodForConvenience, "effectiveDate", this.effectiveDate, "expirationDate", this.expirationDate, "executionDate", this.executionDate, "termLength", this.termLength);
    }

    public static final class Builder {
        private Optional<String> assignmentType = Optional.empty();
        private Optional<String> assignmentChangeOfControl = Optional.empty();
        private Optional<String> assignmentTerminationRights = Optional.empty();
        private JsonNullable<String> confidentialityObligationPeriod = JsonNullable.undefined();
        private JsonNullable<String> governingLaw = JsonNullable.undefined();
        private JsonNullable<String> jurisdiction = JsonNullable.undefined();
        private JsonNullable<String> ndaType = JsonNullable.undefined();
        private JsonNullable<Double> annualAgreementValue = JsonNullable.undefined();
        private JsonNullable<? extends CurrencyCode> annualAgreementValueCurrencyCode = JsonNullable.undefined();
        private JsonNullable<Double> totalAgreementValue = JsonNullable.undefined();
        private JsonNullable<? extends CurrencyCode> totalAgreementValueCurrencyCode = JsonNullable.undefined();
        private Optional<? extends PaymentTermsDueDate> paymentTermsDueDate;
        private JsonNullable<Boolean> canChargeLatePaymentFees = JsonNullable.undefined();
        private JsonNullable<Long> latePaymentFeePercent = JsonNullable.undefined();
        private JsonNullable<Double> liabilityCapFixedAmount = JsonNullable.undefined();
        private JsonNullable<? extends CurrencyCode> liabilityCapCurrencyCode = JsonNullable.undefined();
        private JsonNullable<Double> liabilityCapMultiplier = JsonNullable.undefined();
        private JsonNullable<String> liabilityCapDuration = JsonNullable.undefined();
        private JsonNullable<Float> priceCapPercentIncrease = JsonNullable.undefined();
        private JsonNullable<String> renewalType = JsonNullable.undefined();
        private JsonNullable<String> renewalNoticePeriod = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> renewalNoticeDate = JsonNullable.undefined();
        private JsonNullable<String> autoRenewalTermLength = JsonNullable.undefined();
        private JsonNullable<String> renewalExtensionPeriod = JsonNullable.undefined();
        private JsonNullable<String> renewalProcessOwner = JsonNullable.undefined();
        private JsonNullable<String> renewalAdditionalInfo = JsonNullable.undefined();
        private JsonNullable<String> terminationPeriodForCause = JsonNullable.undefined();
        private JsonNullable<String> terminationPeriodForConvenience = JsonNullable.undefined();
        private JsonNullable<LocalDate> effectiveDate = JsonNullable.undefined();
        private JsonNullable<LocalDate> expirationDate = JsonNullable.undefined();
        private JsonNullable<LocalDate> executionDate = JsonNullable.undefined();
        private JsonNullable<String> termLength = JsonNullable.undefined();
        private static final LazySingletonValue<Optional<? extends PaymentTermsDueDate>> _SINGLETON_VALUE_PaymentTermsDueDate = new LazySingletonValue<Optional<? extends PaymentTermsDueDate>>("payment_terms_due_date", "\"OTHER\"", new TypeReference<Optional<? extends PaymentTermsDueDate>>(){});

        private Builder() {
        }

        public Builder assignmentType(String assignmentType) {
            Utils.checkNotNull(assignmentType, "assignmentType");
            this.assignmentType = Optional.ofNullable(assignmentType);
            return this;
        }

        public Builder assignmentType(Optional<String> assignmentType) {
            Utils.checkNotNull(assignmentType, "assignmentType");
            this.assignmentType = assignmentType;
            return this;
        }

        public Builder assignmentChangeOfControl(String assignmentChangeOfControl) {
            Utils.checkNotNull(assignmentChangeOfControl, "assignmentChangeOfControl");
            this.assignmentChangeOfControl = Optional.ofNullable(assignmentChangeOfControl);
            return this;
        }

        public Builder assignmentChangeOfControl(Optional<String> assignmentChangeOfControl) {
            Utils.checkNotNull(assignmentChangeOfControl, "assignmentChangeOfControl");
            this.assignmentChangeOfControl = assignmentChangeOfControl;
            return this;
        }

        public Builder assignmentTerminationRights(String assignmentTerminationRights) {
            Utils.checkNotNull(assignmentTerminationRights, "assignmentTerminationRights");
            this.assignmentTerminationRights = Optional.ofNullable(assignmentTerminationRights);
            return this;
        }

        public Builder assignmentTerminationRights(Optional<String> assignmentTerminationRights) {
            Utils.checkNotNull(assignmentTerminationRights, "assignmentTerminationRights");
            this.assignmentTerminationRights = assignmentTerminationRights;
            return this;
        }

        public Builder confidentialityObligationPeriod(String confidentialityObligationPeriod) {
            Utils.checkNotNull(confidentialityObligationPeriod, "confidentialityObligationPeriod");
            this.confidentialityObligationPeriod = JsonNullable.of((Object)confidentialityObligationPeriod);
            return this;
        }

        public Builder confidentialityObligationPeriod(JsonNullable<String> confidentialityObligationPeriod) {
            Utils.checkNotNull(confidentialityObligationPeriod, "confidentialityObligationPeriod");
            this.confidentialityObligationPeriod = confidentialityObligationPeriod;
            return this;
        }

        public Builder governingLaw(String governingLaw) {
            Utils.checkNotNull(governingLaw, "governingLaw");
            this.governingLaw = JsonNullable.of((Object)governingLaw);
            return this;
        }

        public Builder governingLaw(JsonNullable<String> governingLaw) {
            Utils.checkNotNull(governingLaw, "governingLaw");
            this.governingLaw = governingLaw;
            return this;
        }

        public Builder jurisdiction(String jurisdiction) {
            Utils.checkNotNull(jurisdiction, "jurisdiction");
            this.jurisdiction = JsonNullable.of((Object)jurisdiction);
            return this;
        }

        public Builder jurisdiction(JsonNullable<String> jurisdiction) {
            Utils.checkNotNull(jurisdiction, "jurisdiction");
            this.jurisdiction = jurisdiction;
            return this;
        }

        public Builder ndaType(String ndaType) {
            Utils.checkNotNull(ndaType, "ndaType");
            this.ndaType = JsonNullable.of((Object)ndaType);
            return this;
        }

        public Builder ndaType(JsonNullable<String> ndaType) {
            Utils.checkNotNull(ndaType, "ndaType");
            this.ndaType = ndaType;
            return this;
        }

        public Builder annualAgreementValue(double annualAgreementValue) {
            Utils.checkNotNull(annualAgreementValue, "annualAgreementValue");
            this.annualAgreementValue = JsonNullable.of((Object)annualAgreementValue);
            return this;
        }

        public Builder annualAgreementValue(JsonNullable<Double> annualAgreementValue) {
            Utils.checkNotNull(annualAgreementValue, "annualAgreementValue");
            this.annualAgreementValue = annualAgreementValue;
            return this;
        }

        public Builder annualAgreementValueCurrencyCode(CurrencyCode annualAgreementValueCurrencyCode) {
            Utils.checkNotNull(annualAgreementValueCurrencyCode, "annualAgreementValueCurrencyCode");
            this.annualAgreementValueCurrencyCode = JsonNullable.of((Object)((Object)annualAgreementValueCurrencyCode));
            return this;
        }

        public Builder annualAgreementValueCurrencyCode(JsonNullable<? extends CurrencyCode> annualAgreementValueCurrencyCode) {
            Utils.checkNotNull(annualAgreementValueCurrencyCode, "annualAgreementValueCurrencyCode");
            this.annualAgreementValueCurrencyCode = annualAgreementValueCurrencyCode;
            return this;
        }

        public Builder totalAgreementValue(double totalAgreementValue) {
            Utils.checkNotNull(totalAgreementValue, "totalAgreementValue");
            this.totalAgreementValue = JsonNullable.of((Object)totalAgreementValue);
            return this;
        }

        public Builder totalAgreementValue(JsonNullable<Double> totalAgreementValue) {
            Utils.checkNotNull(totalAgreementValue, "totalAgreementValue");
            this.totalAgreementValue = totalAgreementValue;
            return this;
        }

        public Builder totalAgreementValueCurrencyCode(CurrencyCode totalAgreementValueCurrencyCode) {
            Utils.checkNotNull(totalAgreementValueCurrencyCode, "totalAgreementValueCurrencyCode");
            this.totalAgreementValueCurrencyCode = JsonNullable.of((Object)((Object)totalAgreementValueCurrencyCode));
            return this;
        }

        public Builder totalAgreementValueCurrencyCode(JsonNullable<? extends CurrencyCode> totalAgreementValueCurrencyCode) {
            Utils.checkNotNull(totalAgreementValueCurrencyCode, "totalAgreementValueCurrencyCode");
            this.totalAgreementValueCurrencyCode = totalAgreementValueCurrencyCode;
            return this;
        }

        public Builder paymentTermsDueDate(PaymentTermsDueDate paymentTermsDueDate) {
            Utils.checkNotNull(paymentTermsDueDate, "paymentTermsDueDate");
            this.paymentTermsDueDate = Optional.ofNullable(paymentTermsDueDate);
            return this;
        }

        public Builder paymentTermsDueDate(Optional<? extends PaymentTermsDueDate> paymentTermsDueDate) {
            Utils.checkNotNull(paymentTermsDueDate, "paymentTermsDueDate");
            this.paymentTermsDueDate = paymentTermsDueDate;
            return this;
        }

        public Builder canChargeLatePaymentFees(boolean canChargeLatePaymentFees) {
            Utils.checkNotNull(canChargeLatePaymentFees, "canChargeLatePaymentFees");
            this.canChargeLatePaymentFees = JsonNullable.of((Object)canChargeLatePaymentFees);
            return this;
        }

        public Builder canChargeLatePaymentFees(JsonNullable<Boolean> canChargeLatePaymentFees) {
            Utils.checkNotNull(canChargeLatePaymentFees, "canChargeLatePaymentFees");
            this.canChargeLatePaymentFees = canChargeLatePaymentFees;
            return this;
        }

        public Builder latePaymentFeePercent(long latePaymentFeePercent) {
            Utils.checkNotNull(latePaymentFeePercent, "latePaymentFeePercent");
            this.latePaymentFeePercent = JsonNullable.of((Object)latePaymentFeePercent);
            return this;
        }

        public Builder latePaymentFeePercent(JsonNullable<Long> latePaymentFeePercent) {
            Utils.checkNotNull(latePaymentFeePercent, "latePaymentFeePercent");
            this.latePaymentFeePercent = latePaymentFeePercent;
            return this;
        }

        public Builder liabilityCapFixedAmount(double liabilityCapFixedAmount) {
            Utils.checkNotNull(liabilityCapFixedAmount, "liabilityCapFixedAmount");
            this.liabilityCapFixedAmount = JsonNullable.of((Object)liabilityCapFixedAmount);
            return this;
        }

        public Builder liabilityCapFixedAmount(JsonNullable<Double> liabilityCapFixedAmount) {
            Utils.checkNotNull(liabilityCapFixedAmount, "liabilityCapFixedAmount");
            this.liabilityCapFixedAmount = liabilityCapFixedAmount;
            return this;
        }

        public Builder liabilityCapCurrencyCode(CurrencyCode liabilityCapCurrencyCode) {
            Utils.checkNotNull(liabilityCapCurrencyCode, "liabilityCapCurrencyCode");
            this.liabilityCapCurrencyCode = JsonNullable.of((Object)((Object)liabilityCapCurrencyCode));
            return this;
        }

        public Builder liabilityCapCurrencyCode(JsonNullable<? extends CurrencyCode> liabilityCapCurrencyCode) {
            Utils.checkNotNull(liabilityCapCurrencyCode, "liabilityCapCurrencyCode");
            this.liabilityCapCurrencyCode = liabilityCapCurrencyCode;
            return this;
        }

        public Builder liabilityCapMultiplier(double liabilityCapMultiplier) {
            Utils.checkNotNull(liabilityCapMultiplier, "liabilityCapMultiplier");
            this.liabilityCapMultiplier = JsonNullable.of((Object)liabilityCapMultiplier);
            return this;
        }

        public Builder liabilityCapMultiplier(JsonNullable<Double> liabilityCapMultiplier) {
            Utils.checkNotNull(liabilityCapMultiplier, "liabilityCapMultiplier");
            this.liabilityCapMultiplier = liabilityCapMultiplier;
            return this;
        }

        public Builder liabilityCapDuration(String liabilityCapDuration) {
            Utils.checkNotNull(liabilityCapDuration, "liabilityCapDuration");
            this.liabilityCapDuration = JsonNullable.of((Object)liabilityCapDuration);
            return this;
        }

        public Builder liabilityCapDuration(JsonNullable<String> liabilityCapDuration) {
            Utils.checkNotNull(liabilityCapDuration, "liabilityCapDuration");
            this.liabilityCapDuration = liabilityCapDuration;
            return this;
        }

        public Builder priceCapPercentIncrease(float priceCapPercentIncrease) {
            Utils.checkNotNull(Float.valueOf(priceCapPercentIncrease), "priceCapPercentIncrease");
            this.priceCapPercentIncrease = JsonNullable.of((Object)Float.valueOf(priceCapPercentIncrease));
            return this;
        }

        public Builder priceCapPercentIncrease(JsonNullable<Float> priceCapPercentIncrease) {
            Utils.checkNotNull(priceCapPercentIncrease, "priceCapPercentIncrease");
            this.priceCapPercentIncrease = priceCapPercentIncrease;
            return this;
        }

        public Builder renewalType(String renewalType) {
            Utils.checkNotNull(renewalType, "renewalType");
            this.renewalType = JsonNullable.of((Object)renewalType);
            return this;
        }

        public Builder renewalType(JsonNullable<String> renewalType) {
            Utils.checkNotNull(renewalType, "renewalType");
            this.renewalType = renewalType;
            return this;
        }

        public Builder renewalNoticePeriod(String renewalNoticePeriod) {
            Utils.checkNotNull(renewalNoticePeriod, "renewalNoticePeriod");
            this.renewalNoticePeriod = JsonNullable.of((Object)renewalNoticePeriod);
            return this;
        }

        public Builder renewalNoticePeriod(JsonNullable<String> renewalNoticePeriod) {
            Utils.checkNotNull(renewalNoticePeriod, "renewalNoticePeriod");
            this.renewalNoticePeriod = renewalNoticePeriod;
            return this;
        }

        public Builder renewalNoticeDate(OffsetDateTime renewalNoticeDate) {
            Utils.checkNotNull(renewalNoticeDate, "renewalNoticeDate");
            this.renewalNoticeDate = JsonNullable.of((Object)renewalNoticeDate);
            return this;
        }

        public Builder renewalNoticeDate(JsonNullable<OffsetDateTime> renewalNoticeDate) {
            Utils.checkNotNull(renewalNoticeDate, "renewalNoticeDate");
            this.renewalNoticeDate = renewalNoticeDate;
            return this;
        }

        public Builder autoRenewalTermLength(String autoRenewalTermLength) {
            Utils.checkNotNull(autoRenewalTermLength, "autoRenewalTermLength");
            this.autoRenewalTermLength = JsonNullable.of((Object)autoRenewalTermLength);
            return this;
        }

        public Builder autoRenewalTermLength(JsonNullable<String> autoRenewalTermLength) {
            Utils.checkNotNull(autoRenewalTermLength, "autoRenewalTermLength");
            this.autoRenewalTermLength = autoRenewalTermLength;
            return this;
        }

        public Builder renewalExtensionPeriod(String renewalExtensionPeriod) {
            Utils.checkNotNull(renewalExtensionPeriod, "renewalExtensionPeriod");
            this.renewalExtensionPeriod = JsonNullable.of((Object)renewalExtensionPeriod);
            return this;
        }

        public Builder renewalExtensionPeriod(JsonNullable<String> renewalExtensionPeriod) {
            Utils.checkNotNull(renewalExtensionPeriod, "renewalExtensionPeriod");
            this.renewalExtensionPeriod = renewalExtensionPeriod;
            return this;
        }

        public Builder renewalProcessOwner(String renewalProcessOwner) {
            Utils.checkNotNull(renewalProcessOwner, "renewalProcessOwner");
            this.renewalProcessOwner = JsonNullable.of((Object)renewalProcessOwner);
            return this;
        }

        public Builder renewalProcessOwner(JsonNullable<String> renewalProcessOwner) {
            Utils.checkNotNull(renewalProcessOwner, "renewalProcessOwner");
            this.renewalProcessOwner = renewalProcessOwner;
            return this;
        }

        public Builder renewalAdditionalInfo(String renewalAdditionalInfo) {
            Utils.checkNotNull(renewalAdditionalInfo, "renewalAdditionalInfo");
            this.renewalAdditionalInfo = JsonNullable.of((Object)renewalAdditionalInfo);
            return this;
        }

        public Builder renewalAdditionalInfo(JsonNullable<String> renewalAdditionalInfo) {
            Utils.checkNotNull(renewalAdditionalInfo, "renewalAdditionalInfo");
            this.renewalAdditionalInfo = renewalAdditionalInfo;
            return this;
        }

        public Builder terminationPeriodForCause(String terminationPeriodForCause) {
            Utils.checkNotNull(terminationPeriodForCause, "terminationPeriodForCause");
            this.terminationPeriodForCause = JsonNullable.of((Object)terminationPeriodForCause);
            return this;
        }

        public Builder terminationPeriodForCause(JsonNullable<String> terminationPeriodForCause) {
            Utils.checkNotNull(terminationPeriodForCause, "terminationPeriodForCause");
            this.terminationPeriodForCause = terminationPeriodForCause;
            return this;
        }

        public Builder terminationPeriodForConvenience(String terminationPeriodForConvenience) {
            Utils.checkNotNull(terminationPeriodForConvenience, "terminationPeriodForConvenience");
            this.terminationPeriodForConvenience = JsonNullable.of((Object)terminationPeriodForConvenience);
            return this;
        }

        public Builder terminationPeriodForConvenience(JsonNullable<String> terminationPeriodForConvenience) {
            Utils.checkNotNull(terminationPeriodForConvenience, "terminationPeriodForConvenience");
            this.terminationPeriodForConvenience = terminationPeriodForConvenience;
            return this;
        }

        public Builder effectiveDate(LocalDate effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = JsonNullable.of((Object)effectiveDate);
            return this;
        }

        public Builder effectiveDate(JsonNullable<LocalDate> effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder expirationDate(LocalDate expirationDate) {
            Utils.checkNotNull(expirationDate, "expirationDate");
            this.expirationDate = JsonNullable.of((Object)expirationDate);
            return this;
        }

        public Builder expirationDate(JsonNullable<LocalDate> expirationDate) {
            Utils.checkNotNull(expirationDate, "expirationDate");
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder executionDate(LocalDate executionDate) {
            Utils.checkNotNull(executionDate, "executionDate");
            this.executionDate = JsonNullable.of((Object)executionDate);
            return this;
        }

        public Builder executionDate(JsonNullable<LocalDate> executionDate) {
            Utils.checkNotNull(executionDate, "executionDate");
            this.executionDate = executionDate;
            return this;
        }

        public Builder termLength(String termLength) {
            Utils.checkNotNull(termLength, "termLength");
            this.termLength = JsonNullable.of((Object)termLength);
            return this;
        }

        public Builder termLength(JsonNullable<String> termLength) {
            Utils.checkNotNull(termLength, "termLength");
            this.termLength = termLength;
            return this;
        }

        public Provisions build() {
            if (this.paymentTermsDueDate == null) {
                this.paymentTermsDueDate = _SINGLETON_VALUE_PaymentTermsDueDate.value();
            }
            return new Provisions(this.assignmentType, this.assignmentChangeOfControl, this.assignmentTerminationRights, this.confidentialityObligationPeriod, this.governingLaw, this.jurisdiction, this.ndaType, this.annualAgreementValue, this.annualAgreementValueCurrencyCode, this.totalAgreementValue, this.totalAgreementValueCurrencyCode, this.paymentTermsDueDate, this.canChargeLatePaymentFees, this.latePaymentFeePercent, this.liabilityCapFixedAmount, this.liabilityCapCurrencyCode, this.liabilityCapMultiplier, this.liabilityCapDuration, this.priceCapPercentIncrease, this.renewalType, this.renewalNoticePeriod, this.renewalNoticeDate, this.autoRenewalTermLength, this.renewalExtensionPeriod, this.renewalProcessOwner, this.renewalAdditionalInfo, this.terminationPeriodForCause, this.terminationPeriodForConvenience, this.effectiveDate, this.expirationDate, this.executionDate, this.termLength);
        }
    }
}

