/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.TabExtensionData;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Tab {
    @JsonProperty(value="extensionData")
    private TabExtensionData extensionData;
    @JsonProperty(value="tabType")
    private String tabType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="validationPattern")
    private Optional<String> validationPattern;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="validationMessage")
    private Optional<String> validationMessage;
    @JsonProperty(value="tabLabel")
    private String tabLabel;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="radios")
    private Optional<? extends List<String>> radios;

    @JsonCreator
    public Tab(@JsonProperty(value="extensionData") TabExtensionData extensionData, @JsonProperty(value="tabType") String tabType, @JsonProperty(value="validationPattern") Optional<String> validationPattern, @JsonProperty(value="validationMessage") Optional<String> validationMessage, @JsonProperty(value="tabLabel") String tabLabel, @JsonProperty(value="radios") Optional<? extends List<String>> radios) {
        Utils.checkNotNull(extensionData, "extensionData");
        Utils.checkNotNull(tabType, "tabType");
        Utils.checkNotNull(validationPattern, "validationPattern");
        Utils.checkNotNull(validationMessage, "validationMessage");
        Utils.checkNotNull(tabLabel, "tabLabel");
        Utils.checkNotNull(radios, "radios");
        this.extensionData = extensionData;
        this.tabType = tabType;
        this.validationPattern = validationPattern;
        this.validationMessage = validationMessage;
        this.tabLabel = tabLabel;
        this.radios = radios;
    }

    public Tab(TabExtensionData extensionData, String tabType, String tabLabel) {
        this(extensionData, tabType, Optional.empty(), Optional.empty(), tabLabel, Optional.empty());
    }

    @JsonIgnore
    public TabExtensionData extensionData() {
        return this.extensionData;
    }

    @JsonIgnore
    public String tabType() {
        return this.tabType;
    }

    @JsonIgnore
    public Optional<String> validationPattern() {
        return this.validationPattern;
    }

    @JsonIgnore
    public Optional<String> validationMessage() {
        return this.validationMessage;
    }

    @JsonIgnore
    public String tabLabel() {
        return this.tabLabel;
    }

    @JsonIgnore
    public Optional<List<String>> radios() {
        return this.radios;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Tab withExtensionData(TabExtensionData extensionData) {
        Utils.checkNotNull(extensionData, "extensionData");
        this.extensionData = extensionData;
        return this;
    }

    public Tab withTabType(String tabType) {
        Utils.checkNotNull(tabType, "tabType");
        this.tabType = tabType;
        return this;
    }

    public Tab withValidationPattern(String validationPattern) {
        Utils.checkNotNull(validationPattern, "validationPattern");
        this.validationPattern = Optional.ofNullable(validationPattern);
        return this;
    }

    public Tab withValidationPattern(Optional<String> validationPattern) {
        Utils.checkNotNull(validationPattern, "validationPattern");
        this.validationPattern = validationPattern;
        return this;
    }

    public Tab withValidationMessage(String validationMessage) {
        Utils.checkNotNull(validationMessage, "validationMessage");
        this.validationMessage = Optional.ofNullable(validationMessage);
        return this;
    }

    public Tab withValidationMessage(Optional<String> validationMessage) {
        Utils.checkNotNull(validationMessage, "validationMessage");
        this.validationMessage = validationMessage;
        return this;
    }

    public Tab withTabLabel(String tabLabel) {
        Utils.checkNotNull(tabLabel, "tabLabel");
        this.tabLabel = tabLabel;
        return this;
    }

    public Tab withRadios(List<String> radios) {
        Utils.checkNotNull(radios, "radios");
        this.radios = Optional.ofNullable(radios);
        return this;
    }

    public Tab withRadios(Optional<? extends List<String>> radios) {
        Utils.checkNotNull(radios, "radios");
        this.radios = radios;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tab other = (Tab)o;
        return Objects.deepEquals(this.extensionData, other.extensionData) && Objects.deepEquals(this.tabType, other.tabType) && Objects.deepEquals(this.validationPattern, other.validationPattern) && Objects.deepEquals(this.validationMessage, other.validationMessage) && Objects.deepEquals(this.tabLabel, other.tabLabel) && Objects.deepEquals(this.radios, other.radios);
    }

    public int hashCode() {
        return Objects.hash(this.extensionData, this.tabType, this.validationPattern, this.validationMessage, this.tabLabel, this.radios);
    }

    public String toString() {
        return Utils.toString(Tab.class, "extensionData", this.extensionData, "tabType", this.tabType, "validationPattern", this.validationPattern, "validationMessage", this.validationMessage, "tabLabel", this.tabLabel, "radios", this.radios);
    }

    public static final class Builder {
        private TabExtensionData extensionData;
        private String tabType;
        private Optional<String> validationPattern = Optional.empty();
        private Optional<String> validationMessage = Optional.empty();
        private String tabLabel;
        private Optional<? extends List<String>> radios = Optional.empty();

        private Builder() {
        }

        public Builder extensionData(TabExtensionData extensionData) {
            Utils.checkNotNull(extensionData, "extensionData");
            this.extensionData = extensionData;
            return this;
        }

        public Builder tabType(String tabType) {
            Utils.checkNotNull(tabType, "tabType");
            this.tabType = tabType;
            return this;
        }

        public Builder validationPattern(String validationPattern) {
            Utils.checkNotNull(validationPattern, "validationPattern");
            this.validationPattern = Optional.ofNullable(validationPattern);
            return this;
        }

        public Builder validationPattern(Optional<String> validationPattern) {
            Utils.checkNotNull(validationPattern, "validationPattern");
            this.validationPattern = validationPattern;
            return this;
        }

        public Builder validationMessage(String validationMessage) {
            Utils.checkNotNull(validationMessage, "validationMessage");
            this.validationMessage = Optional.ofNullable(validationMessage);
            return this;
        }

        public Builder validationMessage(Optional<String> validationMessage) {
            Utils.checkNotNull(validationMessage, "validationMessage");
            this.validationMessage = validationMessage;
            return this;
        }

        public Builder tabLabel(String tabLabel) {
            Utils.checkNotNull(tabLabel, "tabLabel");
            this.tabLabel = tabLabel;
            return this;
        }

        public Builder radios(List<String> radios) {
            Utils.checkNotNull(radios, "radios");
            this.radios = Optional.ofNullable(radios);
            return this;
        }

        public Builder radios(Optional<? extends List<String>> radios) {
            Utils.checkNotNull(radios, "radios");
            this.radios = radios;
            return this;
        }

        public Tab build() {
            return new Tab(this.extensionData, this.tabType, this.validationPattern, this.validationMessage, this.tabLabel, this.radios);
        }
    }
}

