/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Method;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class TriggerHttpConfig {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="method")
    private Optional<? extends Method> method;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private Optional<String> url;

    @JsonCreator
    public TriggerHttpConfig(@JsonProperty(value="method") Optional<? extends Method> method, @JsonProperty(value="url") Optional<String> url) {
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(url, "url");
        this.method = method;
        this.url = url;
    }

    public TriggerHttpConfig() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Method> method() {
        return this.method;
    }

    @JsonIgnore
    public Optional<String> url() {
        return this.url;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerHttpConfig withMethod(Method method) {
        Utils.checkNotNull(method, "method");
        this.method = Optional.ofNullable(method);
        return this;
    }

    public TriggerHttpConfig withMethod(Optional<? extends Method> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public TriggerHttpConfig withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = Optional.ofNullable(url);
        return this;
    }

    public TriggerHttpConfig withUrl(Optional<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerHttpConfig other = (TriggerHttpConfig)o;
        return Objects.deepEquals(this.method, other.method) && Objects.deepEquals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.url);
    }

    public String toString() {
        return Utils.toString(TriggerHttpConfig.class, "method", this.method, "url", this.url);
    }

    public static final class Builder {
        private Optional<? extends Method> method = Optional.empty();
        private Optional<String> url = Optional.empty();

        private Builder() {
        }

        public Builder method(Method method) {
            Utils.checkNotNull(method, "method");
            this.method = Optional.ofNullable(method);
            return this;
        }

        public Builder method(Optional<? extends Method> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = Optional.ofNullable(url);
            return this;
        }

        public Builder url(Optional<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public TriggerHttpConfig build() {
            return new TriggerHttpConfig(this.method, this.url);
        }
    }
}

