/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.DefaultValue;
import com.docusign.iam.sdk.models.components.FieldDataType;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class TriggerInputSchema {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="field_name")
    private Optional<String> fieldName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="field_data_type")
    private Optional<? extends FieldDataType> fieldDataType;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="default_value")
    private Optional<? extends DefaultValue> defaultValue;

    @JsonCreator
    public TriggerInputSchema(@JsonProperty(value="field_name") Optional<String> fieldName, @JsonProperty(value="field_data_type") Optional<? extends FieldDataType> fieldDataType, @JsonProperty(value="default_value") Optional<? extends DefaultValue> defaultValue) {
        Utils.checkNotNull(fieldName, "fieldName");
        Utils.checkNotNull(fieldDataType, "fieldDataType");
        Utils.checkNotNull(defaultValue, "defaultValue");
        this.fieldName = fieldName;
        this.fieldDataType = fieldDataType;
        this.defaultValue = defaultValue;
    }

    public TriggerInputSchema() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> fieldName() {
        return this.fieldName;
    }

    @JsonIgnore
    public Optional<FieldDataType> fieldDataType() {
        return this.fieldDataType;
    }

    @JsonIgnore
    public Optional<DefaultValue> defaultValue() {
        return this.defaultValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerInputSchema withFieldName(String fieldName) {
        Utils.checkNotNull(fieldName, "fieldName");
        this.fieldName = Optional.ofNullable(fieldName);
        return this;
    }

    public TriggerInputSchema withFieldName(Optional<String> fieldName) {
        Utils.checkNotNull(fieldName, "fieldName");
        this.fieldName = fieldName;
        return this;
    }

    public TriggerInputSchema withFieldDataType(FieldDataType fieldDataType) {
        Utils.checkNotNull(fieldDataType, "fieldDataType");
        this.fieldDataType = Optional.ofNullable(fieldDataType);
        return this;
    }

    public TriggerInputSchema withFieldDataType(Optional<? extends FieldDataType> fieldDataType) {
        Utils.checkNotNull(fieldDataType, "fieldDataType");
        this.fieldDataType = fieldDataType;
        return this;
    }

    public TriggerInputSchema withDefaultValue(DefaultValue defaultValue) {
        Utils.checkNotNull(defaultValue, "defaultValue");
        this.defaultValue = Optional.ofNullable(defaultValue);
        return this;
    }

    public TriggerInputSchema withDefaultValue(Optional<? extends DefaultValue> defaultValue) {
        Utils.checkNotNull(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerInputSchema other = (TriggerInputSchema)o;
        return Objects.deepEquals(this.fieldName, other.fieldName) && Objects.deepEquals(this.fieldDataType, other.fieldDataType) && Objects.deepEquals(this.defaultValue, other.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.fieldDataType, this.defaultValue);
    }

    public String toString() {
        return Utils.toString(TriggerInputSchema.class, "fieldName", this.fieldName, "fieldDataType", this.fieldDataType, "defaultValue", this.defaultValue);
    }

    public static final class Builder {
        private Optional<String> fieldName = Optional.empty();
        private Optional<? extends FieldDataType> fieldDataType = Optional.empty();
        private Optional<? extends DefaultValue> defaultValue = Optional.empty();

        private Builder() {
        }

        public Builder fieldName(String fieldName) {
            Utils.checkNotNull(fieldName, "fieldName");
            this.fieldName = Optional.ofNullable(fieldName);
            return this;
        }

        public Builder fieldName(Optional<String> fieldName) {
            Utils.checkNotNull(fieldName, "fieldName");
            this.fieldName = fieldName;
            return this;
        }

        public Builder fieldDataType(FieldDataType fieldDataType) {
            Utils.checkNotNull(fieldDataType, "fieldDataType");
            this.fieldDataType = Optional.ofNullable(fieldDataType);
            return this;
        }

        public Builder fieldDataType(Optional<? extends FieldDataType> fieldDataType) {
            Utils.checkNotNull(fieldDataType, "fieldDataType");
            this.fieldDataType = fieldDataType;
            return this;
        }

        public Builder defaultValue(DefaultValue defaultValue) {
            Utils.checkNotNull(defaultValue, "defaultValue");
            this.defaultValue = Optional.ofNullable(defaultValue);
            return this;
        }

        public Builder defaultValue(Optional<? extends DefaultValue> defaultValue) {
            Utils.checkNotNull(defaultValue, "defaultValue");
            this.defaultValue = defaultValue;
            return this;
        }

        public TriggerInputSchema build() {
            return new TriggerInputSchema(this.fieldName, this.fieldDataType, this.defaultValue);
        }
    }
}

