/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class TriggerWorkflowSuccess {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="instance_id")
    private JsonNullable<String> instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="instance_url")
    private Optional<String> instanceUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="page_limit")
    private JsonNullable<Integer> pageLimit;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="page_token_next")
    private JsonNullable<String> pageTokenNext;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="request_id")
    private Optional<String> requestId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="response_timestamp")
    private Optional<OffsetDateTime> responseTimestamp;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="response_duration_ms")
    private Optional<Integer> responseDurationMs;

    @JsonCreator
    public TriggerWorkflowSuccess(@JsonProperty(value="instance_id") JsonNullable<String> instanceId, @JsonProperty(value="instance_url") Optional<String> instanceUrl, @JsonProperty(value="page_limit") JsonNullable<Integer> pageLimit, @JsonProperty(value="page_token_next") JsonNullable<String> pageTokenNext, @JsonProperty(value="request_id") Optional<String> requestId, @JsonProperty(value="response_timestamp") Optional<OffsetDateTime> responseTimestamp, @JsonProperty(value="response_duration_ms") Optional<Integer> responseDurationMs) {
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(instanceUrl, "instanceUrl");
        Utils.checkNotNull(pageLimit, "pageLimit");
        Utils.checkNotNull(pageTokenNext, "pageTokenNext");
        Utils.checkNotNull(requestId, "requestId");
        Utils.checkNotNull(responseTimestamp, "responseTimestamp");
        Utils.checkNotNull(responseDurationMs, "responseDurationMs");
        this.instanceId = instanceId;
        this.instanceUrl = instanceUrl;
        this.pageLimit = pageLimit;
        this.pageTokenNext = pageTokenNext;
        this.requestId = requestId;
        this.responseTimestamp = responseTimestamp;
        this.responseDurationMs = responseDurationMs;
    }

    public TriggerWorkflowSuccess() {
        this((JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<Integer>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<String> instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public Optional<String> instanceUrl() {
        return this.instanceUrl;
    }

    @JsonIgnore
    public JsonNullable<Integer> pageLimit() {
        return this.pageLimit;
    }

    @JsonIgnore
    public JsonNullable<String> pageTokenNext() {
        return this.pageTokenNext;
    }

    @JsonIgnore
    public Optional<String> requestId() {
        return this.requestId;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> responseTimestamp() {
        return this.responseTimestamp;
    }

    @JsonIgnore
    public Optional<Integer> responseDurationMs() {
        return this.responseDurationMs;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerWorkflowSuccess withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = JsonNullable.of((Object)instanceId);
        return this;
    }

    public TriggerWorkflowSuccess withInstanceId(JsonNullable<String> instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public TriggerWorkflowSuccess withInstanceUrl(String instanceUrl) {
        Utils.checkNotNull(instanceUrl, "instanceUrl");
        this.instanceUrl = Optional.ofNullable(instanceUrl);
        return this;
    }

    public TriggerWorkflowSuccess withInstanceUrl(Optional<String> instanceUrl) {
        Utils.checkNotNull(instanceUrl, "instanceUrl");
        this.instanceUrl = instanceUrl;
        return this;
    }

    public TriggerWorkflowSuccess withPageLimit(int pageLimit) {
        Utils.checkNotNull(pageLimit, "pageLimit");
        this.pageLimit = JsonNullable.of((Object)pageLimit);
        return this;
    }

    public TriggerWorkflowSuccess withPageLimit(JsonNullable<Integer> pageLimit) {
        Utils.checkNotNull(pageLimit, "pageLimit");
        this.pageLimit = pageLimit;
        return this;
    }

    public TriggerWorkflowSuccess withPageTokenNext(String pageTokenNext) {
        Utils.checkNotNull(pageTokenNext, "pageTokenNext");
        this.pageTokenNext = JsonNullable.of((Object)pageTokenNext);
        return this;
    }

    public TriggerWorkflowSuccess withPageTokenNext(JsonNullable<String> pageTokenNext) {
        Utils.checkNotNull(pageTokenNext, "pageTokenNext");
        this.pageTokenNext = pageTokenNext;
        return this;
    }

    public TriggerWorkflowSuccess withRequestId(String requestId) {
        Utils.checkNotNull(requestId, "requestId");
        this.requestId = Optional.ofNullable(requestId);
        return this;
    }

    public TriggerWorkflowSuccess withRequestId(Optional<String> requestId) {
        Utils.checkNotNull(requestId, "requestId");
        this.requestId = requestId;
        return this;
    }

    public TriggerWorkflowSuccess withResponseTimestamp(OffsetDateTime responseTimestamp) {
        Utils.checkNotNull(responseTimestamp, "responseTimestamp");
        this.responseTimestamp = Optional.ofNullable(responseTimestamp);
        return this;
    }

    public TriggerWorkflowSuccess withResponseTimestamp(Optional<OffsetDateTime> responseTimestamp) {
        Utils.checkNotNull(responseTimestamp, "responseTimestamp");
        this.responseTimestamp = responseTimestamp;
        return this;
    }

    public TriggerWorkflowSuccess withResponseDurationMs(int responseDurationMs) {
        Utils.checkNotNull(responseDurationMs, "responseDurationMs");
        this.responseDurationMs = Optional.ofNullable(responseDurationMs);
        return this;
    }

    public TriggerWorkflowSuccess withResponseDurationMs(Optional<Integer> responseDurationMs) {
        Utils.checkNotNull(responseDurationMs, "responseDurationMs");
        this.responseDurationMs = responseDurationMs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerWorkflowSuccess other = (TriggerWorkflowSuccess)o;
        return Objects.deepEquals(this.instanceId, other.instanceId) && Objects.deepEquals(this.instanceUrl, other.instanceUrl) && Objects.deepEquals(this.pageLimit, other.pageLimit) && Objects.deepEquals(this.pageTokenNext, other.pageTokenNext) && Objects.deepEquals(this.requestId, other.requestId) && Objects.deepEquals(this.responseTimestamp, other.responseTimestamp) && Objects.deepEquals(this.responseDurationMs, other.responseDurationMs);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.instanceUrl, this.pageLimit, this.pageTokenNext, this.requestId, this.responseTimestamp, this.responseDurationMs);
    }

    public String toString() {
        return Utils.toString(TriggerWorkflowSuccess.class, "instanceId", this.instanceId, "instanceUrl", this.instanceUrl, "pageLimit", this.pageLimit, "pageTokenNext", this.pageTokenNext, "requestId", this.requestId, "responseTimestamp", this.responseTimestamp, "responseDurationMs", this.responseDurationMs);
    }

    public static final class Builder {
        private JsonNullable<String> instanceId;
        private Optional<String> instanceUrl = Optional.empty();
        private JsonNullable<Integer> pageLimit = JsonNullable.undefined();
        private JsonNullable<String> pageTokenNext = JsonNullable.undefined();
        private Optional<String> requestId = Optional.empty();
        private Optional<OffsetDateTime> responseTimestamp = Optional.empty();
        private Optional<Integer> responseDurationMs = Optional.empty();
        private static final LazySingletonValue<JsonNullable<String>> _SINGLETON_VALUE_InstanceId = new LazySingletonValue<JsonNullable<String>>("instance_id", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<JsonNullable<String>>(){});

        private Builder() {
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = JsonNullable.of((Object)instanceId);
            return this;
        }

        public Builder instanceId(JsonNullable<String> instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder instanceUrl(String instanceUrl) {
            Utils.checkNotNull(instanceUrl, "instanceUrl");
            this.instanceUrl = Optional.ofNullable(instanceUrl);
            return this;
        }

        public Builder instanceUrl(Optional<String> instanceUrl) {
            Utils.checkNotNull(instanceUrl, "instanceUrl");
            this.instanceUrl = instanceUrl;
            return this;
        }

        public Builder pageLimit(int pageLimit) {
            Utils.checkNotNull(pageLimit, "pageLimit");
            this.pageLimit = JsonNullable.of((Object)pageLimit);
            return this;
        }

        public Builder pageLimit(JsonNullable<Integer> pageLimit) {
            Utils.checkNotNull(pageLimit, "pageLimit");
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder pageTokenNext(String pageTokenNext) {
            Utils.checkNotNull(pageTokenNext, "pageTokenNext");
            this.pageTokenNext = JsonNullable.of((Object)pageTokenNext);
            return this;
        }

        public Builder pageTokenNext(JsonNullable<String> pageTokenNext) {
            Utils.checkNotNull(pageTokenNext, "pageTokenNext");
            this.pageTokenNext = pageTokenNext;
            return this;
        }

        public Builder requestId(String requestId) {
            Utils.checkNotNull(requestId, "requestId");
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        public Builder requestId(Optional<String> requestId) {
            Utils.checkNotNull(requestId, "requestId");
            this.requestId = requestId;
            return this;
        }

        public Builder responseTimestamp(OffsetDateTime responseTimestamp) {
            Utils.checkNotNull(responseTimestamp, "responseTimestamp");
            this.responseTimestamp = Optional.ofNullable(responseTimestamp);
            return this;
        }

        public Builder responseTimestamp(Optional<OffsetDateTime> responseTimestamp) {
            Utils.checkNotNull(responseTimestamp, "responseTimestamp");
            this.responseTimestamp = responseTimestamp;
            return this;
        }

        public Builder responseDurationMs(int responseDurationMs) {
            Utils.checkNotNull(responseDurationMs, "responseDurationMs");
            this.responseDurationMs = Optional.ofNullable(responseDurationMs);
            return this;
        }

        public Builder responseDurationMs(Optional<Integer> responseDurationMs) {
            Utils.checkNotNull(responseDurationMs, "responseDurationMs");
            this.responseDurationMs = responseDurationMs;
            return this;
        }

        public TriggerWorkflowSuccess build() {
            if (this.instanceId == null) {
                this.instanceId = _SINGLETON_VALUE_InstanceId.value();
            }
            return new TriggerWorkflowSuccess(this.instanceId, this.instanceUrl, this.pageLimit, this.pageTokenNext, this.requestId, this.responseTimestamp, this.responseDurationMs);
        }
    }
}

