/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.ResourceMetadata;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Workflow {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="account_id")
    private JsonNullable<String> accountId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="status")
    private Optional<String> status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="metadata")
    private Optional<? extends ResourceMetadata> metadata;

    @JsonCreator
    public Workflow(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="account_id") JsonNullable<String> accountId, @JsonProperty(value="status") Optional<String> status, @JsonProperty(value="metadata") Optional<? extends ResourceMetadata> metadata) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(metadata, "metadata");
        this.id = id;
        this.name = name;
        this.accountId = accountId;
        this.status = status;
        this.metadata = metadata;
    }

    public Workflow() {
        this((JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<String> accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public Optional<String> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<ResourceMetadata> metadata() {
        return this.metadata;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Workflow withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Workflow withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Workflow withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public Workflow withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Workflow withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of((Object)accountId);
        return this;
    }

    public Workflow withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public Workflow withStatus(String status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public Workflow withStatus(Optional<String> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Workflow withMetadata(ResourceMetadata metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }

    public Workflow withMetadata(Optional<? extends ResourceMetadata> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow other = (Workflow)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.metadata, other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.accountId, this.status, this.metadata);
    }

    public String toString() {
        return Utils.toString(Workflow.class, "id", this.id, "name", this.name, "accountId", this.accountId, "status", this.status, "metadata", this.metadata);
    }

    public static final class Builder {
        private JsonNullable<String> id;
        private Optional<String> name = Optional.empty();
        private JsonNullable<String> accountId;
        private Optional<String> status = Optional.empty();
        private Optional<? extends ResourceMetadata> metadata = Optional.empty();
        private static final LazySingletonValue<JsonNullable<String>> _SINGLETON_VALUE_Id = new LazySingletonValue<JsonNullable<String>>("id", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<JsonNullable<String>>(){});
        private static final LazySingletonValue<JsonNullable<String>> _SINGLETON_VALUE_AccountId = new LazySingletonValue<JsonNullable<String>>("account_id", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<JsonNullable<String>>(){});

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of((Object)accountId);
            return this;
        }

        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder status(String status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<String> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder metadata(ResourceMetadata metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Optional<? extends ResourceMetadata> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        public Workflow build() {
            if (this.id == null) {
                this.id = _SINGLETON_VALUE_Id.value();
            }
            if (this.accountId == null) {
                this.accountId = _SINGLETON_VALUE_AccountId.value();
            }
            return new Workflow(this.id, this.name, this.accountId, this.status, this.metadata);
        }
    }
}

