/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Metadata;
import com.docusign.iam.sdk.models.components.TriggerInputs;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class WorkflowInstance {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="workflow_status")
    private Optional<String> workflowStatus;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="template_id")
    private Optional<String> templateId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="account_id")
    private Optional<String> accountId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="started_at")
    private Optional<OffsetDateTime> startedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="started_by")
    private Optional<String> startedBy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="started_by_name")
    private Optional<String> startedByName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="started_by_role")
    private Optional<String> startedByRole;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="ended_at")
    private JsonNullable<OffsetDateTime> endedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_at")
    private JsonNullable<OffsetDateTime> expiresAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_modified_at")
    private Optional<OffsetDateTime> lastModifiedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="canceled_at")
    private JsonNullable<OffsetDateTime> canceledAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="canceled_by")
    private JsonNullable<String> canceledBy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="trigger_inputs")
    private Optional<? extends Map<String, TriggerInputs>> triggerInputs;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="total_steps")
    private Optional<Long> totalSteps;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_completed_step")
    private Optional<Long> lastCompletedStep;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_completed_step_name")
    private JsonNullable<String> lastCompletedStepName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="tags")
    private Optional<? extends List<String>> tags;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="metadata")
    private Optional<? extends Metadata> metadata;

    @JsonCreator
    public WorkflowInstance(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="workflow_status") Optional<String> workflowStatus, @JsonProperty(value="template_id") Optional<String> templateId, @JsonProperty(value="account_id") Optional<String> accountId, @JsonProperty(value="started_at") Optional<OffsetDateTime> startedAt, @JsonProperty(value="started_by") Optional<String> startedBy, @JsonProperty(value="started_by_name") Optional<String> startedByName, @JsonProperty(value="started_by_role") Optional<String> startedByRole, @JsonProperty(value="ended_at") JsonNullable<OffsetDateTime> endedAt, @JsonProperty(value="expires_at") JsonNullable<OffsetDateTime> expiresAt, @JsonProperty(value="last_modified_at") Optional<OffsetDateTime> lastModifiedAt, @JsonProperty(value="canceled_at") JsonNullable<OffsetDateTime> canceledAt, @JsonProperty(value="canceled_by") JsonNullable<String> canceledBy, @JsonProperty(value="trigger_inputs") Optional<? extends Map<String, TriggerInputs>> triggerInputs, @JsonProperty(value="total_steps") Optional<Long> totalSteps, @JsonProperty(value="last_completed_step") Optional<Long> lastCompletedStep, @JsonProperty(value="last_completed_step_name") JsonNullable<String> lastCompletedStepName, @JsonProperty(value="tags") Optional<? extends List<String>> tags, @JsonProperty(value="metadata") Optional<? extends Metadata> metadata) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(workflowStatus, "workflowStatus");
        Utils.checkNotNull(templateId, "templateId");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(startedAt, "startedAt");
        Utils.checkNotNull(startedBy, "startedBy");
        Utils.checkNotNull(startedByName, "startedByName");
        Utils.checkNotNull(startedByRole, "startedByRole");
        Utils.checkNotNull(endedAt, "endedAt");
        Utils.checkNotNull(expiresAt, "expiresAt");
        Utils.checkNotNull(lastModifiedAt, "lastModifiedAt");
        Utils.checkNotNull(canceledAt, "canceledAt");
        Utils.checkNotNull(canceledBy, "canceledBy");
        Utils.checkNotNull(triggerInputs, "triggerInputs");
        Utils.checkNotNull(totalSteps, "totalSteps");
        Utils.checkNotNull(lastCompletedStep, "lastCompletedStep");
        Utils.checkNotNull(lastCompletedStepName, "lastCompletedStepName");
        Utils.checkNotNull(tags, "tags");
        Utils.checkNotNull(metadata, "metadata");
        this.id = id;
        this.name = name;
        this.workflowStatus = workflowStatus;
        this.templateId = templateId;
        this.accountId = accountId;
        this.startedAt = startedAt;
        this.startedBy = startedBy;
        this.startedByName = startedByName;
        this.startedByRole = startedByRole;
        this.endedAt = endedAt;
        this.expiresAt = expiresAt;
        this.lastModifiedAt = lastModifiedAt;
        this.canceledAt = canceledAt;
        this.canceledBy = canceledBy;
        this.triggerInputs = triggerInputs;
        this.totalSteps = totalSteps;
        this.lastCompletedStep = lastCompletedStep;
        this.lastCompletedStepName = lastCompletedStepName;
        this.tags = tags;
        this.metadata = metadata;
    }

    public WorkflowInstance() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<String> workflowStatus() {
        return this.workflowStatus;
    }

    @JsonIgnore
    public Optional<String> templateId() {
        return this.templateId;
    }

    @JsonIgnore
    public Optional<String> accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> startedAt() {
        return this.startedAt;
    }

    @JsonIgnore
    public Optional<String> startedBy() {
        return this.startedBy;
    }

    @JsonIgnore
    public Optional<String> startedByName() {
        return this.startedByName;
    }

    @JsonIgnore
    public Optional<String> startedByRole() {
        return this.startedByRole;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> endedAt() {
        return this.endedAt;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> expiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> lastModifiedAt() {
        return this.lastModifiedAt;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> canceledAt() {
        return this.canceledAt;
    }

    @JsonIgnore
    public JsonNullable<String> canceledBy() {
        return this.canceledBy;
    }

    @JsonIgnore
    public Optional<Map<String, TriggerInputs>> triggerInputs() {
        return this.triggerInputs;
    }

    @JsonIgnore
    public Optional<Long> totalSteps() {
        return this.totalSteps;
    }

    @JsonIgnore
    public Optional<Long> lastCompletedStep() {
        return this.lastCompletedStep;
    }

    @JsonIgnore
    public JsonNullable<String> lastCompletedStepName() {
        return this.lastCompletedStepName;
    }

    @JsonIgnore
    public Optional<List<String>> tags() {
        return this.tags;
    }

    @JsonIgnore
    public Optional<Metadata> metadata() {
        return this.metadata;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public WorkflowInstance withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public WorkflowInstance withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public WorkflowInstance withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public WorkflowInstance withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public WorkflowInstance withWorkflowStatus(String workflowStatus) {
        Utils.checkNotNull(workflowStatus, "workflowStatus");
        this.workflowStatus = Optional.ofNullable(workflowStatus);
        return this;
    }

    public WorkflowInstance withWorkflowStatus(Optional<String> workflowStatus) {
        Utils.checkNotNull(workflowStatus, "workflowStatus");
        this.workflowStatus = workflowStatus;
        return this;
    }

    public WorkflowInstance withTemplateId(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = Optional.ofNullable(templateId);
        return this;
    }

    public WorkflowInstance withTemplateId(Optional<String> templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
        return this;
    }

    public WorkflowInstance withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = Optional.ofNullable(accountId);
        return this;
    }

    public WorkflowInstance withAccountId(Optional<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public WorkflowInstance withStartedAt(OffsetDateTime startedAt) {
        Utils.checkNotNull(startedAt, "startedAt");
        this.startedAt = Optional.ofNullable(startedAt);
        return this;
    }

    public WorkflowInstance withStartedAt(Optional<OffsetDateTime> startedAt) {
        Utils.checkNotNull(startedAt, "startedAt");
        this.startedAt = startedAt;
        return this;
    }

    public WorkflowInstance withStartedBy(String startedBy) {
        Utils.checkNotNull(startedBy, "startedBy");
        this.startedBy = Optional.ofNullable(startedBy);
        return this;
    }

    public WorkflowInstance withStartedBy(Optional<String> startedBy) {
        Utils.checkNotNull(startedBy, "startedBy");
        this.startedBy = startedBy;
        return this;
    }

    public WorkflowInstance withStartedByName(String startedByName) {
        Utils.checkNotNull(startedByName, "startedByName");
        this.startedByName = Optional.ofNullable(startedByName);
        return this;
    }

    public WorkflowInstance withStartedByName(Optional<String> startedByName) {
        Utils.checkNotNull(startedByName, "startedByName");
        this.startedByName = startedByName;
        return this;
    }

    public WorkflowInstance withStartedByRole(String startedByRole) {
        Utils.checkNotNull(startedByRole, "startedByRole");
        this.startedByRole = Optional.ofNullable(startedByRole);
        return this;
    }

    public WorkflowInstance withStartedByRole(Optional<String> startedByRole) {
        Utils.checkNotNull(startedByRole, "startedByRole");
        this.startedByRole = startedByRole;
        return this;
    }

    public WorkflowInstance withEndedAt(OffsetDateTime endedAt) {
        Utils.checkNotNull(endedAt, "endedAt");
        this.endedAt = JsonNullable.of((Object)endedAt);
        return this;
    }

    public WorkflowInstance withEndedAt(JsonNullable<OffsetDateTime> endedAt) {
        Utils.checkNotNull(endedAt, "endedAt");
        this.endedAt = endedAt;
        return this;
    }

    public WorkflowInstance withExpiresAt(OffsetDateTime expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = JsonNullable.of((Object)expiresAt);
        return this;
    }

    public WorkflowInstance withExpiresAt(JsonNullable<OffsetDateTime> expiresAt) {
        Utils.checkNotNull(expiresAt, "expiresAt");
        this.expiresAt = expiresAt;
        return this;
    }

    public WorkflowInstance withLastModifiedAt(OffsetDateTime lastModifiedAt) {
        Utils.checkNotNull(lastModifiedAt, "lastModifiedAt");
        this.lastModifiedAt = Optional.ofNullable(lastModifiedAt);
        return this;
    }

    public WorkflowInstance withLastModifiedAt(Optional<OffsetDateTime> lastModifiedAt) {
        Utils.checkNotNull(lastModifiedAt, "lastModifiedAt");
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

    public WorkflowInstance withCanceledAt(OffsetDateTime canceledAt) {
        Utils.checkNotNull(canceledAt, "canceledAt");
        this.canceledAt = JsonNullable.of((Object)canceledAt);
        return this;
    }

    public WorkflowInstance withCanceledAt(JsonNullable<OffsetDateTime> canceledAt) {
        Utils.checkNotNull(canceledAt, "canceledAt");
        this.canceledAt = canceledAt;
        return this;
    }

    public WorkflowInstance withCanceledBy(String canceledBy) {
        Utils.checkNotNull(canceledBy, "canceledBy");
        this.canceledBy = JsonNullable.of((Object)canceledBy);
        return this;
    }

    public WorkflowInstance withCanceledBy(JsonNullable<String> canceledBy) {
        Utils.checkNotNull(canceledBy, "canceledBy");
        this.canceledBy = canceledBy;
        return this;
    }

    public WorkflowInstance withTriggerInputs(Map<String, TriggerInputs> triggerInputs) {
        Utils.checkNotNull(triggerInputs, "triggerInputs");
        this.triggerInputs = Optional.ofNullable(triggerInputs);
        return this;
    }

    public WorkflowInstance withTriggerInputs(Optional<? extends Map<String, TriggerInputs>> triggerInputs) {
        Utils.checkNotNull(triggerInputs, "triggerInputs");
        this.triggerInputs = triggerInputs;
        return this;
    }

    public WorkflowInstance withTotalSteps(long totalSteps) {
        Utils.checkNotNull(totalSteps, "totalSteps");
        this.totalSteps = Optional.ofNullable(totalSteps);
        return this;
    }

    public WorkflowInstance withTotalSteps(Optional<Long> totalSteps) {
        Utils.checkNotNull(totalSteps, "totalSteps");
        this.totalSteps = totalSteps;
        return this;
    }

    public WorkflowInstance withLastCompletedStep(long lastCompletedStep) {
        Utils.checkNotNull(lastCompletedStep, "lastCompletedStep");
        this.lastCompletedStep = Optional.ofNullable(lastCompletedStep);
        return this;
    }

    public WorkflowInstance withLastCompletedStep(Optional<Long> lastCompletedStep) {
        Utils.checkNotNull(lastCompletedStep, "lastCompletedStep");
        this.lastCompletedStep = lastCompletedStep;
        return this;
    }

    public WorkflowInstance withLastCompletedStepName(String lastCompletedStepName) {
        Utils.checkNotNull(lastCompletedStepName, "lastCompletedStepName");
        this.lastCompletedStepName = JsonNullable.of((Object)lastCompletedStepName);
        return this;
    }

    public WorkflowInstance withLastCompletedStepName(JsonNullable<String> lastCompletedStepName) {
        Utils.checkNotNull(lastCompletedStepName, "lastCompletedStepName");
        this.lastCompletedStepName = lastCompletedStepName;
        return this;
    }

    public WorkflowInstance withTags(List<String> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = Optional.ofNullable(tags);
        return this;
    }

    public WorkflowInstance withTags(Optional<? extends List<String>> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = tags;
        return this;
    }

    public WorkflowInstance withMetadata(Metadata metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = Optional.ofNullable(metadata);
        return this;
    }

    public WorkflowInstance withMetadata(Optional<? extends Metadata> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowInstance other = (WorkflowInstance)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.workflowStatus, other.workflowStatus) && Objects.deepEquals(this.templateId, other.templateId) && Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.startedAt, other.startedAt) && Objects.deepEquals(this.startedBy, other.startedBy) && Objects.deepEquals(this.startedByName, other.startedByName) && Objects.deepEquals(this.startedByRole, other.startedByRole) && Objects.deepEquals(this.endedAt, other.endedAt) && Objects.deepEquals(this.expiresAt, other.expiresAt) && Objects.deepEquals(this.lastModifiedAt, other.lastModifiedAt) && Objects.deepEquals(this.canceledAt, other.canceledAt) && Objects.deepEquals(this.canceledBy, other.canceledBy) && Objects.deepEquals(this.triggerInputs, other.triggerInputs) && Objects.deepEquals(this.totalSteps, other.totalSteps) && Objects.deepEquals(this.lastCompletedStep, other.lastCompletedStep) && Objects.deepEquals(this.lastCompletedStepName, other.lastCompletedStepName) && Objects.deepEquals(this.tags, other.tags) && Objects.deepEquals(this.metadata, other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.workflowStatus, this.templateId, this.accountId, this.startedAt, this.startedBy, this.startedByName, this.startedByRole, this.endedAt, this.expiresAt, this.lastModifiedAt, this.canceledAt, this.canceledBy, this.triggerInputs, this.totalSteps, this.lastCompletedStep, this.lastCompletedStepName, this.tags, this.metadata);
    }

    public String toString() {
        return Utils.toString(WorkflowInstance.class, "id", this.id, "name", this.name, "workflowStatus", this.workflowStatus, "templateId", this.templateId, "accountId", this.accountId, "startedAt", this.startedAt, "startedBy", this.startedBy, "startedByName", this.startedByName, "startedByRole", this.startedByRole, "endedAt", this.endedAt, "expiresAt", this.expiresAt, "lastModifiedAt", this.lastModifiedAt, "canceledAt", this.canceledAt, "canceledBy", this.canceledBy, "triggerInputs", this.triggerInputs, "totalSteps", this.totalSteps, "lastCompletedStep", this.lastCompletedStep, "lastCompletedStepName", this.lastCompletedStepName, "tags", this.tags, "metadata", this.metadata);
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> workflowStatus = Optional.empty();
        private Optional<String> templateId = Optional.empty();
        private Optional<String> accountId = Optional.empty();
        private Optional<OffsetDateTime> startedAt = Optional.empty();
        private Optional<String> startedBy = Optional.empty();
        private Optional<String> startedByName = Optional.empty();
        private Optional<String> startedByRole = Optional.empty();
        private JsonNullable<OffsetDateTime> endedAt = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> expiresAt = JsonNullable.undefined();
        private Optional<OffsetDateTime> lastModifiedAt = Optional.empty();
        private JsonNullable<OffsetDateTime> canceledAt = JsonNullable.undefined();
        private JsonNullable<String> canceledBy = JsonNullable.undefined();
        private Optional<? extends Map<String, TriggerInputs>> triggerInputs = Optional.empty();
        private Optional<Long> totalSteps = Optional.empty();
        private Optional<Long> lastCompletedStep = Optional.empty();
        private JsonNullable<String> lastCompletedStepName = JsonNullable.undefined();
        private Optional<? extends List<String>> tags = Optional.empty();
        private Optional<? extends Metadata> metadata = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder workflowStatus(String workflowStatus) {
            Utils.checkNotNull(workflowStatus, "workflowStatus");
            this.workflowStatus = Optional.ofNullable(workflowStatus);
            return this;
        }

        public Builder workflowStatus(Optional<String> workflowStatus) {
            Utils.checkNotNull(workflowStatus, "workflowStatus");
            this.workflowStatus = workflowStatus;
            return this;
        }

        public Builder templateId(String templateId) {
            Utils.checkNotNull(templateId, "templateId");
            this.templateId = Optional.ofNullable(templateId);
            return this;
        }

        public Builder templateId(Optional<String> templateId) {
            Utils.checkNotNull(templateId, "templateId");
            this.templateId = templateId;
            return this;
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = Optional.ofNullable(accountId);
            return this;
        }

        public Builder accountId(Optional<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder startedAt(OffsetDateTime startedAt) {
            Utils.checkNotNull(startedAt, "startedAt");
            this.startedAt = Optional.ofNullable(startedAt);
            return this;
        }

        public Builder startedAt(Optional<OffsetDateTime> startedAt) {
            Utils.checkNotNull(startedAt, "startedAt");
            this.startedAt = startedAt;
            return this;
        }

        public Builder startedBy(String startedBy) {
            Utils.checkNotNull(startedBy, "startedBy");
            this.startedBy = Optional.ofNullable(startedBy);
            return this;
        }

        public Builder startedBy(Optional<String> startedBy) {
            Utils.checkNotNull(startedBy, "startedBy");
            this.startedBy = startedBy;
            return this;
        }

        public Builder startedByName(String startedByName) {
            Utils.checkNotNull(startedByName, "startedByName");
            this.startedByName = Optional.ofNullable(startedByName);
            return this;
        }

        public Builder startedByName(Optional<String> startedByName) {
            Utils.checkNotNull(startedByName, "startedByName");
            this.startedByName = startedByName;
            return this;
        }

        public Builder startedByRole(String startedByRole) {
            Utils.checkNotNull(startedByRole, "startedByRole");
            this.startedByRole = Optional.ofNullable(startedByRole);
            return this;
        }

        public Builder startedByRole(Optional<String> startedByRole) {
            Utils.checkNotNull(startedByRole, "startedByRole");
            this.startedByRole = startedByRole;
            return this;
        }

        public Builder endedAt(OffsetDateTime endedAt) {
            Utils.checkNotNull(endedAt, "endedAt");
            this.endedAt = JsonNullable.of((Object)endedAt);
            return this;
        }

        public Builder endedAt(JsonNullable<OffsetDateTime> endedAt) {
            Utils.checkNotNull(endedAt, "endedAt");
            this.endedAt = endedAt;
            return this;
        }

        public Builder expiresAt(OffsetDateTime expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = JsonNullable.of((Object)expiresAt);
            return this;
        }

        public Builder expiresAt(JsonNullable<OffsetDateTime> expiresAt) {
            Utils.checkNotNull(expiresAt, "expiresAt");
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
            Utils.checkNotNull(lastModifiedAt, "lastModifiedAt");
            this.lastModifiedAt = Optional.ofNullable(lastModifiedAt);
            return this;
        }

        public Builder lastModifiedAt(Optional<OffsetDateTime> lastModifiedAt) {
            Utils.checkNotNull(lastModifiedAt, "lastModifiedAt");
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public Builder canceledAt(OffsetDateTime canceledAt) {
            Utils.checkNotNull(canceledAt, "canceledAt");
            this.canceledAt = JsonNullable.of((Object)canceledAt);
            return this;
        }

        public Builder canceledAt(JsonNullable<OffsetDateTime> canceledAt) {
            Utils.checkNotNull(canceledAt, "canceledAt");
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder canceledBy(String canceledBy) {
            Utils.checkNotNull(canceledBy, "canceledBy");
            this.canceledBy = JsonNullable.of((Object)canceledBy);
            return this;
        }

        public Builder canceledBy(JsonNullable<String> canceledBy) {
            Utils.checkNotNull(canceledBy, "canceledBy");
            this.canceledBy = canceledBy;
            return this;
        }

        public Builder triggerInputs(Map<String, TriggerInputs> triggerInputs) {
            Utils.checkNotNull(triggerInputs, "triggerInputs");
            this.triggerInputs = Optional.ofNullable(triggerInputs);
            return this;
        }

        public Builder triggerInputs(Optional<? extends Map<String, TriggerInputs>> triggerInputs) {
            Utils.checkNotNull(triggerInputs, "triggerInputs");
            this.triggerInputs = triggerInputs;
            return this;
        }

        public Builder totalSteps(long totalSteps) {
            Utils.checkNotNull(totalSteps, "totalSteps");
            this.totalSteps = Optional.ofNullable(totalSteps);
            return this;
        }

        public Builder totalSteps(Optional<Long> totalSteps) {
            Utils.checkNotNull(totalSteps, "totalSteps");
            this.totalSteps = totalSteps;
            return this;
        }

        public Builder lastCompletedStep(long lastCompletedStep) {
            Utils.checkNotNull(lastCompletedStep, "lastCompletedStep");
            this.lastCompletedStep = Optional.ofNullable(lastCompletedStep);
            return this;
        }

        public Builder lastCompletedStep(Optional<Long> lastCompletedStep) {
            Utils.checkNotNull(lastCompletedStep, "lastCompletedStep");
            this.lastCompletedStep = lastCompletedStep;
            return this;
        }

        public Builder lastCompletedStepName(String lastCompletedStepName) {
            Utils.checkNotNull(lastCompletedStepName, "lastCompletedStepName");
            this.lastCompletedStepName = JsonNullable.of((Object)lastCompletedStepName);
            return this;
        }

        public Builder lastCompletedStepName(JsonNullable<String> lastCompletedStepName) {
            Utils.checkNotNull(lastCompletedStepName, "lastCompletedStepName");
            this.lastCompletedStepName = lastCompletedStepName;
            return this;
        }

        public Builder tags(List<String> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        public Builder tags(Optional<? extends List<String>> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        public Builder metadata(Metadata metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        public Builder metadata(Optional<? extends Metadata> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        public WorkflowInstance build() {
            return new WorkflowInstance(this.id, this.name, this.workflowStatus, this.templateId, this.accountId, this.startedAt, this.startedBy, this.startedByName, this.startedByRole, this.endedAt, this.expiresAt, this.lastModifiedAt, this.canceledAt, this.canceledBy, this.triggerInputs, this.totalSteps, this.lastCompletedStep, this.lastCompletedStepName, this.tags, this.metadata);
        }
    }
}

