/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.components;

import com.docusign.iam.sdk.models.components.Workflow;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WorkflowList {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="workflows")
    private Optional<? extends List<Workflow>> workflows;

    @JsonCreator
    public WorkflowList(@JsonProperty(value="workflows") Optional<? extends List<Workflow>> workflows) {
        Utils.checkNotNull(workflows, "workflows");
        this.workflows = workflows;
    }

    public WorkflowList() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<List<Workflow>> workflows() {
        return this.workflows;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public WorkflowList withWorkflows(List<Workflow> workflows) {
        Utils.checkNotNull(workflows, "workflows");
        this.workflows = Optional.ofNullable(workflows);
        return this;
    }

    public WorkflowList withWorkflows(Optional<? extends List<Workflow>> workflows) {
        Utils.checkNotNull(workflows, "workflows");
        this.workflows = workflows;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowList other = (WorkflowList)o;
        return Objects.deepEquals(this.workflows, other.workflows);
    }

    public int hashCode() {
        return Objects.hash(this.workflows);
    }

    public String toString() {
        return Utils.toString(WorkflowList.class, "workflows", this.workflows);
    }

    public static final class Builder {
        private Optional<? extends List<Workflow>> workflows = Optional.empty();

        private Builder() {
        }

        public Builder workflows(List<Workflow> workflows) {
            Utils.checkNotNull(workflows, "workflows");
            this.workflows = Optional.ofNullable(workflows);
            return this;
        }

        public Builder workflows(Optional<? extends List<Workflow>> workflows) {
            Utils.checkNotNull(workflows, "workflows");
            this.workflows = workflows;
            return this;
        }

        public WorkflowList build() {
            return new WorkflowList(this.workflows);
        }
    }
}

