/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.errors;

import com.docusign.iam.sdk.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;

public class APIException
extends Exception {
    private final HttpResponse<InputStream> rawResponse;
    private final int code;
    private final String message;
    private final byte[] body;

    public APIException(HttpResponse<InputStream> rawResponse, int code, String message, byte[] body) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(body, "body");
        this.rawResponse = rawResponse;
        this.code = code;
        this.message = message;
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIException other = (APIException)o;
        return Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.code, other.code) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Objects.hash(this.rawResponse, this.code, this.message, this.body);
    }

    @Override
    public String toString() {
        return Utils.toString(APIException.class, "rawResponse", this.rawResponse, "code", this.code, "message", this.message, "body", this.body);
    }

    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public byte[] body() {
        return this.body;
    }
}

