/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class ConnectedFieldsApiGetTabGroupsRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private String accountId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=appId")
    private Optional<String> appId;

    @JsonCreator
    public ConnectedFieldsApiGetTabGroupsRequest(String accountId, Optional<String> appId) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(appId, "appId");
        this.accountId = accountId;
        this.appId = appId;
    }

    public ConnectedFieldsApiGetTabGroupsRequest(String accountId) {
        this(accountId, Optional.empty());
    }

    @JsonIgnore
    public String accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public Optional<String> appId() {
        return this.appId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ConnectedFieldsApiGetTabGroupsRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsRequest withAppId(String appId) {
        Utils.checkNotNull(appId, "appId");
        this.appId = Optional.ofNullable(appId);
        return this;
    }

    public ConnectedFieldsApiGetTabGroupsRequest withAppId(Optional<String> appId) {
        Utils.checkNotNull(appId, "appId");
        this.appId = appId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedFieldsApiGetTabGroupsRequest other = (ConnectedFieldsApiGetTabGroupsRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.appId, other.appId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.appId);
    }

    public String toString() {
        return Utils.toString(ConnectedFieldsApiGetTabGroupsRequest.class, "accountId", this.accountId, "appId", this.appId);
    }

    public static final class Builder {
        private String accountId;
        private Optional<String> appId = Optional.empty();

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder appId(String appId) {
            Utils.checkNotNull(appId, "appId");
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        public Builder appId(Optional<String> appId) {
            Utils.checkNotNull(appId, "appId");
            this.appId = appId;
            return this;
        }

        public ConnectedFieldsApiGetTabGroupsRequest build() {
            return new ConnectedFieldsApiGetTabGroupsRequest(this.accountId, this.appId);
        }
    }
}

