/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.AgreementSummary;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class CreateAgreementSummaryResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AgreementSummary> agreementSummary;

    @JsonCreator
    public CreateAgreementSummaryResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AgreementSummary> agreementSummary) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(agreementSummary, "agreementSummary");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.agreementSummary = agreementSummary;
    }

    public CreateAgreementSummaryResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AgreementSummary> agreementSummary() {
        return this.agreementSummary;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateAgreementSummaryResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateAgreementSummaryResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateAgreementSummaryResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateAgreementSummaryResponse withAgreementSummary(AgreementSummary agreementSummary) {
        Utils.checkNotNull(agreementSummary, "agreementSummary");
        this.agreementSummary = Optional.ofNullable(agreementSummary);
        return this;
    }

    public CreateAgreementSummaryResponse withAgreementSummary(Optional<? extends AgreementSummary> agreementSummary) {
        Utils.checkNotNull(agreementSummary, "agreementSummary");
        this.agreementSummary = agreementSummary;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAgreementSummaryResponse other = (CreateAgreementSummaryResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.agreementSummary, other.agreementSummary);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.agreementSummary);
    }

    public String toString() {
        return Utils.toString(CreateAgreementSummaryResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "agreementSummary", this.agreementSummary);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AgreementSummary> agreementSummary = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder agreementSummary(AgreementSummary agreementSummary) {
            Utils.checkNotNull(agreementSummary, "agreementSummary");
            this.agreementSummary = Optional.ofNullable(agreementSummary);
            return this;
        }

        public Builder agreementSummary(Optional<? extends AgreementSummary> agreementSummary) {
            Utils.checkNotNull(agreementSummary, "agreementSummary");
            this.agreementSummary = agreementSummary;
            return this;
        }

        public CreateAgreementSummaryResponse build() {
            return new CreateAgreementSummaryResponse(this.contentType, this.statusCode, this.rawResponse, this.agreementSummary);
        }
    }
}

