/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetAgreementsListResponse;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.LazySingletonValue;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class GetAgreementsListRequestBuilder {
    private Optional<String> accountId = Utils.readDefaultOrConstValue("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});
    private JsonNullable<Integer> limit = JsonNullable.undefined();
    private JsonNullable<String> ctoken = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetAgreementsList sdk;
    private static final LazySingletonValue<Optional<String>> _SINGLETON_VALUE_AccountId = new LazySingletonValue<Optional<String>>("accountId", "\"00000000-0000-0000-0000-000000000000\"", new TypeReference<Optional<String>>(){});

    public GetAgreementsListRequestBuilder(SDKMethodInterfaces.MethodCallGetAgreementsList sdk) {
        this.sdk = sdk;
    }

    public GetAgreementsListRequestBuilder accountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = Optional.of(accountId);
        return this;
    }

    public GetAgreementsListRequestBuilder accountId(Optional<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public GetAgreementsListRequestBuilder limit(int limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = JsonNullable.of((Object)limit);
        return this;
    }

    public GetAgreementsListRequestBuilder limit(JsonNullable<Integer> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetAgreementsListRequestBuilder ctoken(String ctoken) {
        Utils.checkNotNull(ctoken, "ctoken");
        this.ctoken = JsonNullable.of((Object)ctoken);
        return this;
    }

    public GetAgreementsListRequestBuilder ctoken(JsonNullable<String> ctoken) {
        Utils.checkNotNull(ctoken, "ctoken");
        this.ctoken = ctoken;
        return this;
    }

    public GetAgreementsListRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetAgreementsListRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetAgreementsListResponse call() throws Exception {
        if (this.accountId == null) {
            this.accountId = _SINGLETON_VALUE_AccountId.value();
        }
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getAgreementsList(this.accountId, this.limit, this.ctoken, options);
    }
}

