/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.AgreementsResponse;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetAgreementsListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AgreementsResponse> agreementsResponse;

    @JsonCreator
    public GetAgreementsListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AgreementsResponse> agreementsResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(agreementsResponse, "agreementsResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.agreementsResponse = agreementsResponse;
    }

    public GetAgreementsListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AgreementsResponse> agreementsResponse() {
        return this.agreementsResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetAgreementsListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetAgreementsListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetAgreementsListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetAgreementsListResponse withAgreementsResponse(AgreementsResponse agreementsResponse) {
        Utils.checkNotNull(agreementsResponse, "agreementsResponse");
        this.agreementsResponse = Optional.ofNullable(agreementsResponse);
        return this;
    }

    public GetAgreementsListResponse withAgreementsResponse(Optional<? extends AgreementsResponse> agreementsResponse) {
        Utils.checkNotNull(agreementsResponse, "agreementsResponse");
        this.agreementsResponse = agreementsResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAgreementsListResponse other = (GetAgreementsListResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.agreementsResponse, other.agreementsResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.agreementsResponse);
    }

    public String toString() {
        return Utils.toString(GetAgreementsListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "agreementsResponse", this.agreementsResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AgreementsResponse> agreementsResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder agreementsResponse(AgreementsResponse agreementsResponse) {
            Utils.checkNotNull(agreementsResponse, "agreementsResponse");
            this.agreementsResponse = Optional.ofNullable(agreementsResponse);
            return this;
        }

        public Builder agreementsResponse(Optional<? extends AgreementsResponse> agreementsResponse) {
            Utils.checkNotNull(agreementsResponse, "agreementsResponse");
            this.agreementsResponse = agreementsResponse;
            return this;
        }

        public GetAgreementsListResponse build() {
            return new GetAgreementsListResponse(this.contentType, this.statusCode, this.rawResponse, this.agreementsResponse);
        }
    }
}

