/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.ConfidentialAuthCodeGrantRequestBody;
import com.docusign.iam.sdk.models.operations.GetTokenFromConfidentialAuthCodeResponse;
import com.docusign.iam.sdk.models.operations.GetTokenFromConfidentialAuthCodeSecurity;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class GetTokenFromConfidentialAuthCodeRequestBuilder {
    private ConfidentialAuthCodeGrantRequestBody request;
    private GetTokenFromConfidentialAuthCodeSecurity security;
    private Optional<String> serverURL = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetTokenFromConfidentialAuthCode sdk;

    public GetTokenFromConfidentialAuthCodeRequestBuilder(SDKMethodInterfaces.MethodCallGetTokenFromConfidentialAuthCode sdk) {
        this.sdk = sdk;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder request(ConfidentialAuthCodeGrantRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder security(GetTokenFromConfidentialAuthCodeSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder serverURL(String serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = Optional.of(serverURL);
        return this;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder serverURL(Optional<String> serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = serverURL;
        return this;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetTokenFromConfidentialAuthCodeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetTokenFromConfidentialAuthCodeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getTokenFromConfidentialAuthCode(this.request, this.security, this.serverURL, options);
    }
}

