/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.operations.GetTokenFromJWTGrantResponse;
import com.docusign.iam.sdk.models.operations.JWTGrant;
import com.docusign.iam.sdk.models.operations.SDKMethodInterfaces;
import com.docusign.iam.sdk.utils.Options;
import com.docusign.iam.sdk.utils.RetryConfig;
import com.docusign.iam.sdk.utils.Utils;
import java.util.Optional;

public class GetTokenFromJWTGrantRequestBuilder {
    private JWTGrant request;
    private Optional<String> serverURL = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetTokenFromJWTGrant sdk;

    public GetTokenFromJWTGrantRequestBuilder(SDKMethodInterfaces.MethodCallGetTokenFromJWTGrant sdk) {
        this.sdk = sdk;
    }

    public GetTokenFromJWTGrantRequestBuilder request(JWTGrant request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public GetTokenFromJWTGrantRequestBuilder serverURL(String serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = Optional.of(serverURL);
        return this;
    }

    public GetTokenFromJWTGrantRequestBuilder serverURL(Optional<String> serverURL) {
        Utils.checkNotNull(serverURL, "serverURL");
        this.serverURL = serverURL;
        return this;
    }

    public GetTokenFromJWTGrantRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetTokenFromJWTGrantRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetTokenFromJWTGrantResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getTokenFromJwtGrant(this.request, this.serverURL, options);
    }
}

