/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.JWTGrantResponse;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetTokenFromJWTGrantResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends JWTGrantResponse> jwtGrantResponse;

    @JsonCreator
    public GetTokenFromJWTGrantResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends JWTGrantResponse> jwtGrantResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jwtGrantResponse, "jwtGrantResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jwtGrantResponse = jwtGrantResponse;
    }

    public GetTokenFromJWTGrantResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<JWTGrantResponse> jwtGrantResponse() {
        return this.jwtGrantResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetTokenFromJWTGrantResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetTokenFromJWTGrantResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetTokenFromJWTGrantResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetTokenFromJWTGrantResponse withJWTGrantResponse(JWTGrantResponse jwtGrantResponse) {
        Utils.checkNotNull(jwtGrantResponse, "jwtGrantResponse");
        this.jwtGrantResponse = Optional.ofNullable(jwtGrantResponse);
        return this;
    }

    public GetTokenFromJWTGrantResponse withJWTGrantResponse(Optional<? extends JWTGrantResponse> jwtGrantResponse) {
        Utils.checkNotNull(jwtGrantResponse, "jwtGrantResponse");
        this.jwtGrantResponse = jwtGrantResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTokenFromJWTGrantResponse other = (GetTokenFromJWTGrantResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.jwtGrantResponse, other.jwtGrantResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.jwtGrantResponse);
    }

    public String toString() {
        return Utils.toString(GetTokenFromJWTGrantResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jwtGrantResponse", this.jwtGrantResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends JWTGrantResponse> jwtGrantResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jwtGrantResponse(JWTGrantResponse jwtGrantResponse) {
            Utils.checkNotNull(jwtGrantResponse, "jwtGrantResponse");
            this.jwtGrantResponse = Optional.ofNullable(jwtGrantResponse);
            return this;
        }

        public Builder jwtGrantResponse(Optional<? extends JWTGrantResponse> jwtGrantResponse) {
            Utils.checkNotNull(jwtGrantResponse, "jwtGrantResponse");
            this.jwtGrantResponse = jwtGrantResponse;
            return this;
        }

        public GetTokenFromJWTGrantResponse build() {
            return new GetTokenFromJWTGrantResponse(this.contentType, this.statusCode, this.rawResponse, this.jwtGrantResponse);
        }
    }
}

