/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.utils.HasSecurity;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class GetTokenFromRefreshTokenSecurity
implements HasSecurity {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="clientId")
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=custom,name=clientId")
    private Optional<String> clientId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="secretKey")
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=custom,name=secretKey")
    private Optional<String> secretKey;

    @JsonCreator
    public GetTokenFromRefreshTokenSecurity(@JsonProperty(value="clientId") Optional<String> clientId, @JsonProperty(value="secretKey") Optional<String> secretKey) {
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(secretKey, "secretKey");
        this.clientId = clientId;
        this.secretKey = secretKey;
    }

    public GetTokenFromRefreshTokenSecurity() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public Optional<String> secretKey() {
        return this.secretKey;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetTokenFromRefreshTokenSecurity withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public GetTokenFromRefreshTokenSecurity withClientId(Optional<String> clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public GetTokenFromRefreshTokenSecurity withSecretKey(String secretKey) {
        Utils.checkNotNull(secretKey, "secretKey");
        this.secretKey = Optional.ofNullable(secretKey);
        return this;
    }

    public GetTokenFromRefreshTokenSecurity withSecretKey(Optional<String> secretKey) {
        Utils.checkNotNull(secretKey, "secretKey");
        this.secretKey = secretKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTokenFromRefreshTokenSecurity other = (GetTokenFromRefreshTokenSecurity)o;
        return Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.secretKey, other.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secretKey);
    }

    public String toString() {
        return Utils.toString(GetTokenFromRefreshTokenSecurity.class, "clientId", this.clientId, "secretKey", this.secretKey);
    }

    public static final class Builder {
        private Optional<String> clientId = Optional.empty();
        private Optional<String> secretKey = Optional.empty();

        private Builder() {
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        public Builder clientId(Optional<String> clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder secretKey(String secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            this.secretKey = Optional.ofNullable(secretKey);
            return this;
        }

        public Builder secretKey(Optional<String> secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            this.secretKey = secretKey;
            return this;
        }

        public GetTokenFromRefreshTokenSecurity build() {
            return new GetTokenFromRefreshTokenSecurity(this.clientId, this.secretKey);
        }
    }
}

