/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.TriggerWorkflow;
import com.docusign.iam.sdk.utils.SpeakeasyMetadata;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class TriggerWorkflowRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=accountId")
    private String accountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=workflowId")
    private String workflowId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private TriggerWorkflow triggerWorkflow;

    @JsonCreator
    public TriggerWorkflowRequest(String accountId, String workflowId, TriggerWorkflow triggerWorkflow) {
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(workflowId, "workflowId");
        Utils.checkNotNull(triggerWorkflow, "triggerWorkflow");
        this.accountId = accountId;
        this.workflowId = workflowId;
        this.triggerWorkflow = triggerWorkflow;
    }

    @JsonIgnore
    public String accountId() {
        return this.accountId;
    }

    @JsonIgnore
    public String workflowId() {
        return this.workflowId;
    }

    @JsonIgnore
    public TriggerWorkflow triggerWorkflow() {
        return this.triggerWorkflow;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerWorkflowRequest withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public TriggerWorkflowRequest withWorkflowId(String workflowId) {
        Utils.checkNotNull(workflowId, "workflowId");
        this.workflowId = workflowId;
        return this;
    }

    public TriggerWorkflowRequest withTriggerWorkflow(TriggerWorkflow triggerWorkflow) {
        Utils.checkNotNull(triggerWorkflow, "triggerWorkflow");
        this.triggerWorkflow = triggerWorkflow;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerWorkflowRequest other = (TriggerWorkflowRequest)o;
        return Objects.deepEquals(this.accountId, other.accountId) && Objects.deepEquals(this.workflowId, other.workflowId) && Objects.deepEquals(this.triggerWorkflow, other.triggerWorkflow);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.workflowId, this.triggerWorkflow);
    }

    public String toString() {
        return Utils.toString(TriggerWorkflowRequest.class, "accountId", this.accountId, "workflowId", this.workflowId, "triggerWorkflow", this.triggerWorkflow);
    }

    public static final class Builder {
        private String accountId;
        private String workflowId;
        private TriggerWorkflow triggerWorkflow;

        private Builder() {
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder workflowId(String workflowId) {
            Utils.checkNotNull(workflowId, "workflowId");
            this.workflowId = workflowId;
            return this;
        }

        public Builder triggerWorkflow(TriggerWorkflow triggerWorkflow) {
            Utils.checkNotNull(triggerWorkflow, "triggerWorkflow");
            this.triggerWorkflow = triggerWorkflow;
            return this;
        }

        public TriggerWorkflowRequest build() {
            return new TriggerWorkflowRequest(this.accountId, this.workflowId, this.triggerWorkflow);
        }
    }
}

