/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.TriggerWorkflowSuccess;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class TriggerWorkflowResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TriggerWorkflowSuccess> triggerWorkflowSuccess;

    @JsonCreator
    public TriggerWorkflowResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TriggerWorkflowSuccess> triggerWorkflowSuccess) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(triggerWorkflowSuccess, "triggerWorkflowSuccess");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.triggerWorkflowSuccess = triggerWorkflowSuccess;
    }

    public TriggerWorkflowResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TriggerWorkflowSuccess> triggerWorkflowSuccess() {
        return this.triggerWorkflowSuccess;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TriggerWorkflowResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TriggerWorkflowResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TriggerWorkflowResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TriggerWorkflowResponse withTriggerWorkflowSuccess(TriggerWorkflowSuccess triggerWorkflowSuccess) {
        Utils.checkNotNull(triggerWorkflowSuccess, "triggerWorkflowSuccess");
        this.triggerWorkflowSuccess = Optional.ofNullable(triggerWorkflowSuccess);
        return this;
    }

    public TriggerWorkflowResponse withTriggerWorkflowSuccess(Optional<? extends TriggerWorkflowSuccess> triggerWorkflowSuccess) {
        Utils.checkNotNull(triggerWorkflowSuccess, "triggerWorkflowSuccess");
        this.triggerWorkflowSuccess = triggerWorkflowSuccess;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerWorkflowResponse other = (TriggerWorkflowResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.triggerWorkflowSuccess, other.triggerWorkflowSuccess);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.triggerWorkflowSuccess);
    }

    public String toString() {
        return Utils.toString(TriggerWorkflowResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "triggerWorkflowSuccess", this.triggerWorkflowSuccess);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TriggerWorkflowSuccess> triggerWorkflowSuccess = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder triggerWorkflowSuccess(TriggerWorkflowSuccess triggerWorkflowSuccess) {
            Utils.checkNotNull(triggerWorkflowSuccess, "triggerWorkflowSuccess");
            this.triggerWorkflowSuccess = Optional.ofNullable(triggerWorkflowSuccess);
            return this;
        }

        public Builder triggerWorkflowSuccess(Optional<? extends TriggerWorkflowSuccess> triggerWorkflowSuccess) {
            Utils.checkNotNull(triggerWorkflowSuccess, "triggerWorkflowSuccess");
            this.triggerWorkflowSuccess = triggerWorkflowSuccess;
            return this;
        }

        public TriggerWorkflowResponse build() {
            return new TriggerWorkflowResponse(this.contentType, this.statusCode, this.rawResponse, this.triggerWorkflowSuccess);
        }
    }
}

