/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import com.xxdb.DBTask;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BasicDBTask
implements DBTask {
    private String script;
    private List<Entity> args;
    private DBConnection conn;
    private Entity result = null;
    private String errMsg = null;
    private TaskStatus status = TaskStatus.PENDING;
    private CountDownLatch latch;
    private int timeOut = -1;

    public BasicDBTask(String script, List<Entity> args) {
        this.script = script;
        this.args = args;
        this.latch = new CountDownLatch(1);
    }

    public BasicDBTask(String script) {
        this(script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entity call() {
        try {
            this.result = this.args != null ? this.conn.run(this.script, this.args) : this.conn.run(this.script);
            this.errMsg = null;
            BasicDBTask basicDBTask = this;
            synchronized (basicDBTask) {
                this.status = TaskStatus.SUCCESS;
            }
        }
        catch (Exception t) {
            BasicDBTask basicDBTask = this;
            synchronized (basicDBTask) {
                this.status = TaskStatus.FAILED;
            }
            this.result = null;
            this.errMsg = t.getMessage();
        }
        finally {
            this.latch.countDown();
        }
        return this.result;
    }

    @Override
    public void setDBConnection(DBConnection conn) {
        this.conn = conn;
    }

    @Override
    public Entity getResult() {
        if (this.status != TaskStatus.SUCCESS) {
            throw new RuntimeException("Current status is: " + (Object)((Object)this.status) + "!");
        }
        return this.result;
    }

    @Override
    public String getErrorMsg() {
        return this.errMsg;
    }

    @Override
    public boolean isSuccessful() {
        return this.status == TaskStatus.SUCCESS;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public boolean isFinished() {
        return this.status != TaskStatus.PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(int timeOut) {
        block7: {
            try {
                if (timeOut > 0) {
                    boolean completed = this.latch.await(timeOut, TimeUnit.MILLISECONDS);
                    if (completed) break block7;
                    BasicDBTask basicDBTask = this;
                    synchronized (basicDBTask) {
                        if (this.status == TaskStatus.PENDING) {
                            DBConnection connection = new DBConnection();
                            connection.connect(this.conn.getHostName(), this.conn.getPort(), this.conn.getUserId(), this.conn.getPwd());
                            String sessionId = connection.getSessionID();
                            BasicStringVector bs = (BasicStringVector)connection.run("exec rootJobId from getConsoleJobs() where sessionId = " + sessionId);
                            ArrayList<Entity> arguments = new ArrayList<Entity>();
                            arguments.add(bs);
                            connection.run("cancelConsoleJob", arguments);
                        }
                        break block7;
                    }
                }
                this.latch.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void finish() {
        this.latch.countDown();
    }

    private static enum TaskStatus {
        PENDING,
        SUCCESS,
        FAILED;

    }
}

