/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import java.util.Arrays;

public class DeltaBitOutput {
    public static final int DEFAULT_ALLOCATION = 256;
    private long[] longArray;
    private int position = 0;
    protected long lB;
    protected int bitsLeft = 64;
    public static final long[] MASK_ARRAY;
    public static final long[] BIT_SET_MASK;

    public DeltaBitOutput() {
        this(256);
    }

    public DeltaBitOutput(int initialSize) {
        this.longArray = new long[initialSize];
        this.lB = this.longArray[this.position];
    }

    protected void expandAllocation() {
        long[] largerArray = new long[this.longArray.length * 2];
        System.arraycopy(this.longArray, 0, largerArray, 0, this.longArray.length);
        this.longArray = largerArray;
    }

    private void checkAndFlipByte() {
        if (this.bitsLeft == 0) {
            this.flipWord();
        }
    }

    protected int capacityLeft() {
        return this.longArray.length - this.position;
    }

    protected void flipWord() {
        if (this.capacityLeft() <= 2) {
            this.expandAllocation();
        }
        this.flipWordWithoutExpandCheck();
    }

    protected void flipWordWithoutExpandCheck() {
        this.longArray[this.position] = this.lB;
        ++this.position;
        this.resetInternalWord();
    }

    private void resetInternalWord() {
        this.lB = 0L;
        this.bitsLeft = 64;
    }

    public void writeBit() {
        this.lB |= BIT_SET_MASK[this.bitsLeft - 1];
        --this.bitsLeft;
        this.checkAndFlipByte();
    }

    public void skipBit() {
        --this.bitsLeft;
        this.checkAndFlipByte();
    }

    public void writeBits(long value, int bits) {
        if (bits <= this.bitsLeft) {
            int lastBitPosition = this.bitsLeft - bits;
            this.lB |= value << lastBitPosition & MASK_ARRAY[this.bitsLeft - 1];
            this.bitsLeft -= bits;
            this.checkAndFlipByte();
        } else {
            int firstBitPosition = bits - this.bitsLeft;
            this.lB |= (value &= MASK_ARRAY[bits - 1]) >>> firstBitPosition;
            this.flipWord();
            this.lB |= value << 64 - (bits -= this.bitsLeft);
            this.bitsLeft -= bits;
        }
    }

    public void flush() {
        this.flipWord();
    }

    public long[] getLongArray() {
        long[] copy = Arrays.copyOf(this.longArray, this.position + 1);
        copy[copy.length - 1] = this.lB;
        return copy;
    }

    static {
        int i;
        MASK_ARRAY = new long[64];
        long mask = 1L;
        long value = 0L;
        for (i = 0; i < MASK_ARRAY.length; ++i) {
            DeltaBitOutput.MASK_ARRAY[i] = value |= (mask <<= 1);
        }
        BIT_SET_MASK = new long[64];
        for (i = 0; i < BIT_SET_MASK.length; ++i) {
            DeltaBitOutput.BIT_SET_MASK[i] = 1L << i;
        }
    }
}

