/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DeltaBitInput;
import java.nio.ByteBuffer;

class DeltaOfDeltaBlockDecoder {
    private final int unitLength;
    private final int FIRST_DELTA_BITS;
    private DeltaBitInput in;
    private ByteBuffer dest;
    private long storedValue;
    private long storedDelta;
    private int count;

    public DeltaOfDeltaBlockDecoder(int unitLength) {
        this.unitLength = unitLength;
        this.FIRST_DELTA_BITS = unitLength * 8;
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public int decompress(long[] src, ByteBuffer dest) {
        this.dest = dest;
        this.storedValue = 0L;
        this.storedDelta = 0L;
        this.count = 0;
        this.in = new DeltaBitInput(src);
        boolean flag = this.in.readBit();
        while (!flag) {
            this.writeNull(dest);
            flag = this.in.readBit();
        }
        if (!this.readHeader()) {
            return this.count;
        }
        if (!this.first()) {
            return this.count;
        }
        while (this.in.getPosition() < src.length) {
            if (this.nextValue()) continue;
            return this.count;
        }
        return this.count;
    }

    private boolean readHeader() {
        try {
            long flag = 0L;
            flag = this.in.readBits(5);
            if (flag == 30L) {
                if (this.in.readBits(64) == -1L) {
                    return false;
                }
                this.in.rollBack(5);
                this.in.rollBack(64);
            } else {
                this.in.rollBack(5);
            }
            this.storedValue = DeltaOfDeltaBlockDecoder.decodeZigZag64(this.in.getLong(this.unitLength * 8));
            this.writeBuffer(this.dest, this.storedValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean first() {
        block9: {
            try {
                boolean flag = this.in.readBit();
                while (!flag) {
                    this.writeNull(this.dest);
                    flag = this.in.readBit();
                }
                int sign = (int)this.in.getLong(5);
                if (sign == 30) {
                    try {
                        if (this.in.getLong(64) == -1L) {
                            return false;
                        }
                        this.in.rollBack(64);
                        this.in.rollBack(5);
                        break block9;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        return false;
                    }
                }
                this.in.rollBack(5);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.storedDelta = DeltaOfDeltaBlockDecoder.decodeZigZag64(this.in.getLong(this.FIRST_DELTA_BITS));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.storedValue += this.storedDelta;
        this.writeBuffer(this.dest, this.storedValue);
        return true;
    }

    private boolean writeBuffer(ByteBuffer dest, long storedValue) {
        if (dest.limit() - dest.position() < this.unitLength) {
            return false;
        }
        if (this.unitLength == 2) {
            dest.putShort((short)storedValue);
        } else if (this.unitLength == 4) {
            dest.putInt((int)storedValue);
        } else if (this.unitLength == 8) {
            dest.putLong(storedValue);
        }
        ++this.count;
        return true;
    }

    private void writeNull(ByteBuffer dest) {
        if (dest.limit() - dest.position() < this.unitLength) {
            return;
        }
        if (this.unitLength == 2) {
            dest.putShort((short)Short.MIN_VALUE);
        } else if (this.unitLength == 4) {
            dest.putInt(Integer.MIN_VALUE);
        } else if (this.unitLength == 8) {
            dest.putLong(Long.MIN_VALUE);
        }
        ++this.count;
    }

    private boolean nextValue() {
        try {
            long deltaDelta;
            int readInstruction = this.in.nextClearBit(6);
            switch (readInstruction) {
                case 0: {
                    this.storedValue += this.storedDelta;
                    return this.writeBuffer(this.dest, this.storedValue);
                }
                case 2: {
                    deltaDelta = this.in.getLong(7);
                    break;
                }
                case 6: {
                    deltaDelta = this.in.getLong(9);
                    break;
                }
                case 14: {
                    deltaDelta = this.in.getLong(16);
                    break;
                }
                case 30: {
                    deltaDelta = this.in.getLong(32);
                    break;
                }
                case 62: {
                    deltaDelta = this.in.getLong(64);
                    if (deltaDelta != -1L) break;
                    return false;
                }
                case 63: {
                    this.writeNull(this.dest);
                    return true;
                }
                default: {
                    throw new RuntimeException("Fail to decompress value at position: " + this.in.getPosition() / 8 + " instruction: " + readInstruction);
                }
            }
            ++deltaDelta;
            deltaDelta = DeltaOfDeltaBlockDecoder.decodeZigZag64(deltaDelta);
            this.storedDelta += deltaDelta;
            this.storedValue += this.storedDelta;
            return this.writeBuffer(this.dest, this.storedValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

