/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DecoderFactory;
import com.xxdb.data.BasicDecimal32Vector;
import com.xxdb.data.BasicDecimal64Vector;
import com.xxdb.data.Entity;
import com.xxdb.data.EntityFactory;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;

public class VectorDecompressor {
    public Vector decompress(EntityFactory factory, ExtendedDataInput in, boolean extended, boolean isLittleEndian) throws IOException {
        int compressedBytes = in.readInt();
        in.skipBytes(7);
        byte compression = in.readByte();
        byte dataType = in.readByte();
        byte unitLength = in.readByte();
        short reserved = in.readShort();
        int extra = 0;
        extra = in.readInt();
        int elementCount = in.readInt();
        in.readInt();
        int tmp = extra;
        if (dataType < Entity.DATA_TYPE.DT_BOOL_ARRAY.getValue()) {
            extra = 1;
        }
        ExtendedDataInput decompressedIn = DecoderFactory.get(compression).decompress(in, compressedBytes - 20, unitLength, elementCount, isLittleEndian, extra, dataType, reserved);
        Entity.DATA_TYPE dt = Entity.DATA_TYPE.valueOf(dataType);
        if (dt == Entity.DATA_TYPE.DT_DECIMAL32) {
            return new BasicDecimal32Vector(Entity.DATA_FORM.DF_VECTOR, decompressedIn, tmp);
        }
        if (dt == Entity.DATA_TYPE.DT_DECIMAL64) {
            return new BasicDecimal64Vector(Entity.DATA_FORM.DF_VECTOR, decompressedIn, tmp);
        }
        return (Vector)factory.createEntity(Entity.DATA_FORM.DF_VECTOR, dt, decompressedIn, extended);
    }
}

