/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicByte;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicByteMatrix
extends AbstractMatrix {
    private byte[] values;

    public BasicByteMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new byte[rows * columns];
    }

    public BasicByteMatrix(int rows, int columns, List<byte[]> listOfArrays) throws Exception {
        super(rows, columns);
        this.values = new byte[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            byte[] array = listOfArrays.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicByteMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setInt(int row, int column, byte value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public byte getByte(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == -128;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = -128;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicByte(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BYTE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicByte.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int len;
        int size = rows * columns;
        this.values = new byte[size];
        for (int off = 0; off < size; off += len) {
            len = Math.min(4096, size - off);
            in.readFully(this.values, off, len);
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (byte value : this.values) {
            out.writeByte(value);
        }
    }

    @Override
    @JsonIgnore
    public int getScale() {
        return super.getScale();
    }
}

