/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractEntity;
import com.xxdb.data.BasicUuid;
import com.xxdb.data.Entity;
import com.xxdb.io.AbstractExtendedDataOutputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BasicChunkMeta
extends AbstractEntity
implements Entity {
    private String path;
    private BasicUuid id;
    private int version;
    private int size;
    private byte flag;
    private List<String> sites;

    public BasicChunkMeta(ExtendedDataInput in) throws IOException {
        in.readShort();
        this.path = in.readString();
        this.id = new BasicUuid(in);
        this.version = in.readInt();
        this.size = in.readInt();
        this.flag = in.readByte();
        this.sites = new ArrayList<String>();
        int copyCount = in.readByte();
        for (int i = 0; i < copyCount; ++i) {
            this.sites.add(in.readString());
        }
    }

    public String getPath() {
        return this.path;
    }

    public BasicUuid getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public int size() {
        return this.size;
    }

    public int getCopyCount() {
        return this.sites.size();
    }

    public boolean isFileBlock() {
        return (this.flag & 3) == 1;
    }

    public boolean isTablet() {
        return (this.flag & 3) == 0;
    }

    public boolean isSplittable() {
        return (this.flag & 4) == 1;
    }

    @Override
    public Entity.DATA_FORM getDataForm() {
        return Entity.DATA_FORM.DF_CHUNK;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return null;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return null;
    }

    @Override
    public int rows() {
        return 1;
    }

    @Override
    public int columns() {
        return 0;
    }

    @Override
    public String getString() {
        StringBuilder str = new StringBuilder(this.isTablet() ? "Tablet[" : "FileBlock[");
        str.append(this.path);
        str.append(", ");
        str.append(this.id.getString());
        str.append(", {");
        for (int i = 0; i < this.sites.size(); ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(this.sites.get(i));
        }
        str.append("}, v");
        str.append(this.version);
        str.append(", ");
        str.append(this.size);
        if (this.isSplittable()) {
            str.append(", splittable]");
        } else {
            str.append("]");
        }
        return str.toString();
    }

    @Override
    public void write(ExtendedDataOutput output) throws IOException {
        int length = 27 + AbstractExtendedDataOutputStream.getUTFlength(this.path, 0, 0) + this.sites.size();
        for (String site : this.sites) {
            length += AbstractExtendedDataOutputStream.getUTFlength(site, 0, 0);
        }
        output.writeShort(length);
        output.writeString(this.path);
        output.writeLong2(this.id.getLong2());
        output.writeInt(this.version);
        output.writeInt(this.size);
        output.writeByte(this.flag);
        output.writeByte(this.sites.size());
        for (String site : this.sites) {
            output.writeUTF(site);
        }
    }
}

