/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDecimal32;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BasicDecimal32Vector
extends AbstractVector {
    private int scale_ = -1;
    private int[] unscaledValues;
    private int size;
    private int capacity;

    public BasicDecimal32Vector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDecimal32Vector(int size, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale_ = scale;
        this.unscaledValues = new int[size];
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    BasicDecimal32Vector(Entity.DATA_FORM df, int size) {
        super(df);
        this.unscaledValues = new int[size];
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    public BasicDecimal32Vector(String[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale_ = scale;
        int length = data.length;
        this.unscaledValues = new int[length];
        for (int i = 0; i < length; ++i) {
            BigDecimal bd = new BigDecimal(data[i]);
            BigDecimal multipliedValue = bd.scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP);
            if (multipliedValue.intValue() <= Integer.MIN_VALUE || multipliedValue.intValue() >= Integer.MAX_VALUE) continue;
            this.unscaledValues[i] = multipliedValue.intValue();
        }
        this.size = length;
        this.capacity = length;
    }

    BasicDecimal32Vector(int[] dataValue, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale_ = scale;
        this.unscaledValues = dataValue;
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    public BasicDecimal32Vector(Entity.DATA_FORM df, ExtendedDataInput in, int extra) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.unscaledValues = new int[size];
        this.scale_ = extra != -1 ? extra : in.readInt();
        long totalBytes = (long)size * 4L;
        boolean little = in.isLittleEndian();
        ByteOrder bo = little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 4L);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                int value;
                this.unscaledValues[i + start] = value = byteBuffer.getInt(i * 4);
            }
        }
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    @Deprecated
    public BasicDecimal32Vector(double[] data, int scale) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (scale < 0 || scale > 9) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,9].");
        }
        this.scale_ = scale;
        int[] newIntValue = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(data[i]));
            newIntValue[i] = dbvalue.multiply(pow).intValue();
        }
        this.unscaledValues = newIntValue;
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 4L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.unscaledValues[i + start] = byteBuffer.getInt(i * 4);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.unscaledValues.length;
        this.capacity = this.unscaledValues.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        int[] data = new int[this.size];
        System.arraycopy(this.unscaledValues, 0, data, 0, this.size);
        out.writeInt(this.scale_);
        out.writeIntArray(data);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicDecimal32Vector v = (BasicDecimal32Vector)vector;
        if (v.getScale() != this.scale_) {
            throw new RuntimeException("The scale of the vector to be combine does not match the scale of the current vector.");
        }
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.unscaledValues, 0, newValue, 0, this.rows());
        System.arraycopy(v.unscaledValues, 0, newValue, this.rows(), v.rows());
        return new BasicDecimal32Vector(newValue, this.scale_);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        int[] sub = new int[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.unscaledValues[indices[i]];
        }
        return new BasicDecimal32Vector(sub, this.scale_);
    }

    @Override
    public int asof(Scalar value) {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        return this.unscaledValues[index] == Integer.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.unscaledValues[index] = Integer.MIN_VALUE;
    }

    @Override
    public Entity get(int index) {
        return new BasicDecimal32(new int[]{this.scale_, this.unscaledValues[index]});
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        if (!value.getDataForm().equals((Object)Entity.DATA_FORM.DF_SCALAR) || value.getDataType() != Entity.DATA_TYPE.DT_DECIMAL32) {
            throw new RuntimeException("value type is not BasicDecimal32!");
        }
        int newScale = ((Scalar)value).getScale();
        Entity.DATA_TYPE type = value.getDataType();
        if (this.scale_ < 0) {
            this.scale_ = newScale;
        }
        if (((Scalar)value).isNull()) {
            this.unscaledValues[index] = Integer.MIN_VALUE;
        } else if (this.scale_ != newScale) {
            BigInteger newValue = BigInteger.valueOf(((BasicDecimal32)value).getInt());
            BigInteger pow = BigInteger.valueOf(10L);
            if (newScale - this.scale_ > 0) {
                pow = pow.pow(newScale - this.scale_);
                newValue = newValue.divide(pow);
            } else {
                pow = pow.pow(this.scale_ - newScale);
                newValue = newValue.multiply(pow);
            }
            this.unscaledValues[index] = newValue.intValue();
        } else {
            this.unscaledValues[index] = ((BasicDecimal32)value).getInt();
        }
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDecimal32.class;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeInt(this.unscaledValues[start + i]);
        }
    }

    @Override
    public int getUnitLength() {
        return 4;
    }

    public void add(String value) {
        if (this.size + 1 > this.capacity && this.unscaledValues.length > 0) {
            this.unscaledValues = Arrays.copyOf(this.unscaledValues, this.unscaledValues.length * 2);
        } else if (this.unscaledValues.length <= 0) {
            this.unscaledValues = new int[1];
        }
        this.capacity = this.unscaledValues.length;
        if (value.equals("0.0")) {
            this.unscaledValues[this.size] = 0;
        } else if (value.equals("")) {
            this.unscaledValues[this.size] = Integer.MIN_VALUE;
        } else {
            BigDecimal bd = new BigDecimal(value);
            BigDecimal pow = BigDecimal.TEN.pow(this.scale_);
            if (this.checkDecimal32Range(bd.multiply(pow).intValue())) {
                this.unscaledValues[this.size] = bd.multiply(pow).intValue();
            }
        }
        ++this.size;
    }

    @Deprecated
    public void add(double value) {
        if (this.size + 1 > this.capacity && this.unscaledValues.length > 0) {
            this.unscaledValues = Arrays.copyOf(this.unscaledValues, this.unscaledValues.length * 2);
        } else if (this.unscaledValues.length <= 0) {
            this.unscaledValues = Arrays.copyOf(this.unscaledValues, this.unscaledValues.length + 1);
        }
        this.capacity = this.unscaledValues.length;
        if (value == 0.0) {
            this.unscaledValues[this.size] = 0;
        } else {
            BigDecimal pow = new BigDecimal(1);
            for (long i = 0L; i < (long)this.scale_; ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            this.unscaledValues[this.size] = dbvalue.multiply(pow).intValue();
        }
        ++this.size;
    }

    void addRange(int[] valueList) {
        int requiredCapacity = this.size + valueList.length;
        this.checkCapacity(requiredCapacity);
        System.arraycopy(valueList, 0, this.unscaledValues, this.size, valueList.length);
        this.size += valueList.length;
    }

    public void addRange(String[] valueList) {
        int[] newIntValue = new int[valueList.length];
        BigDecimal pow = BigDecimal.TEN.pow(this.scale_);
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal bd = new BigDecimal(valueList[i]);
            if (!this.checkDecimal32Range(bd.multiply(pow).intValue())) continue;
            newIntValue[i] = bd.multiply(pow).intValue();
        }
        this.unscaledValues = Arrays.copyOf(this.unscaledValues, newIntValue.length + this.unscaledValues.length);
        System.arraycopy(newIntValue, 0, this.unscaledValues, this.size, newIntValue.length);
        this.size += newIntValue.length;
        this.capacity = this.unscaledValues.length;
    }

    @Deprecated
    public void addRange(double[] valueList) {
        int[] newIntValue = new int[valueList.length];
        for (int i = 0; i < valueList.length; ++i) {
            BigDecimal pow = new BigDecimal(1);
            for (long j = 0L; j < (long)this.scale_; ++j) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(valueList[i]));
            newIntValue[i] = dbvalue.multiply(pow).intValue();
        }
        this.unscaledValues = Arrays.copyOf(this.unscaledValues, newIntValue.length + this.unscaledValues.length);
        System.arraycopy(newIntValue, 0, this.unscaledValues, this.size, newIntValue.length);
        this.size += newIntValue.length;
        this.capacity = this.unscaledValues.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getString());
    }

    @Override
    public void Append(Vector value) throws Exception {
        if (((BasicDecimal32Vector)value).getScale() == this.scale_) {
            this.addRange(((BasicDecimal32Vector)value).getdataArray());
        } else {
            for (int i = 0; i < value.rows(); ++i) {
                this.Append((Scalar)value.get(i));
            }
        }
    }

    @Override
    public void checkCapacity(int requiredCapacity) {
        if (requiredCapacity > this.unscaledValues.length) {
            int newCapacity = Math.max((int)((double)this.unscaledValues.length * 1.5), requiredCapacity);
            this.unscaledValues = Arrays.copyOf(this.unscaledValues, newCapacity);
            this.capacity = newCapacity;
        }
    }

    public void setScale(int scale) {
        this.scale_ = scale;
    }

    public int getScale() {
        return this.scale_;
    }

    @JsonIgnore
    public int[] getdataArray() {
        int[] data = new int[this.size];
        System.arraycopy(this.unscaledValues, 0, data, 0, this.size);
        return data;
    }

    @Override
    public void setExtraParamForType(int scale) {
        this.scale_ = scale;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL32;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    public int getExtraParamForType() {
        return this.scale_;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            out.putInt(this.unscaledValues[indexStart + i]);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 4;
    }

    private boolean checkDecimal32Range(int value) {
        return value > Integer.MIN_VALUE && value < Integer.MAX_VALUE;
    }

    public int[] getUnscaledValues() {
        return this.unscaledValues;
    }
}

