/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.temporal.Temporal;

public class BasicDecimal64
extends AbstractScalar
implements Comparable<BasicDecimal64> {
    private int scale_ = 0;
    private long value_;
    private static final BigDecimal DECIMAL64_MIN_VALUE = new BigDecimal("-9223372036854775808");
    private static final BigDecimal DECIMAL64_MAX_VALUE = new BigDecimal("9223372036854775807");

    public BasicDecimal64(ExtendedDataInput in) throws IOException {
        this.scale_ = in.readInt();
        this.value_ = in.readLong();
    }

    public BasicDecimal64(ExtendedDataInput in, int scale) throws IOException {
        this.scale_ = scale;
        this.value_ = in.readLong();
    }

    public BasicDecimal64(long value, int scale) {
        this(String.valueOf(value), scale);
    }

    public BasicDecimal64(String value, int scale) {
        if (Utils.isEmpty(value)) {
            throw new RuntimeException("value is empty!");
        }
        if (scale < 0 || scale > 18) {
            throw new RuntimeException("Scale " + scale + " is out of bounds, it must be in [0,18].");
        }
        this.scale_ = scale;
        if ("0".equals(value)) {
            this.value_ = 0L;
        } else {
            BigInteger unscaledVal = new BigDecimal(value).scaleByPowerOfTen(scale).setScale(0, RoundingMode.HALF_UP).toBigInteger();
            BigDecimal bd = new BigDecimal(unscaledVal);
            if (bd.compareTo(DECIMAL64_MIN_VALUE) < 0 || bd.compareTo(DECIMAL64_MAX_VALUE) > 0) {
                throw new RuntimeException("Decimal math overflow: " + value);
            }
            this.value_ = bd.longValue();
        }
    }

    @Deprecated
    public BasicDecimal64(double value, int scale) {
        this.scale_ = scale;
        if (value == 0.0) {
            this.value_ = 0L;
        } else {
            BigDecimal pow = new BigDecimal(1);
            for (long i = 0L; i < (long)this.scale_; ++i) {
                pow = pow.multiply(new BigDecimal(10));
            }
            BigDecimal dbvalue = new BigDecimal(Double.toString(value));
            this.value_ = dbvalue.multiply(pow).longValue();
        }
    }

    BasicDecimal64(int scale, long value) {
        this.scale_ = scale;
        this.value_ = value;
    }

    @Override
    public void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeInt(this.scale_);
        out.writeLong(this.value_);
    }

    public void writeScalarRawDataToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLong(this.value_);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.DENARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DECIMAL64;
    }

    @Override
    public String getString() {
        if (this.scale_ == 0 && !this.isNull()) {
            return String.valueOf(this.value_);
        }
        if (this.isNull()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal pow = new BigDecimal(1);
        for (long i = 0L; i < (long)this.scale_; ++i) {
            pow = pow.multiply(new BigDecimal(10));
        }
        if (this.value_ < 0L && this.value_ / pow.longValue() == 0L) {
            sb.append("-");
        }
        sb.append(this.value_ / pow.longValue());
        if (pow.intValue() != 1) {
            int sign = this.value_ < 0L ? -1 : 1;
            BigDecimal result = new BigDecimal(this.value_ % pow.longValue() * (long)sign);
            sb.append(".");
            String s = result.toString();
            int nowLen = sb.length();
            while (sb.length() - nowLen < this.scale_ - s.length()) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean isNull() {
        return this.value_ == Long.MIN_VALUE;
    }

    @Override
    public void setNull() {
        this.value_ = Long.MIN_VALUE;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return Long.MIN_VALUE;
        }
        BigDecimal pow = new BigDecimal(1);
        for (long i = 0L; i < (long)this.scale_; ++i) {
            pow = pow.multiply(new BigDecimal(10));
        }
        BigDecimal dbvalue = new BigDecimal(this.value_);
        double num = dbvalue.divide(pow).doubleValue();
        if (num % 1.0 == 0.0) {
            return (long)num;
        }
        return num;
    }

    @Override
    public int getScale() {
        return this.scale_;
    }

    @Override
    @JsonIgnore
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public int hashBucket(int buckets) {
        return 0;
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return this.getString();
    }

    @Override
    public int compareTo(BasicDecimal64 o) {
        double a = Double.parseDouble(this.getString());
        double b = Double.parseDouble(o.getString());
        return Double.compare(a, b);
    }

    public long getLong() {
        return this.value_;
    }
}

