/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongMatrix;
import com.xxdb.data.BasicNanoTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicNanoTimestampMatrix
extends BasicLongMatrix {
    public BasicNanoTimestampMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicNanoTimestampMatrix(int rows, int columns, List<long[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicNanoTimestampMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setNanoTimestamp(int row, int column, LocalDateTime value) {
        this.setLong(row, column, Utils.countDTNanoseconds(value));
    }

    public LocalDateTime getNanoTimestamp(int row, int column) {
        return Utils.parseNanoTimestamp(this.getLong(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicNanoTimestamp(this.getLong(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIMESTAMP;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicNanoTimestamp.class;
    }
}

