/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongVector;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicTimestampVector
extends BasicLongVector {
    public BasicTimestampVector(int size) {
        super(size);
    }

    public BasicTimestampVector(List<Long> list) {
        super(list);
    }

    public BasicTimestampVector(long[] array) {
        super(array);
    }

    public BasicTimestampVector(long[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicTimestampVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicTimestampVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIMESTAMP;
    }

    @Override
    public Entity get(int index) {
        return new BasicTimestamp(this.getLong(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicTimestampVector(this.getSubArray(indices), false);
    }

    public LocalDateTime getTimestamp(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseTimestamp(this.getLong(index));
    }

    public void setTimestamp(int index, LocalDateTime dt) {
        this.setLong(index, Utils.countMilliseconds(dt));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicTimestamp.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicTimestampVector v = (BasicTimestampVector)vector;
        int newSize = this.rows() + v.rows();
        long[] newValue = new long[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicTimestampVector(newValue);
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().longValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicTimestampVector)value).getdataArray());
    }
}

