/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DdbByteArrayInputStream
extends InputStream {
    protected List<byte[]> bufList_ = new ArrayList<byte[]>();
    protected long count_;
    protected long pos_;
    protected int bufIndex_;
    protected int bufPos_;
    protected long mark_ = 0L;
    protected int markBufIndex_ = 0;
    protected int markBufPos_ = 0;

    public DdbByteArrayInputStream(List<byte[]> list) {
        this.bufList_.addAll(list);
        this.pos_ = 0L;
        this.count_ = 0L;
        this.bufIndex_ = 0;
        this.bufPos_ = 0;
        list.forEach(one -> this.count_ += (long)((byte[])one).length);
    }

    @Override
    public synchronized int read() {
        if (this.pos_ >= this.count_) {
            return -1;
        }
        ++this.pos_;
        byte[] bytes = this.bufList_.get(this.bufIndex_);
        int ret = bytes[this.bufPos_++] & 0xFF;
        if (this.bufPos_ >= bytes.length) {
            ++this.bufIndex_;
            this.bufPos_ = 0;
        }
        return ret;
    }

    public synchronized void append(byte[] buf) {
        this.bufList_.add(buf);
        this.count_ += (long)buf.length;
    }

    public synchronized int read(byte[] b, long off, long len) {
        throw new RuntimeException("This method is not support yet");
    }

    @Override
    public synchronized long skip(long n) {
        long ret = n;
        this.pos_ += n;
        while (n > 0L) {
            byte[] bytes = this.bufList_.get(this.bufIndex_);
            if (n >= (long)(bytes.length - this.bufPos_)) {
                n -= (long)(bytes.length - this.bufPos_);
                this.bufPos_ = 0;
                ++this.bufIndex_;
                continue;
            }
            this.bufPos_ = (int)((long)this.bufPos_ + n);
            n = 0L;
        }
        return ret;
    }

    @Override
    public synchronized int available() {
        long len = this.count_ - this.pos_;
        if (len > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)len;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark_ = this.pos_;
        this.markBufIndex_ = this.bufIndex_;
        this.markBufPos_ = this.bufPos_;
    }

    @Override
    public synchronized void reset() {
        this.pos_ = this.mark_;
        this.bufIndex_ = this.markBufIndex_;
        this.bufPos_ = this.markBufPos_;
    }

    @Override
    public void close() throws IOException {
    }
}

