/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCCallableStatement;
import com.dolphindb.jdbc.JDBCDataBaseMetaData;
import com.dolphindb.jdbc.JDBCPrepareStatement;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.Utils;
import com.xxdb.DBConnection;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ProgressListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;

public class JDBCConnection
implements Connection {
    private DBConnection controlConnection;
    private DBConnection dbConnection;
    private String hostName;
    private int port;
    private boolean success;
    private String databases;
    private Vector tables;
    private String url;
    private DatabaseMetaData metaData;
    private List<String> hostName_ports;
    private boolean isDFS;
    private StringBuilder sqlSb;
    private String controlHost;
    private int controlPort;
    private String user;
    private String password;
    private Properties clientInfo = new Properties();

    public JDBCConnection(String url, Properties prop) throws SQLException {
        this.url = url;
        this.dbConnection = new DBConnection();
        this.hostName = prop.getProperty("hostName");
        this.port = Integer.parseInt(prop.getProperty("port"));
        this.controlHost = null;
        this.controlPort = -1;
        this.setUser(null);
        this.setPassword(null);
        this.clientInfo = prop;
        try {
            this.open(this.hostName, this.port, prop);
        }
        catch (IOException e) {
            e.printStackTrace();
            String s = e.getMessage();
            if (s.contains("Connection refused")) {
                throw new SQLException(MessageFormat.format("{0}  ==> hostName = {1}, port = {2}", s, this.hostName, this.port));
            }
            throw new SQLException(e);
        }
    }

    public DBConnection getDBConnection() {
        return this.dbConnection;
    }

    public void setDBConnection(DBConnection dbConnection) {
        this.dbConnection = dbConnection;
    }

    private boolean tryOtherNode(String hostname, int FuncationPort, Properties prop) throws IOException, SQLException {
        this.controlConnection = new DBConnection();
        if (this.controlHost != null && this.controlPort > 0) {
            this.controlConnection.connect(this.controlHost, this.controlPort);
            BasicTable table = (BasicTable)this.controlConnection.run("getClusterChunkNodesStatus()");
            Vector siteVector = table.getColumn("site");
            LinkedList<String> other_ports = new LinkedList<String>();
            int len = siteVector.rows();
            for (int i = 0; i < len; ++i) {
                other_ports.add(siteVector.get(i).getString());
            }
            int size = other_ports.size();
            for (int index = 0; index < size; ++index) {
                String[] hostName_port = ((String)other_ports.get(index)).split(":");
                if (hostName_port[1].equals(String.valueOf(FuncationPort))) continue;
                System.out.println("connecting " + hostname + ":" + hostName_port[1]);
                if (!this.reachable(hostname, Integer.parseInt(hostName_port[1]), prop)) {
                    System.out.println("Cannot connect " + hostname + ":" + hostName_port[1]);
                    continue;
                }
                this.checklogin(hostname, Integer.parseInt(hostName_port[1]), prop);
                this.port = Integer.parseInt(hostName_port[1]);
                break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reachable(String hostname, int port, Properties prop) {
        Socket s = new Socket();
        InetSocketAddress add = new InetSocketAddress(hostname, port);
        int waitingTime = 3;
        if (prop.containsKey("waitingTime")) {
            waitingTime = Integer.parseInt(prop.getProperty("waitingTime"));
        }
        try {
            s.connect(add, waitingTime * 1000);
        }
        catch (IOException e) {
            System.out.println("cannot reach" + hostname + ":" + port);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void checklogin(String hostname, int port, Properties prop) {
        try {
            if (prop.containsKey("user") && prop.containsKey("password")) {
                this.success = this.dbConnection.connect(hostname, port, prop.getProperty("user"), prop.getProperty("password"));
                this.setUser(prop.getProperty("user"));
                this.setPassword(prop.getProperty("password"));
            } else {
                this.success = this.dbConnection.connect(hostname, port);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void connect(String hostname, int port, Properties prop) throws IOException {
        String userId = prop.getProperty("user");
        String password = prop.getProperty("password");
        String initialScript = prop.getProperty("initialScript");
        if ((initialScript = Utils.changeCase(initialScript)) != null && initialScript.equals("select 1")) {
            initialScript = "select 1 as val";
        }
        Boolean highAvailability = Boolean.valueOf(prop.getProperty("highAvailability"));
        String rowHighAvailabilitySites = prop.getProperty("highAvailabilitySites");
        String[] highAvailabilitySites = null;
        if (rowHighAvailabilitySites != null) {
            highAvailabilitySites = rowHighAvailabilitySites.split(" ");
        }
        this.success = userId != null && password != null ? (initialScript != null && highAvailability.booleanValue() && highAvailabilitySites != null ? this.dbConnection.connect(hostname, port, userId, password, initialScript, highAvailability.booleanValue(), highAvailabilitySites) : this.dbConnection.connect(hostname, port, userId, password)) : (initialScript != null && highAvailabilitySites != null ? this.dbConnection.connect(hostname, port, initialScript, highAvailabilitySites) : this.dbConnection.connect(this.hostName, port));
    }

    private void open(String hostname, int port, Properties prop) throws SQLException, IOException {
        int length;
        this.connect(hostname, port, prop);
        if (!this.success) {
            throw new SQLException("Connection is fail");
        }
        String[] key = new String[]{"databasePath"};
        String[] value = new String[6];
        String[] valueName = Utils.getProperties(prop, key);
        String hasScripts = prop.getProperty("length");
        if (valueName[0] != null && valueName[0].length() > 0) {
            String controllerAlias;
            valueName[0] = "\"" + valueName[0] + "\"";
            value[0] = valueName[0];
            Entity dbInfo = this.dbConnection.run("database(" + value[0] + ").schema()");
            Entity partitionTypeName = ((BasicDictionary)dbInfo).get((Scalar)new BasicString("partitionTypeName"));
            value[1] = partitionTypeName.getString();
            Entity partitionScheme = ((BasicDictionary)dbInfo).get((Scalar)new BasicString("partitionSchema"));
            value[2] = Utils.VectorToString(partitionScheme);
            value[3] = " ";
            Entity engineType = ((BasicDictionary)dbInfo).get((Scalar)new BasicString("engineType"));
            value[4] = "\"" + engineType.getString() + "\"";
            Entity atomic = ((BasicDictionary)dbInfo).get((Scalar)new BasicString("atomic"));
            value[5] = "\"" + atomic.getString() + "\"";
            StringBuilder sb = new StringBuilder("system_db").append(" = database(");
            Utils.joinOrder(sb, value, ",");
            sb.append(");\n");
            this.sqlSb = new StringBuilder();
            this.sqlSb.append((CharSequence)sb);
            this.dbConnection.run(sb.toString());
            if (value[0].trim().startsWith("\"dfs://")) {
                this.isDFS = true;
                this.databases = value[0];
                this.tables = (Vector)this.dbConnection.run("getTables(system_db)");
                StringBuilder loadTableSb = new StringBuilder();
                int len = this.tables.rows();
                for (int i = 0; i < len; ++i) {
                    String name = this.tables.get(i).getString();
                    loadTableSb.append(name).append(" = ").append("loadTable(").append("system_db").append(",`").append(name).append(");\n");
                }
                this.sqlSb.append((CharSequence)loadTableSb);
                String sql = loadTableSb.toString();
                this.dbConnection.run(sql);
            }
            if ((controllerAlias = this.dbConnection.run("getControllerAlias()").getString()) != null && controllerAlias.length() > 0) {
                this.isDFS = true;
                this.controlHost = this.dbConnection.run("rpc(\"" + controllerAlias + "\", getNodeHost)").getString();
                this.controlPort = ((BasicInt)this.dbConnection.run("rpc(\"" + controllerAlias + "\", getNodePort)")).getInt();
                this.controlConnection = new DBConnection();
                this.controlConnection.connect(this.controlHost, this.controlPort);
                BasicTable table = (BasicTable)this.controlConnection.run("getClusterChunkNodesStatus()");
                Vector siteVector = table.getColumn("site");
                this.hostName_ports = new LinkedList<String>();
                int len = siteVector.rows();
                for (int i = 0; i < len; ++i) {
                    this.hostName_ports.add(siteVector.get(i).getString());
                }
            } else {
                this.isDFS = false;
            }
        }
        if (hasScripts != null && (length = Integer.parseInt(prop.getProperty("length"))) > 0) {
            for (int i = 0; i < length; ++i) {
                this.dbConnection.run(prop.getProperty("script" + i));
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIsClosed();
        return new JDBCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new JDBCPrepareStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new JDBCCallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        this.checkIsClosed();
        return s;
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIsClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        Driver.unused("commit not implemented");
    }

    @Override
    public void rollback() throws SQLException {
        Driver.unused("rollback not implemented");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.dbConnection.close();
        this.dbConnection = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dbConnection == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIsClosed();
        if (this.metaData == null) {
            this.metaData = new JDBCDataBaseMetaData(this, null);
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        this.checkIsClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIsClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Driver.unused("setCatalog not implemented");
    }

    @Override
    public String getCatalog() throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (this.databases != null) {
            return this.databases;
        }
        try {
            BasicStringVector dbs = (BasicStringVector)this.dbConnection.run("getClusterDFSDatabases()");
            for (int i = 0; i < dbs.rows(); ++i) {
                sb.append(dbs.getString(i) + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Driver.unused("getTypeMap not implemented");
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Driver.unused("setSavepoint not supported");
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Driver.unused("rollback not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Driver.unused("releaseSavepoint not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIsClosed();
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIsClosed();
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        Driver.unused("createClob not implemented");
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Driver.unused("createBlob not implemented");
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        Driver.unused("createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Driver.unused("createSQLXML()");
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.dbConnection.isConnected();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        this.checkIsClosed();
        return aClass.isInstance(this);
    }

    private void checkIsClosed() throws SQLException {
        if (this.dbConnection == null) {
            throw new SQLException("connection isClosed");
        }
        if (this == null || this.isClosed()) {
            throw new SQLException("connection isClosed");
        }
    }

    public Entity run(String function, List<Entity> arguments) throws IOException {
        if (!this.isDFS) {
            return this.dbConnection.run(function, arguments);
        }
        int size = this.hostName_ports.size();
        Entity entity = null;
        try {
            entity = this.dbConnection.run(function, arguments);
            return entity;
        }
        catch (IOException e) {
            for (int index = 0; index < size; ++index) {
                String[] hostName_port = this.hostName_ports.get(index).split(":");
                if (hostName_port[0] == this.hostName && Integer.parseInt(hostName_port[1]) == this.port) continue;
                this.dbConnection = new DBConnection();
                try {
                    boolean succeeded = this.getUser() != null && this.getPassword() != null ? this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]), this.getUser(), this.getPassword()) : this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]));
                    if (!succeeded) continue;
                    this.dbConnection.run(this.sqlSb.toString());
                    entity = this.dbConnection.run(function, arguments);
                    return entity;
                }
                catch (IOException e1) {
                    return entity;
                }
            }
            throw new IOException("All dataNodes were dead");
        }
    }

    public Entity run(String script) throws IOException {
        if (!this.isDFS) {
            return this.dbConnection.run(script);
        }
        Matcher matcher = Utils.ASSIGN_PATTERN.matcher(script = script.trim());
        if (matcher.find()) {
            this.sqlSb.append(script).append(";\n");
        }
        int size = this.hostName_ports.size();
        Entity entity = null;
        try {
            entity = this.dbConnection.run(script);
            return entity;
        }
        catch (IOException e) {
            for (int index = 0; index < size; ++index) {
                String[] hostName_port = this.hostName_ports.get(index).split(":");
                if (hostName_port[0] == this.hostName && Integer.parseInt(hostName_port[1]) == this.port) continue;
                this.dbConnection = new DBConnection();
                try {
                    boolean succeeded = this.getUser() != null && this.getPassword() != null ? this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]), this.getUser(), this.getPassword()) : this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]));
                    if (!succeeded) continue;
                    this.dbConnection.run(this.sqlSb.toString());
                    entity = this.dbConnection.run(script);
                    return entity;
                }
                catch (IOException e1) {
                    return entity;
                }
            }
            throw new IOException("All dataNodes were dead");
        }
    }

    public Entity run(String script, int fetchSize) throws IOException {
        if (!this.isDFS) {
            return this.dbConnection.run(script, (ProgressListener)null, 4, 2, fetchSize);
        }
        Matcher matcher = Utils.ASSIGN_PATTERN.matcher(script = script.trim());
        if (matcher.find()) {
            this.sqlSb.append(script).append(";\n");
        }
        int size = this.hostName_ports.size();
        Entity entity = null;
        try {
            entity = this.dbConnection.run(script);
            return entity;
        }
        catch (IOException e) {
            for (int index = 0; index < size; ++index) {
                String[] hostName_port = this.hostName_ports.get(index).split(":");
                if (hostName_port[0] == this.hostName && Integer.parseInt(hostName_port[1]) == this.port) continue;
                this.dbConnection = new DBConnection();
                try {
                    boolean succeeded = this.getUser() != null && this.getPassword() != null ? this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]), this.getUser(), this.getPassword()) : this.dbConnection.connect(hostName_port[0], Integer.parseInt(hostName_port[1]));
                    if (!succeeded) continue;
                    this.dbConnection.run(this.sqlSb.toString());
                    entity = this.dbConnection.run(script, (ProgressListener)null, 4, 2, fetchSize);
                    return entity;
                }
                catch (IOException e1) {
                    return entity;
                }
            }
            throw new IOException("All dataNodes were dead");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getHostName() {
        if (this.dbConnection != null) {
            return this.dbConnection.getHostName();
        }
        return null;
    }

    public int getPort() {
        if (this.dbConnection != null) {
            return this.dbConnection.getPort();
        }
        return -1;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.databases;
    }
}

